/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.constant.DataConfigConstant;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RadioGroupVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/radioGroup/el_radioGroup.ftl");
        lcdpComponent.addRenderParam("styleType", lcdpComponent.getProps().get("styleType"));
        lcdpComponent.addRenderParam("id", (Object)lcdpComponent.getInstanceKey());
        List<Map<String, String>> getLabelAddValue = this.getLabelAddValue(lcdpComponent, false);
        lcdpComponent.addRenderParam("labelKey", (Object)getLabelAddValue.get(0).get("labelKey"));
        lcdpComponent.addRenderParam("valueKey", (Object)getLabelAddValue.get(0).get("valueKey"));
        this.renderData(lcdpComponent, ctx);
        this.renderOptionLoad(lcdpComponent, ctx);
        this.renderAttrs(lcdpComponent, ctx);
    }

    private List<Map<String, String>> getLabelAddValue(LcdpComponent lcdpComponent, boolean isData) {
        ArrayList<Map<String, String>> labelAddValueList = new ArrayList<Map<String, String>>();
        String labelKey = "name";
        String valueKey = "value";
        String cusLabel = "cusLabel";
        String cusValue = "cusValue";
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get(cusLabel))) {
            labelKey = String.valueOf(lcdpComponent.getProps().get("cusLabel"));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get(cusValue))) {
            valueKey = String.valueOf(lcdpComponent.getProps().get("cusValue"));
        }
        if (isData) {
            JSONArray optionArray = (JSONArray)lcdpComponent.getProps().get("options");
            for (Object option : optionArray) {
                JSONObject optionObj = (JSONObject)option;
                HashMap<String, String> labelAddValue = new HashMap<String, String>(2);
                labelAddValue.put(labelKey, optionObj.getString("name"));
                labelAddValue.put(valueKey, optionObj.getString("value"));
                labelAddValueList.add(labelAddValue);
            }
            return labelAddValueList;
        }
        HashMap<String, String> labelAddValue = new HashMap<String, String>(2);
        labelAddValue.put("labelKey", labelKey);
        labelAddValue.put("valueKey", valueKey);
        labelAddValueList.add(labelAddValue);
        return labelAddValueList;
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        Map props = lcdpComponent.getProps();
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealDisabledAttr(lcdpComponent, ctx);
        dealFormDataVisitor.dealReadonlyAttr(lcdpComponent, ctx);
        Boolean hiddenValue = props.get("hidden") != null ? props.get("hidden") : Boolean.valueOf(false);
        ctx.addData(lcdpComponent.getInstanceKey() + "Hidden: " + hiddenValue);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String defaultOptionValue = null != lcdpComponent.getProps().get("options") ? JSON.toJSONString(this.getLabelAddValue(lcdpComponent, true)) : "[]";
        String optionValue = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION.getType(), Collections.singletonList("data"), (String)defaultOptionValue);
        lcdpComponent.addRenderParam("optionValue", (Object)optionValue);
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)"''");
        lcdpComponent.addRenderParam("bindData", (Object)valueData);
    }

    private void renderOptionLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        boolean isBindData = false;
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
            Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
            String labelField = "";
            String valueField = "";
            if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                        List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                        if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                            labelField = dataSFieldAnalysis.getFieldName();
                        }
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                        valueField = dataSFieldAnalysis.getFieldName();
                    }
                }
            } else if (DataConfigConstant.CommonModelCategory.DICT.getVal().equals(dataSAnalysis.getDatamodel().getDataModelId())) {
                labelField = "label";
                valueField = "value";
            }
            if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                String sortConditionName;
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                isBindData = true;
                HashMap<String, CharSequence> selectMap = new HashMap<String, CharSequence>();
                String operationName = "hussarQuery";
                if (DataConfigConstant.CommonModelCategory.DICT.getVal().equals(dataSAnalysis.getDatamodel().getDataModelId())) {
                    operationName = DataConfigConstant.CommonModelCategory.DICT.getImportMethod();
                }
                String dataSelectId = lcdpComponent.getInstanceKey();
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                    selectMap.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    selectMap.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                    operationName = operationName + sortConditionName;
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                List<Map<String, String>> getLabelAddValue = this.getLabelAddValue(lcdpComponent, false);
                selectMap.put("importName", apiFileName);
                selectMap.put("importMethod", operationName);
                selectMap.put("insOption", dataSelectId + "Options");
                selectMap.put("label", labelField);
                selectMap.put("value", valueField);
                selectMap.put("dictType", dataSAnalysis.getDatamodel().getDictType());
                selectMap.put("labelKey", getLabelAddValue.get(0).get("labelKey"));
                selectMap.put("valueKey", getLabelAddValue.get(0).get("valueKey"));
                selectMap.putAll(lcdpComponent.getRenderParamsToBind());
                ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/radioGroup/radio_optionLoadMethod.ftl", selectMap));
                ctx.addMounted(CodePrefix._THIS.getType() + lcdpComponent.getInstanceKey() + "OptionLoad();");
            }
        }
        if (!isBindData) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionLoad", "");
        }
    }
}

