/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.Action;
import com.jxdinfo.speedcode.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.common.utils.ReplaceDataUtil;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.ExportQueryExcelDataAction")
public class ExportQueryExcelData
implements ActionVisitor {
    private final FileMappingService fileMappingService;

    @Autowired
    public ExportQueryExcelData(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        Map params = action.getParamValues();
        String dataTableId = String.valueOf(params.get("exportExcelData"));
        String componentName = "";
        Boolean isPagination = false;
        String dataName = "";
        Boolean isHiddenCols = false;
        if (ToolUtil.isNotEmpty(params.get("isHiddenCols"))) {
            isHiddenCols = (Boolean)params.get("isHiddenCols");
            map.put("isHiddenCols", isHiddenCols);
        }
        ValueVisitor valueVisitor = null;
        if (ToolUtil.isNotEmpty((Object)dataTableId)) {
            componentName = ((LcdpComponent)ctx.getComponentMap().get(dataTableId)).getName().substring(22);
            LcdpComponent tableLcdpComponent = (LcdpComponent)ctx.getComponentMap().get(dataTableId);
            List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)tableLcdpComponent, (String)"showConfigs");
            if (ToolUtil.isNotEmpty((Object)showConfigAnalyses)) {
                boolean isNotEmptyDataModelId = ToolUtil.isNotEmpty((Object)((ShowConfigAnalysis)showConfigAnalyses.get(0)).getDataModelId());
                boolean isNotEmptyField = ToolUtil.isNotEmpty((Object)((ShowConfigAnalysis)showConfigAnalyses.get(0)).getField());
                boolean isNotEmptyRelateField = ToolUtil.isNotEmpty((Object)((ShowConfigAnalysis)showConfigAnalyses.get(0)).getRelateField());
                if (isNotEmptyDataModelId && isNotEmptyField && isNotEmptyRelateField) {
                    List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, (List)showConfigAnalyses);
                    map.put("showConfigItemInfos", showConfigItemInfos);
                }
            }
            JSONArray optColsJSONArray = (JSONArray)tableLcdpComponent.getProps().get("opt_cols");
            JSONArray optColsLeftFixed = new JSONArray();
            JSONArray optColsRightFixed = new JSONArray();
            JSONArray optColsNormal = new JSONArray();
            for (Object optCol : optColsJSONArray) {
                JSONObject fixed = ((JSONObject)optCol).getJSONObject("fixed");
                if (ToolUtil.isNotEmpty((Object)fixed) && fixed.getBoolean("left").booleanValue()) {
                    optColsLeftFixed.add(optCol);
                    continue;
                }
                if (ToolUtil.isNotEmpty((Object)fixed) && fixed.getBoolean("right").booleanValue()) {
                    optColsRightFixed.add(optCol);
                    continue;
                }
                optColsNormal.add(optCol);
            }
            optColsLeftFixed.addAll((Collection)optColsNormal);
            optColsLeftFixed.addAll((Collection)optColsRightFixed);
            map.put("tableShowFields", optColsLeftFixed);
            JSONArray optColsCopy = (JSONArray)optColsLeftFixed.clone();
            if (isHiddenCols.booleanValue()) {
                JSONArray hiddenCols = (JSONArray)tableLcdpComponent.getProps().get("hidden_cols");
                map.put("tableHiddenFields", hiddenCols);
                optColsCopy.addAll((Collection)hiddenCols);
            }
            JSONArray tableFields = this.getAllColumns(optColsCopy);
            map.put("tableFields", tableFields);
            Map<String, Object> tableMap = this.renderTableLoad(tableLcdpComponent, ctx, showConfigAnalyses);
            map.putAll(tableMap);
            isPagination = (Boolean)tableLcdpComponent.getProps().get("isPagination");
            valueVisitor = (ValueVisitor)tableLcdpComponent.getProvideVisitor("value");
            if (ToolUtil.isNotEmpty((Object)valueVisitor)) {
                valueVisitor.visit(tableLcdpComponent, ctx, null);
                dataName = valueVisitor.getDataItemValue(null).getRenderValue();
            }
            map.put("dataName", dataName);
            map.put("componentName", componentName);
            boolean isSortOverall = this.isSortOverall(tableLcdpComponent, ctx);
            if (isSortOverall) {
                map.put("isSortOverall", isSortOverall);
            }
        }
        renderCore.registerTemplatePath("/template/elementui/event/ExportQueryExcelData.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        if (ToolUtil.isNotEmpty(map.get("showConfigItemInfos")) || isPagination.booleanValue()) {
            Object obj;
            LcdpComponent rootComponent = ctx.getRootLcdpComponent();
            ArrayList<String> importNames = null;
            if (ToolUtil.isNotEmpty(rootComponent.getRenderParams().get("async")) && (obj = rootComponent.getRenderParams().get("async")) instanceof List) {
                importNames = new ArrayList();
                for (Object o : (List)obj) {
                    importNames.add((String)o);
                }
            }
            if (ToolUtil.isNotEmpty(importNames)) {
                importNames.add(triggerName);
            } else {
                importNames = new ArrayList<String>();
                importNames.add(triggerName);
            }
            rootComponent.addRenderParam("async", importNames);
        }
        map.put("trigger", triggerName);
        map.put("tableInstanceKey", dataTableId);
        renderCore.registerParam(map);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
            ctx.addImports("import { saveAs } from 'file-saver'");
        }
    }

    public Map<String, Object> renderTableLoad(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        String operationName = "hussarQuery";
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("flowTable")) && ((Boolean)lcdpComponent.getProps().get("flowTable")).booleanValue()) {
            operationName = "hussarFlowQuery";
        }
        String dataTableId = lcdpComponent.getInstanceKey();
        String operationNameByOrderOverall = "";
        String apiFileName = "";
        String apiFilePath = "";
        StringBuilder queryAttr = new StringBuilder(128);
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        Map fields = new HashMap();
        String primary = "";
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            Object isPagination;
            String sortConditionName;
            DataSortConditionAnalysis dataSortConditionAnalysis;
            DataSConditionAnalysis dataSConditionAnalysis;
            fields = dataSModelAnalysis.getFields();
            String dataModelId = dataSModelAnalysis.getDataModelId();
            if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                if (ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId).getPrimaryField())) {
                    primary = DataModelUtil.getDataModelBase((String)dataModelId).getPrimaryField().getName();
                }
                apiFileName = this.fileMappingService.getFileName(dataModelId);
                apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
            }
            if (ToolUtil.isNotEmpty((Object)(dataSConditionAnalysis = dataSModelAnalysis.getCondition()))) {
                List conditionList = dataSConditionAnalysis.getQueryConditionModelList();
                queryAttr = QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx);
                String querySelectionName = dataSConditionAnalysis.getSelectCondition();
                if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                    operationName = operationName + querySelectionName;
                }
            }
            if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                operationName = operationName + sortConditionName;
            }
            if (ToolUtil.isNotEmpty(isPagination = lcdpComponent.getProps().get("isPagination")) && Boolean.parseBoolean(isPagination.toString())) {
                operationName = operationName + CodeSuffix._TABLE_PAGE_SUFFIX.getType();
                Boolean isTableLoadByOrderDy = (Boolean)lcdpComponent.getProps().get("isSortOverall");
                if (ToolUtil.isNotEmpty((Object)isTableLoadByOrderDy) && Boolean.valueOf(isTableLoadByOrderDy.toString()).booleanValue()) {
                    operationNameByOrderOverall = operationName + CodeSuffix._TABLE_ORDER_CUSTOM_SUFFIX.getType();
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
        }
        tableMap.put("importMethodByOrderDy", operationNameByOrderOverall);
        tableMap.put("importName", apiFileName);
        tableMap.put("importMethod", operationName);
        tableMap.put("instanceKey", dataTableId);
        tableMap.put("queryAttr", queryAttr);
        tableMap.putAll(lcdpComponent.getRenderParamsToBind());
        JSONArray optCols = (JSONArray)tableMap.get("opt_cols");
        JSONArray hiddenCols = (JSONArray)tableMap.get("hidden_cols");
        List cols = JSON.parseArray((String)optCols.toJSONString(), TableOptColsAnalysis.class);
        if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
            List hidden = JSON.parseArray((String)hiddenCols.toJSONString(), TableOptColsAnalysis.class);
            cols.addAll(hidden);
        }
        ArrayList<String> args = new ArrayList<String>(1);
        args.add("colIndex");
        ctx.addMethod(dataTableId + "ExcelExportForArea", args, RenderUtil.renderTemplate((String)"/template/elementui/event/ExcelDownloadAndExportForArea.ftl", tableMap));
        ArrayList<TableOptColsAnalysis> realCols = new ArrayList<TableOptColsAnalysis>();
        this.getCols(cols, realCols);
        HashMap<String, String> colFields = new HashMap<String, String>();
        String col = "";
        String field = "";
        if (ToolUtil.isNotEmpty(fields) && ToolUtil.isNotEmpty(realCols)) {
            for (TableOptColsAnalysis tableOptColsAnalysis : realCols) {
                boolean flag = true;
                for (List modelField : fields.values()) {
                    List dataItems;
                    if (modelField.size() <= 0 || !ToolUtil.isNotEmpty((Object)tableOptColsAnalysis) || !ToolUtil.isNotEmpty((Object)(dataItems = ((DataSFieldAnalysis)modelField.get(0)).getDataItemPath())) || dataItems.size() <= 1 || !tableOptColsAnalysis.getId().equals(dataItems.get(1))) continue;
                    col = tableOptColsAnalysis.getField();
                    field = ((DataSFieldAnalysis)modelField.get(0)).getFieldName();
                    colFields.put(col, field);
                    flag = false;
                    break;
                }
                if (!flag) continue;
                col = tableOptColsAnalysis.getField();
                colFields.put(col, col);
            }
        }
        boolean containPrimary = false;
        if (ToolUtil.isNotEmpty(fields)) {
            for (List modelField : fields.values()) {
                if (modelField.size() <= 0 || !primary.equals(((DataSFieldAnalysis)modelField.get(0)).getFieldName())) continue;
                containPrimary = true;
                break;
            }
        }
        if (!containPrimary && ToolUtil.isNotEmpty((Object)primary)) {
            colFields.put(primary, primary);
        }
        tableMap.put("colFields", colFields);
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("flowTable")) && ((Boolean)lcdpComponent.getProps().get("flowTable")).booleanValue()) {
            tableMap.put("isFlowTable", true);
        }
        return tableMap;
    }

    private void getCols(List<TableOptColsAnalysis> cols, List<TableOptColsAnalysis> realCols) {
        for (TableOptColsAnalysis col : cols) {
            boolean isNotEmptyCol = ToolUtil.isNotEmpty((Object)col);
            boolean isNotEmptyChildren = ToolUtil.isNotEmpty((Object)col.getChildren());
            if (!isNotEmptyCol) continue;
            if (isNotEmptyChildren) {
                List childrenCols = col.getChildren();
                this.getCols(childrenCols, realCols);
                continue;
            }
            realCols.add(col);
        }
    }

    private JSONArray getAllColumns(JSONArray cols) {
        JSONArray allColumns = new JSONArray();
        for (Object col : cols) {
            JSONObject colObj = (JSONObject)col;
            if (Boolean.TRUE.equals(colObj.getBoolean("isParent"))) {
                JSONArray allChildCols = this.getAllColumns(colObj.getJSONArray("children"));
                for (Object childCol : allChildCols) {
                    JSONObject childColObj = (JSONObject)childCol;
                    allColumns.add((Object)childColObj);
                }
                continue;
            }
            allColumns.add((Object)colObj);
        }
        return allColumns;
    }

    private boolean isSortOverall(LcdpComponent lcdpComponent, Ctx ctx) {
        boolean isSortOverallFlag = false;
        Object isPagination = lcdpComponent.getProps().get("isPagination");
        Boolean isSortOverall = (Boolean)lcdpComponent.getProps().get("isSortOverall");
        if (ToolUtil.isNotEmpty((Object)isSortOverall) && isSortOverall.booleanValue() && ToolUtil.isNotEmpty(isPagination) && Boolean.valueOf(isPagination.toString()).booleanValue()) {
            lcdpComponent.addRenderParam("isSortChange", (Object)isSortOverall);
            isSortOverallFlag = isSortOverall;
        }
        return isSortOverallFlag;
    }
}

