<template>
    <div class="lcdp_axe_main">
    <div class="lcdp_axe jxd_ins_elBaseWebPage jxd_additional ${pageName} ${rootInstanceKey}">
        ${body!}
        <#if showFlowFileDialog?? && showFlowFileDialog>
            <el-dialog class="flowchart-dialog"
                   :visible="${instanceKey!}ShowFlowFileDialog"
                   :show-close="false"
                   :append-to-body="true"
                   :close-on-click-modal="false"
                   :close-on-press-escape="false">
                <flowfile
                        v-if="${instanceKey!}ShowFlowFileDialog"
                        class="workflow"
                        :businessKey="${instanceKey!}ShowPicProcessKey"
                        :show="${instanceKey!}ShowFlowFileDialog"
                        @close="${instanceKey!}ShowFlowFileDialog=false">
                </flowfile>
            </el-dialog>
        </#if>
        <#if showFlowFile?? && showFlowFile>
            <flowfile
                    v-if="${instanceKey!}ShowFlowFile"
                    class="workflow"
                    :businessKey="${instanceKey!}ShowPicProcessKey"
                    :show="${instanceKey!}ShowFlowFile"
                    @close="${instanceKey!}ShowFlowFile=false">
            </flowfile>
        </#if>
        <#if participantDialog?? && participantDialog>
            <participantDialog @close="${instanceKey!}ParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmParticipant" :selectionBackup='${instanceKey!}SelectionBackup' :tableData ='${instanceKey!}ParticipantData'  :participantDialogVisible='${instanceKey!}ParticipantDialogVisible'>
            </participantDialog>
        </#if>
        <#if consignorDialog?? && consignorDialog>
            <consignorDialog @close="${instanceKey!}ConsignorDialogVisible = false" @comfirm="${instanceKey!}ComfirmConsignor" :selectionBackup='${instanceKey!}SelectedConsignorBackup' :tableData ='${instanceKey!}ConsignorData'  :consignorDialogVisible='${instanceKey!}ConsignorDialogVisible'>
            </consignorDialog>
        </#if>
        <#if customFlowNode?? && customFlowNode>
            <customFlowNode @close="${instanceKey!}CustomFlowNodeVisible = false" :customFlowNodeVisible="${instanceKey!}CustomFlowNodeVisible">
            </customFlowNode>
        </#if>
        <#if customFlowNodeSingle?? && customFlowNodeSingle>
            <customFlowNodeSingle @close="${instanceKey!}CustomFlowNodeSingleVisible = false" :customFlowNodeVisible="${instanceKey!}CustomFlowNodeSingleVisible">
            </customFlowNodeSingle>
        </#if>
        <#if showSelectParticipant??>
            <#list showSelectParticipant as currentKey>
                <selectParticipant @close="${instanceKey!}${currentKey!}SelectParticipantShow = false" :selectParticipantShow="${instanceKey!}${currentKey!}SelectParticipantShow" @save="${instanceKey!}${currentKey!}FlowFormSubmitSave" :taskId="taskId" :processDefinitionKey="processDefinitionKey" :doneListIdentification="doneListIdentification ? doneListIdentification : '0'">
                </selectParticipant>
            </#list>
        </#if>
        <#if showLaunchCirculated??>
            <#list showLaunchCirculated as currentKey>
                <LaunchCirculated @showLaunchCirculatedExecuteFunction="${instanceKey!}${currentKey!}ShowLaunchCirculatedExecuteFunction" @close="${instanceKey!}${currentKey!}LaunchCirculatedShow = false" :launchCirculatedShow="${instanceKey!}${currentKey!}LaunchCirculatedShow" :taskId="${instanceKey!}${currentKey!}LaunchCirculatedTaskId" :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </LaunchCirculated>
            </#list>
        </#if>
        <#if showSelectCoJudge??>
            <#list showSelectCoJudge as currentKey>
                <selectCoJudge @close="${instanceKey!}${currentKey!}SelectCoJudgeShow = false" :selectCoJudgeShow="${instanceKey!}${currentKey!}SelectCoJudgeShow" @save="${instanceKey!}${currentKey!}CoJudgeSave">
                </selectCoJudge>
            </#list>
        </#if>
        <#if showSelectEntrust??>
            <#list showSelectEntrust as currentKey>
                <selectEntrust @close="${instanceKey!}${currentKey!}SelectEntrustShow = false" :selectEntrustShow="${instanceKey!}${currentKey!}SelectEntrustShow" @save="${instanceKey!}${currentKey!}TaskEntrustSave">
                </selectEntrust>
            </#list>
        </#if>
        <#if showSelectRejectNode??>
            <#list showSelectRejectNode as currentKey>
                <selectRejectNode @close="${instanceKey!}${currentKey!}SelectRejectNodeShow = false" :selectRejectNodeShow="${instanceKey!}${currentKey!}SelectRejectNodeShow" @save="${instanceKey!}${currentKey!}AnyNodeRejectSave" :taskId="selectRejectNodeTaskId" :doneListIdentification="selectRejectNodeDoneListIdentification ? selectRejectNodeDoneListIdentification : '0'">
                </selectRejectNode>
            </#list>
        </#if>
        <#if showFreeReject?? && showFreeReject>
            <freeReject @close="${instanceKey!}FreeRejectShow = false" :freeRejectShow="${instanceKey!}FreeRejectShow" :taskId="showFreeRejectTaskId" :flowEventData="${instanceKey!}FlowEventData">
            </freeReject>
        </#if>
        ${slotCodes.default!}
        ${slot_title!}
        ${slotCodes.treeContextMenu!}
    </div>
    </div>
</template>

<script>
    <#list importScripts! as imp>
        ${imp};
    </#list>
    /* ${directives.definitionsBegin} */
    /* ${directives.definitionsEnd} */
    export default {
        name: "${pageName!}",
        components: {
                <#list components as component>
                ${component},
                </#list>
        },
        <#if props?? && (props?size>0)>
            props: {
            <#list props as prop>
                ${prop.paramName}: ${prop.paramDataType?cap_first},
            </#list>
                },
        </#if>
        data() {
            return {
                <#if dicts?? && dicts?size gt 0>
                dictOptions: [], // 字典数据
                </#if>
                <#if levelDicts?? && levelDicts?size gt 0>
                levelDictOptions: [], // 多级字典数据
                </#if>
                <#list datas as data>
                ${data},
                </#list>
                /* ${directives.dataBegin} */
                /* ${directives.dataEnd} */
            }
        },
        computed: {
            <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                ${key}(${computed.argBody!}){
                    const self = this;
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                ${key}:{
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            /* ${directives.computedBegin} */
            /* ${directives.computedEnd} */
        },
        watch: {
            <#list watches?keys as key>
            <#assign watch=watches[key]>
                <#if (key!?index_of('\'') > -1)>
                    ${key}:{
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                <#else>
                    ${key}(${watch.argBody!}){
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                </#if>
            </#list>
            /* ${directives.watchBegin} */
            /* ${directives.watchEnd} */
        },
        methods: {
            <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            /**
             * 查询字典数据
             */
            async queryDictOptions() {
                const self = this;
                <#if dicts?? && dicts?size gt 0>
                const queryDictObj = {
                    typeNames: '<#list dicts[0 ..! dicts?size - 1] as dict>${dict},</#list>${dicts[dicts?size - 1]}'
                };
                await dict.${dictMethod}(queryDictObj).then((res) => {
                    if (res.code === 10000 || res.code === 200) {
                    self.dictOptions = res.data;
                    <#list optionLoads as optionLoad>
                    ${optionLoad}
                    </#list>
                } else {
                    self.$message.error('字典数据请求错误');
                }
            }).catch(function () {
                    self.$message.error('字典数据请求异常');
                });
                </#if>
                <#if levelDicts?? && levelDicts?size gt 0>
                const queryLevelDictObj = {
                    typeNames: '<#list levelDicts[0 ..! levelDicts?size - 1] as levelDict>${levelDict},</#list>${levelDicts[levelDicts?size - 1]}'
                };
                await dict.${treeMethod}(queryLevelDictObj).then((res) => {
                    if (res.code === 10000 || res.code === 200) {
                    self.levelDictOptions = res.data;
                    <#list treeLoads as treeLoad>
                    ${treeLoad}
                    </#list>
                } else {
                    self.$message.error('字典数据请求错误');
                }
            }).catch(function () {
                    self.$message.error('字典数据请求异常');
                });
                </#if>
            },
            </#if>
            <#list methods?keys as key>
                <#assign method=methods[key]>
                <#assign importName=key>
            <#if async?? && async?size gt 0>
            <#list async! as async_importName>
            <#if async_importName == key>
            <#assign importName=("async " + key)?string>
            </#if>
            </#list>
            </#if>
            ${importName}(${method.argBody!}){
                    const self = this;
                    <#list method.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            /* ${directives.methodsBegin} */
            /* ${directives.methodsEnd} */
        },
        <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
        async </#if> created() {
            const self = this;
            // ${directives.createdBeforeBegin}
            // ${directives.createdBeforeEnd}
            <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
            // 查询字典数据
            await self.queryDictOptions();
            </#if>
            <#list createds! as created>
            ${created}
            </#list>
            // ${directives.createdAfterBegin}
            // ${directives.createdAfterEnd}
        },
        mounted() {
            const self = this;
            // ${directives.mountedBeforeBegin}
            // ${directives.mountedBeforeEnd}
            <#list mounteds! as mounted>
                ${mounted}
            </#list>
            <#if isOnload?? && isOnload>
                self.${rootInstanceKey!}Onload();
            </#if>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if polls?? && (polls?size>0)>
                    <#list polls as poll>
                        <#assign str = poll.eventName?cap_first/>
                        <#list methods?keys as key>
                            <#if key == rootInstanceKey + str>
                            self.${key}Destroy = setInterval(() => {
                            const self = this;
                                self.${key}();
                                },<#if poll.pollTime??>${poll.pollTime?c}</#if>);
                            </#if>
                        </#list>
                    </#list>
                </#if>
            </#if>
            // ${directives.mountedAfterBegin}
            // ${directives.mountedAfterEnd}
        },
        filters: {
            <#list filters?keys as key>
            <#assign filter=filters[key]>
            ${key}(${filter.argBody!}){
                <#list filter.bodies as body>
                ${body}
                </#list>
            },
            </#list>
        },
        destroyed() {
            const self = this;
            // ${directives.destroyedBeforeBegin}
            // ${directives.destroyedBeforeEnd}
            <#list destroyeds! as destroyed>
                ${destroyed}
            </#list>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if destroyPolls?? && (destroyPolls?size>0)>
                    <#list destroyPolls! as destroyPoll>
                        clearInterval(self.${destroyPoll});
                    </#list>
                </#if>
            </#if>
            // ${directives.destroyedAfterBegin}
            // ${directives.destroyedAfterEnd}
        },
        activated() {
            const self = this;
            <#list activateds! as activated>
                ${activated}
            </#list>
        },
        beforeRouteLeave(to, from, next){
            const self = this;
            <#list beforeRouteLeaves! as beforeRouteLeave>
                ${beforeRouteLeave}
            </#list>
            next();
        },
        /* ${directives.optionsBegin} */
        /* ${directives.optionsEnd} */
}
</script>

<!-- ${directives.styleBeforeBegin} -->
<!-- ${directives.styleBeforeEnd} -->

<style scoped>
    /*公共，用于固定*/
    .lcdp_axe_main{transform: scale(1);height: 100%;overflow: auto}
    /*公共，用于设置文字提示的最大宽度*/
    .el-tooltip__popper{
        max-width: 500px;
    }
    ${styles!}
    ${hyperlinksSpan}
</style>

<!-- ${directives.styleAfterBegin} -->
<!-- ${directives.styleAfterEnd} -->
