/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.common.analysismodel.tree.TreeRelativeDataAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElTree.value")
@Scope(value="prototype")
public class TreeValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("id", "id");
        map.put("pid", "pid");
        map.put("label", "label");
        map.put("levelName", "levelName");
        JSONArray colsJson = (JSONArray)this.lcdpComponent.getProps().get("relativeData");
        if (ToolUtil.isNotEmpty((Object)colsJson)) {
            List colsList = colsJson.toJavaList(TreeRelativeDataAnalysis.class);
            colsList.forEach(col -> map.put(col.getId(), col.getField()));
        }
        return map;
    }

    public String getDefaultValue() {
        return null;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            this.getSelectAndTreeData(dataItems, data, dataItems.get(0));
        } else {
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("data");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem));
        }
        return data;
    }

    private void getSelectAndTreeData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        String dataValue;
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        boolean isTreeValue = false;
        if (dataItem.equals("data")) {
            isTreeValue = true;
            currDataItem.add("data");
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem);
        } else {
            currDataItem.add("checkedData");
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TREE_DATA_CHECKED.getType(), currDataItem);
        }
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            Map<String, String> treeColMapping = this.getComponentColMapping();
            this.getColData(dataItems, data, dataValue, treeColMapping, isTreeValue);
        } else {
            data.setRenderValue(dataValue);
        }
    }

    private void getColData(List<String> dataItems, ComponentData data, String dataValue, Map<String, String> treeColMapping, boolean isTreeData) {
        String fieldId = dataItems.get(1);
        if (ToolUtil.isNotEmpty(treeColMapping) && treeColMapping.containsKey(fieldId)) {
            if (isTreeData) {
                ComponentDataUtil.addPackageTreeFieldMethod((Ctx)this.ctx);
                data.setRenderValue("function(){\nlet result = [];\nself.packageTreeField(result, " + dataValue + ", '" + treeColMapping.get(fieldId) + "');\nreturn result;}()");
            } else {
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + treeColMapping.get(fieldId) + "));return result;}()");
            }
        }
    }
}

