/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.Action;
import com.jxdinfo.speedcode.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.datasource.model.meta.DataModelBase;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.ExportTablePDFAction")
public class PdfTableExport
implements ActionVisitor {
    private final FileMappingService fileMappingService;

    @Autowired
    public PdfTableExport(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        String formInstanceKey;
        HashMap<String, Object> moduleMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/elementui/event/PdfTableExport.ftl");
        ctx.addImports("import hussarRequest from '@/pages/index/utils/hussar-default-request'");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("exportTablePdf")));
        String dir = jsonObject.getString("dir");
        String name = jsonObject.getString("name");
        LcdpComponent parentLcdpComponent1 = ctx.getCurrentLcdpComponent().getParentLcdpComponent();
        if (ToolUtil.isNotEmpty((Object)parentLcdpComponent1) && ToolUtil.isNotEmpty((Object)(formInstanceKey = parentLcdpComponent1.getInstanceKey()))) {
            moduleMap.put("formInstanceKey", formInstanceKey);
        }
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        moduleMap.put("trigger", triggerName);
        String filePath = dir + "/" + name;
        moduleMap.put("templatePath", dir);
        moduleMap.put("templateName", name);
        Map componentMap = ctx.getComponentMap();
        JSONObject json = (JSONObject)action.getParamValues().get("copyRow");
        String tableId = (String)json.get((Object)"instanceKey");
        StringBuilder options = new StringBuilder();
        StringBuilder fields = new StringBuilder();
        options.append("'\u5e8f\u53f7',");
        if (ToolUtil.isNotEmpty((Object)tableId)) {
            List colsList = (List)((LcdpComponent)componentMap.get(tableId)).getProps().get("opt_cols");
            for (Map stringObjectMap : colsList) {
                if (!ToolUtil.isNotEmpty(stringObjectMap.get("field"))) continue;
                options.append("'").append(stringObjectMap.get("title")).append("',");
                fields.append("'").append(stringObjectMap.get("field")).append("',");
            }
            moduleMap.put("fields", fields.toString());
            moduleMap.put("isTableExist", true);
            moduleMap.put("tableId", tableId);
            moduleMap.put("titles", options.toString());
            Map paramValues = action.getParamValues();
            Map selectDomInfoMap = (Map)paramValues.get("copyRow");
            String primaryFieldName = selectDomInfoMap.get("primaryFieldName").toString();
            String operationName = selectDomInfoMap.get("operationName").toString();
            moduleMap.put("primaryFieldName", primaryFieldName);
            moduleMap.put("operationName", operationName);
            LcdpComponent tableComponent = (LcdpComponent)ctx.getComponentMap().get(tableId);
            DataSAnalysis datasAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)tableComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis datasModelAnalysis = datasAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)datasModelAnalysis)) {
                String dataModelId = datasModelAnalysis.getDataModelId();
                DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)dataModelId);
                if (dataModelBase.getSourceDataModelIds().size() > 1) {
                    moduleMap.put("isMuiTable", true);
                }
                int i = datasModelAnalysis.getFields().size();
                Map maps = datasModelAnalysis.getFields();
                if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                    String apiFileName = this.fileMappingService.getFileName(dataModelId);
                    moduleMap.put("apiFileName", apiFileName);
                }
            }
        }
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString());
        }
    }
}

