/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.Action;
import com.jxdinfo.speedcode.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.ExportPDFAction")
public class PdfExport
implements ActionVisitor {
    private final FileMappingService fileMappingService;

    @Autowired
    public PdfExport(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        String formInstanceKey;
        String dataModelId;
        HashMap<String, String> moduleMap = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/elementui/event/PdfExport.ftl");
        ctx.addImports("import qscrypt from '@/pages/index/utils/qscrypt'");
        ctx.addImports("import hussarRequest from '@/pages/index/utils/hussar-default-request'");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString(action.getParamValues().get("exportPdf")));
        String dir = jsonObject.getString("dir");
        String name = jsonObject.getString("name");
        LcdpComponent formComponent = myLcdpComponent.getParentLcdpComponent();
        JSONObject json = (JSONObject)action.getParamValues().get("formSelect");
        String operationName = (String)json.get((Object)"operationName");
        moduleMap.put("operationName", operationName);
        DataSAnalysis datasAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)formComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis datasModelAnalysis = datasAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)datasModelAnalysis) && ToolUtil.isNotEmpty((Object)(dataModelId = datasModelAnalysis.getDataModelId()))) {
            String apiFileName2 = this.fileMappingService.getFileName(dataModelId);
            moduleMap.put("apiFileName2", apiFileName2);
        }
        if (ToolUtil.isNotEmpty((Object)(formInstanceKey = ctx.getCurrentLcdpComponent().getParentLcdpComponent().getInstanceKey()))) {
            moduleMap.put("formInstanceKey", formInstanceKey);
        }
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        moduleMap.put("trigger", triggerName);
        String filePath = dir + "/" + name;
        moduleMap.put("templatePath", dir);
        moduleMap.put("templateName", name);
        Map componentMap = ctx.getComponentMap();
        renderCore.registerParam(moduleMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString());
        }
    }
}

