/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IoTVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.getProps().put("readonly", true);
        List triggers = lcdpComponent.getTriggers();
        lcdpComponent.registerTemplatePath("/template/elementui/element/IoT/el_IoT.ftl");
        lcdpComponent.addRenderParam("triggers", (Object)triggers);
        lcdpComponent.addRenderParam("placeholder", lcdpComponent.getProps().get("placeholder"));
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, null);
        lcdpComponent.addAttr(CodePrefix._V_MODEL.getType(), valueData);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        lcdpComponent.addAttr(":type", lcdpComponent.getInstanceKey() + "Type");
        ctx.addData(lcdpComponent.getInstanceKey() + "Type:'" + lcdpComponent.getProps().get("select") + "'");
        ctx.addData(lcdpComponent.getInstanceKey() + "IntervalId: null,");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormMounted(lcdpComponent, ctx);
        if (lcdpComponent.getProps().get("readonly") != null) {
            String instanceKey = lcdpComponent.getInstanceKey();
            String isReadonly = instanceKey + "Readonly";
            lcdpComponent.addAttr(":class", isReadonly + " ? 'jxd_ins_elIoTReadonly' : ''");
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, CharSequence> params = new HashMap<String, CharSequence>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
            Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
            String valueField = "";
            if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                        List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                        valueField = dataSFieldAnalysis.getFieldName();
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)valueField)) {
                String sortConditionName;
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                String operationName = "hussarQuery";
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
                }
                if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                    params.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    params.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                    operationName = operationName + sortConditionName;
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                params.put("importName", apiFileName);
                params.put("importMethod", operationName);
                params.put("valueField", valueField);
                params.put("refreshFrequency", (CharSequence)lcdpComponent.getProps().get("refreshFrequency"));
                params.put("toFixed", (CharSequence)lcdpComponent.getProps().get("toFixed"));
                params.put("unit", (CharSequence)lcdpComponent.getProps().get("unit"));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "IoTLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/el_IoT_query.ftl", params));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "DataRefreh", RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/el_IoT_dataRefreh.ftl", params));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "DataClear", RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/el_IoT_dataClear.ftl", params));
                ctx.addDestroyeds("self." + lcdpComponent.getInstanceKey() + "DataClear();");
                ctx.addCreated("self." + lcdpComponent.getInstanceKey() + "DataRefreh();");
                ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "IoTLoad();");
            }
        }
    }
}

