/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.speedcode.codegenerator.core.util.DynDataUtil;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.DealFormDataVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ElTabsVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/elementui/element/tabs/el_tabs.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.judgeHorizontalAndVerticalFill(lcdpComponent, ctx);
    }

    private void judgeHorizontalAndVerticalFill(LcdpComponent lcdpComponent, Ctx ctx) {
        boolean isHorizontalFill = lcdpComponent.isHorizontalFill();
        boolean isVerticalFill = lcdpComponent.isVerticalFill();
        List scrollList = JSON.parseArray((String)lcdpComponent.getProps().get("scrollList").toString(), HashMap.class);
        int realWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realWidth")), (String)"px"));
        int realHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(lcdpComponent.getInnerStyles().get("realHeight")), (String)"px"));
        for (HashMap hashMap : scrollList) {
            int scrollWidth = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollWidth")), (String)"px"));
            int scrollHeight = Integer.parseInt(StringUtils.removeEndIgnoreCase((String)String.valueOf(hashMap.get("scrollHeight")), (String)"px"));
            int diffX = scrollWidth - realWidth;
            int diffY = scrollHeight - realHeight;
            if (isHorizontalFill) {
                hashMap.put("scrollWidth", "calc(100% + " + diffX + "px)");
            } else if (diffX == 0) {
                hashMap.put("scrollWidth", "100%");
            }
            if (isVerticalFill) {
                hashMap.put("scrollHeight", "calc(100% + " + diffY + "px)");
                continue;
            }
            if (diffY != 0) continue;
            hashMap.put("scrollHeight", "100%");
        }
        lcdpComponent.addRenderParam("scrolls", (Object)scrollList);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        HashMap tabMap = new HashMap();
        tabMap.put("active", lcdpComponent.getProps().get("defaultActiveTab"));
        tabMap.put("stretch", lcdpComponent.getProps().get("stretch"));
        tabMap.put("id", lcdpComponent.getInstanceKey());
        List tabList = JSON.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        JSONObject fromComponentParams = JSON.parseObject((String)String.valueOf(lcdpComponent.getProps().get("formComponentParams")));
        ArrayList fromComponentParamList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)fromComponentParams)) {
            for (Object entry : fromComponentParams.entrySet()) {
                HashMap fromComponentParam = new HashMap();
                fromComponentParam.put(entry.getKey(), entry.getValue());
                fromComponentParamList.add(fromComponentParam);
            }
        }
        int index = 0;
        for (HashMap tab : tabList) {
            String routePath = "";
            if (ToolUtil.isNotEmpty(tab.get("outLink"))) {
                routePath = tab.get("outLink").toString();
                tab.put("outLink", routePath);
                tab.put("url", "");
                continue;
            }
            if (!ToolUtil.isNotEmpty(tab.get("url"))) continue;
            StringBuilder props = new StringBuilder();
            StringBuilder triggers = new StringBuilder();
            JSONObject pageParamConfig = (JSONObject)((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("pageParamConfig");
            List events = lcdpComponent.getEvents();
            String id = ((HashMap)JSON.parseObject((String)tab.get("url").toString(), HashMap.class)).get("fileId").toString();
            routePath = this.fileMappingService.getFormatPath(id);
            String pageName = routePath.substring(routePath.lastIndexOf(47) + 1);
            for (Object entry : events) {
                String eventName = entry.getTrigger();
                String oldName = "";
                List eventTriggers = lcdpComponent.getDynamicEventTriggers();
                for (Object eventTrigger : eventTriggers) {
                    Map e = DynDataUtil.asObject(eventTrigger).orElse(Collections.emptyMap());
                    if (!eventName.equals(e.get("name"))) continue;
                    oldName = String.valueOf(e.get("oName"));
                }
                if (entry.getTrigger().contains(String.valueOf(tab.get("slotName")))) {
                    String strTrigger = " @" + oldName + " =" + lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)eventName);
                    triggers.append(strTrigger);
                }
                this.removeTiggers(lcdpComponent, ctx, eventName);
            }
            for (Object entry : pageParamConfig.entrySet()) {
                HashMap<String, Map<String, Object>> moduleMap = new HashMap<String, Map<String, Object>>();
                String key = String.valueOf(entry.getKey());
                JSONObject value = JSON.parseObject((String)JSON.toJSONString(entry.getValue()));
                String propValue = pageName + index + ToolUtil.firstLetterToUpper((String)key);
                if (!ToolUtil.isNotEmpty((Object)value) || !ToolUtil.isNotEmpty(value.get("type"))) continue;
                String strProp = " :" + key + " = " + propValue;
                props.append(strProp);
                Map<String, Object> config = ElTabsVoidVisitor.getRenderPageParamData(ctx, (Map.Entry<String, Object>)entry);
                if (config.size() > 0) {
                    moduleMap.put("params", config);
                }
                ctx.addComputed(propValue, RenderUtil.renderTemplate((String)"template/elementui/element/tabs/tab_props.ftl", moduleMap));
            }
            tab.put("url", routePath);
            tab.put("pageName", "<" + pageName + index + props + triggers + "/>");
            ctx.addImports("import " + pageName.toLowerCase() + index + " from '@/views" + routePath + "'");
            ctx.addComponent(pageName.toLowerCase() + index);
            ++index;
        }
        String dataArrayStr = RenderUtil.renderTemplate((String)"template/elementui/element/tabs/tab_data.ftl", tabMap);
        ctx.addData(dataArrayStr);
        lcdpComponent.addRenderParam("tabs", (Object)tabList);
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) {
        ctx.addComputed("url", "return window.location.origin + '/#';");
    }

    private void removeTiggers(LcdpComponent lcdpComponent, Ctx ctx, String eventName) {
        lcdpComponent.getTrigger().removeIf(trigger -> trigger.getName().equals(eventName));
    }

    private static Map<String, Object> getRenderPageParamData(Ctx ctx, Map.Entry<String, Object> entry) throws LcdpException {
        HashMap<String, Object> paramConfig = new HashMap<String, Object>();
        ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)entry.getValue().toString(), ComponentReference.class);
        ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
        if (null != data) {
            paramConfig.put(entry.getKey(), data.getRenderValue());
        } else {
            paramConfig.put(entry.getKey(), "''");
        }
        return paramConfig;
    }
}

