const seriesResult = [];
const colorValue =${topicColorStr!};
<#--标题-->
const echatrsTitle = {
text: '${titleText!}',
textStyle: {
color: '${titleColor!}',
fontSize: '${titleFontSize!}',
fontFamily: '${fontFamily!}',
fontWeight: '${fontWeight!}',
},
textVerticalAlign :'${titleVerticalAlign!}',
left: '${titleAlign!}',
top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
borderRadius: 4,
padding: [6, 5, 3, 5],
};
<#--网格-->
const grid = {
left: '${gridLeft!}',
top: '${gridTop!}',
right: '${gridRight!}',
bottom: '${gridBottom!}',
containLabel: ${containLabel?string!},
};
<#--提示信息-->
const echatrsTooltip = {
trigger: 'axis',
show: ${toolShow?string!},
backgroundColor: '${tooltipBgColor!}',
textStyle: {
color: '${toolColor!}',
fontSize: '${toolFontSize!}',
fontFamily: '${toolFontFamily!}',
fontWeight: '${toolFontWeight!}',
fontStyle: '${toolFontStyle!}',
lineHeight: '${toolLineHeight!}',
},
axisPointer:{
type: '${xyAxisPointerType!}',
crossStyle:{
color: '${xyAxisPointerColor!}',
},
lineStyle:{
color: '${xyAxisPointerColor!}',
},
shadowStyle:{
color: '${xyAxisPointerColor!}',
opacity: 0.3,
},
},
padding:['${toolPaddingTop!}', '${toolPaddingLeft!}'],
extraCssText:'box-shadow: ${toolShadow!} ',
};
<#--图例字体设置-->
const textStyle ={
color: '${legendColor!}',
fontSize: '${legendFontSize!}',
fontFamily: '${legendFontFamily!}',
fontWeight: '${legendFontWeight!}',
fontStyle: '${legendFontStyle!}',
};
<#--坐标轴字体设置-->
const nameTextStyle = {
color: '${xyColor!}',
fontSize: '${xyFontSize!}',
fontFamily: '${xyFontFamily!}',
fontWeight: '${xyFontWeight!}',
fontStyle: '${xyFontStyle!}',
};
<#--坐标轴设置-->
const axisLine = {
show: true,
type: 'solid',
lineStyle: {
width: '${lineWidth!}',
<#if (lineColor?? && lineColor != "")>
    color: '${lineColor!}',
</#if>
},
};
const axisLabel = {
show: true,
color: '${xyColor!}',
fontSize: '${xyFontSize!}',
fontFamily: '${xyFontFamily!}',
fontWeight: '${xyFontWeight!}',
fontStyle: '${xyFontStyle!}',
};
const axisLabels = {
show: true,
color: '${xyColor!}',
fontSize: '${xyFontSize!}',
fontFamily: '${xyFontFamily!}',
fontWeight: '${xyFontWeight!}',
fontStyle: '${xyFontStyle!}',
<#if (barUnit?? && barUnit != "")>
    formatter:'{value}${barUnit!}',
<#else>
    formatter:'{value}',
</#if>
};
<#--标签-->
const label ={
show: ${labelShow?string!},
position:'${labelPosition!}',
<#if (labelDistance??)>
    distance:${labelDistance!},
</#if>
color:'${labelColor!}',
fontSize:'${labelFontSize!}',
};
const axisTick ={
length:'${xyAxisTickLength!}',
};
<#--x坐标轴设置-->
const xAxis = {
type:'value',
show:true,
name: '${yAxisName!}',
nameLocation: '${nameLocation!}',
nameTextStyle:nameTextStyle,
axisLine:axisLine,
axisLabel:axisLabels,
axisTick:axisTick,
splitLine:{
show: ${xSplitLineShow?string!},
lineStyle:{
color:'${xSplitLineColor!}',
type:'${xSplitLineType!}',
},
},
};
<#--series样式设置-->
const seriesItemStyle ={
    normal: {
        barBorderRadius: ${barRadius!},
    },
};

${optionData!}.legendData.forEach((col, index) => {
    seriesResult.push({
    name: col,
    itemStyle:seriesItemStyle,
    type: 'bar',
    label:label,
    barWidth: ${barWidth!},
    <#if barGap?? && '${barGap}' != ''>
        barGap: '${barGap}',
    </#if>
    data: ${optionData!}.xAxisData[index],
    });
});

return {
        color: colorValue,
        title: echatrsTitle,
        grid:grid,
        tooltip: echatrsTooltip,
        legend: {
            show: ${isShowFlag?string!},
            left: '${legendLocation!}',
            textStyle:textStyle,
            itemWidth: ${itemWidth!},
            itemHeight: ${itemHeight!},
            itemGap: ${itemGap!}   ,
            icon: '${itemIcon!}',
            orient: '${itemOrient!}',
            inactiveColor: '${itemInactiveColor!}',
            data:${optionData!}.legendData,
        },
        xAxis: xAxis,
        yAxis: {
            type:'category',
            show:true,
            name: '${xAxisName!}',
            nameLocation: '${nameLocation!}',
            nameGap:${nameGap!},
            nameTextStyle:nameTextStyle,
            axisLine:axisLine,
            axisLabel:axisLabel,
            axisTick: axisTick,
            data: ${optionData!}.yAxisData[0],
        },
        series: seriesResult,
}