/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentBindUtil;
import com.jxdinfo.speedcode.common.utils.ComponentDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElTreeTable.value")
@Scope(value="prototype")
public class TreeTableValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public String getDefaultValue() {
        return "[]";
    }

    public String getValue(List<String> dataItems) throws LcdpException {
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() >= 2) {
            JSONObject colObj;
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
            JSONArray hiddenCols = (JSONArray)this.lcdpComponent.getProps().get("hidden_cols");
            if (dataItems.get(1).contains("sum(")) {
                return "self." + this.lcdpComponent.getInstanceKey() + "ColumnFieldsAssignment." + dataItems.get(1).replace("sum(", "").replace(")", "");
            }
            for (Object col : cols) {
                colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                if (dataItems.size() == 3 && "tableAddAssignment".equals(dataItems.get(2))) {
                    return "data." + colObj.getString("field");
                }
                if (ToolUtil.isNotEmpty((Object)colObj.get((Object)"rowSummary")) && colObj.getBoolean("rowSummary").booleanValue() && ToolUtil.isNotEmpty((Object)colObj.get((Object)"rowCalculate"))) {
                    return "function(){\nlet result = '';self." + this.lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_DATA_CHECKED.getType() + ".forEach((row) => result +=`${" + colObj.getJSONObject("rowCalculate").getString("editFormulaReplace") + "},`);return result.substring(0,result.length-1);}()";
                }
                return "function(){\nlet result = '';self." + this.lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_DATA_CHECKED.getType() + ".forEach((item) => result +=`${item." + colObj.getString("field") + "},`);return result.substring(0,result.length-1);}()";
            }
            for (Object col : hiddenCols) {
                colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                if (ToolUtil.isEmpty((Object)colObj.get((Object)"field"))) {
                    if (colObj.getString("id").equals("jxd-tree-table-fix-id")) {
                        colObj.put("field", (Object)"id");
                    } else if (colObj.getString("id").equals("jxd-tree-table-fix-pid")) {
                        colObj.put("field", (Object)"pid");
                    }
                }
                if (dataItems.size() == 3 && "tableAddAssignment".equals(dataItems.get(2))) {
                    return "data." + colObj.getString("field");
                }
                return "function(){\nlet result = '';self." + this.lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_DATA_CHECKED.getType() + ".forEach((item) => result +=`${item." + colObj.getString("field") + "},`);return result.substring(0,result.length-1);}()";
            }
        }
        return ComponentBindUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType());
    }

    public String setValue(List<String> dataItems) throws LcdpException {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        JSONArray colsJson = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
        JSONArray hiddenJson = (JSONArray)this.lcdpComponent.getProps().get("hidden_cols");
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (ToolUtil.isNotEmpty((Object)colsJson)) {
            List colsList = colsJson.toJavaList(TableOptColsAnalysis.class);
            colsList.forEach(col -> map.put(col.getId(), col.getField()));
        }
        if (ToolUtil.isNotEmpty((Object)hiddenJson)) {
            List hiddenColsList = hiddenJson.toJavaList(TableOptColsAnalysis.class);
            hiddenColsList.forEach(col -> {
                if ("jxd-tree-table-fix-id".equals(col.getId())) {
                    map.put("id", col.getField());
                } else if ("jxd-tree-table-fix-pid".equals(col.getId())) {
                    map.put("pid", col.getField());
                } else {
                    map.put(col.getId(), col.getField());
                }
            });
        }
        if (!map.containsKey("id")) {
            map.put("id", "id");
        }
        if (!map.containsKey("pid")) {
            map.put("pid", "pid");
        }
        return map;
    }

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems)) {
            this.getSelectAndTableData(dataItems, data, dataItems.get(0));
        } else {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("value");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem));
        }
        return data;
    }

    private void getSelectAndTableData(List<String> dataItems, ComponentData data, String dataItem) throws LcdpException {
        String dataValue;
        data.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        ArrayList<String> currDataItem = new ArrayList<String>();
        boolean isTreeTableValue = false;
        if (dataItem.equals("data")) {
            currDataItem.add("data");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._TABLE_DATA_CHECKED.getType(), currDataItem);
        } else {
            isTreeTableValue = true;
            currDataItem.add("value");
            dataValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), currDataItem);
        }
        if (dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("opt_cols");
            JSONArray hiddenCols = (JSONArray)this.lcdpComponent.getProps().get("hidden_cols");
            this.getOptColData(dataItems, data, dataValue, cols, isTreeTableValue);
            this.getHiddenColData(dataItems, data, dataValue, hiddenCols, isTreeTableValue);
        } else {
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            data.setRenderValue(dataValue);
        }
    }

    private void getHiddenColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray hiddenCols, boolean isTreeData) {
        if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
            List hiddenColsList = hiddenCols.toJavaList(TableOptColsAnalysis.class);
            for (TableOptColsAnalysis col : hiddenColsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                String colField = col.getField();
                if (col.getId().equals("jxd-tree-table-fix-id")) {
                    colField = "id";
                } else if (col.getId().equals("jxd-tree-table-fix-pid")) {
                    colField = "pid";
                }
                if (isTreeData) {
                    ComponentDataUtil.addPackageTreeFieldMethod((Ctx)this.ctx);
                    data.setRenderValue("function(){\nlet result = [];\nself.packageTreeField(result, " + dataValue + ", " + colField + ");\nreturn result;}()");
                    break;
                }
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + colField + "));return result;}()");
                break;
            }
        }
    }

    private void getOptColData(List<String> dataItems, ComponentData data, String dataValue, JSONArray cols, boolean isTreeData) {
        if (ToolUtil.isNotEmpty((Object)cols)) {
            List colsList = cols.toJavaList(TableOptColsAnalysis.class);
            for (TableOptColsAnalysis col : colsList) {
                if (!col.getId().equals(dataItems.get(1))) continue;
                if (isTreeData) {
                    ComponentDataUtil.addPackageTreeFieldMethod((Ctx)this.ctx);
                    data.setRenderValue("function(){\nlet result = [];\nself.packageTreeField(result, " + dataValue + ", " + col.getField() + ");\nreturn result;}()");
                    break;
                }
                data.setRenderValue("function(){\nlet result = [];" + dataValue + ".forEach((item) => result.push(item." + col.getField() + "));return result;}()");
                break;
            }
        }
    }
}

