/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.data.constant.DataFromEnum;
import com.jxdinfo.speedcode.codegenerator.core.data.mapping.DataItemMappingBO;
import com.jxdinfo.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.speedcode.common.analysismodel.dataitem.reference.GetValueBO;
import com.jxdinfo.speedcode.common.analysismodel.dataset.MethodConfigAnalysis;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.MappingUtils;
import com.jxdinfo.speedcode.constant.dataset.DataSetObjectTypeEnum;
import com.jxdinfo.speedcode.datasource.model.meta.DataModelBase;
import com.jxdinfo.speedcode.datasource.model.meta.DataModelFieldBase;
import com.jxdinfo.speedcode.datasource.model.meta.dataset.DataSet;
import com.jxdinfo.speedcode.datasource.model.meta.dataset.DataSetObject;
import com.jxdinfo.speedcode.datasource.model.meta.dataset.ValueObjectProperty;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiComponentVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);
    private static final String MAPPING_KEY = "mapping";

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/elementui/element/ApiComponent/apiComponent.ftl");
        this.renderTableLoad(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws IOException, LcdpException {
        DataSet returnDataSet;
        JSONObject methodObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()));
        if (ToolUtil.isEmpty((Object)methodObj) || ToolUtil.isEmpty((Object)methodObj.get((Object)"datamodel"))) {
            return;
        }
        MethodConfigAnalysis methodConfigAnalysis = (MethodConfigAnalysis)JSONObject.parseObject((String)methodObj.get((Object)"datamodel").toString(), MethodConfigAnalysis.class);
        if (ToolUtil.isNotEmpty((Object)methodConfigAnalysis) && (returnDataSet = DataModelUtil.getDataSetById((String)methodConfigAnalysis.getDataModelId(), (String)methodConfigAnalysis.getReturnDataSet())) != null && ToolUtil.isNotEmpty((Object)returnDataSet.getDataType())) {
            if (returnDataSet.getDataType().equals(ComponentData.DataTypeEnum.OBJECT.getValue())) {
                ctx.addData(lcdpComponent.getInstanceKey() + "Data: {}");
            } else if (returnDataSet.getDataType().equals(ComponentData.DataTypeEnum.ARRAY_OBJECT.getValue())) {
                ctx.addData(lcdpComponent.getInstanceKey() + "Data: []");
            } else {
                ctx.addData(lcdpComponent.getInstanceKey() + "Data: ''");
            }
        }
    }

    public void renderTableLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        String dataTableId = lcdpComponent.getInstanceKey();
        String apiFileName = "";
        String apiFilePath = "";
        String operationName = "hussarQuery";
        JSONObject methodObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()));
        if (ToolUtil.isEmpty((Object)methodObj) || ToolUtil.isEmpty((Object)methodObj.get((Object)"datamodel"))) {
            return;
        }
        MethodConfigAnalysis methodConfigAnalysis = (MethodConfigAnalysis)JSONObject.parseObject((String)methodObj.get((Object)"datamodel").toString(), MethodConfigAnalysis.class);
        String dataModelId = methodConfigAnalysis.getDataModelId();
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)dataModelId);
        if (ToolUtil.isNotEmpty((Object)methodConfigAnalysis) && ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)dataModelBase)) {
            operationName = dataModelBase.getOperationNameById(methodConfigAnalysis.getOperationName());
            apiFileName = this.fileMappingService.getFileName(dataModelId);
            apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
        }
        tableMap.put("importName", apiFileName);
        tableMap.put("importMethod", operationName);
        tableMap.put("instanceKey", dataTableId);
        tableMap.putAll(lcdpComponent.getRenderParamsToBind());
        this.configParams(tableMap, ctx, methodConfigAnalysis);
        if (ToolUtil.isNotEmpty(tableMap.get("paramRes"))) {
            tableMap.put("paramObj", tableMap.get("importName") + "Obj");
        }
        ctx.addMethod(lcdpComponent.getInstanceKey() + "ApiLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/ApiComponent/apiComponent_loadMethod.ftl", tableMap));
    }

    private void configParams(Map<String, Object> tableMap, Ctx ctx, MethodConfigAnalysis methodConfigAnalysis) throws LcdpException, IOException {
        List getValueBOS = methodConfigAnalysis.getParamConfig();
        String dataModelId = methodConfigAnalysis.getDataModelId();
        DataSet dataSetAnalysis = DataModelUtil.getDataSetById((String)dataModelId, (String)methodConfigAnalysis.getParamDataSet());
        if (ToolUtil.isEmpty((Object)getValueBOS) || ToolUtil.isEmpty((Object)dataSetAnalysis)) {
            return;
        }
        HashMap<String, Map<String, String>> paramRenderStr = new HashMap<String, Map<String, String>>();
        ApiComponentVisitor.dealRenderParam(ctx, getValueBOS, paramRenderStr, dataSetAnalysis, dataModelId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("paramRenderStr", paramRenderStr);
        params.put("paramObj", tableMap.get("importName") + "Obj");
        params.put("queryAttr", tableMap.get("queryAttr"));
        HashMap fieldMap = new HashMap();
        for (GetValueBO getValueBO : getValueBOS) {
            if (!ToolUtil.isNotEmpty((Object)getValueBO.getCurrentData()) || getValueBO.getCurrentData().size() <= 0) continue;
            if (getValueBO.getCurrentData().size() == 1) {
                params.put("level", 1);
                fieldMap.put(getValueBO.getCurrentData().get(0), getValueBO.getCurrentData().get(0));
            }
            if (getValueBO.getCurrentData().size() == 2) {
                params.put("level", 2);
                fieldMap.put(getValueBO.getCurrentData().get(0), getValueBO.getCurrentData().get(1));
            }
            params.put("paramFields", fieldMap);
        }
        String paramRes = RenderUtil.renderTemplate((String)"/template/elementui/element/ApiComponent/apiComponent_param.ftl", params);
        tableMap.put("paramRes", paramRes);
    }

    private static void dealRenderParam(Ctx ctx, List<GetValueBO> getValueBOS, Map<String, Map<String, String>> paramRenderStr, DataSet dataSetAnalysis, String dataModelId) throws LcdpException, IOException {
        for (int i = 0; i < getValueBOS.size(); ++i) {
            ComponentData getValueData;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (null == getValueBOS.get(i) || !ToolUtil.isNotEmpty((Object)getValueBOS.get(i).getCurrentData()) || null == (getValueData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)getValueBOS.get(i).getComponentGetData())) || !ToolUtil.isNotEmpty((Object)getValueData.getRenderValue())) continue;
            params.put("getValueData", getValueData.getRenderValue());
            Map<String, Object> resultMap = ApiComponentVisitor.getMappingResult(ctx, getValueBOS.get(i).getComponentGetData().getMapping(), getValueBOS.get(i).getComponentGetData());
            params.putAll(resultMap);
            params.put("fromDataItem", getValueData.getRenderValue());
            params.put("fromData", "fromData" + i);
            params.put("fromDataType", getValueData.getDataType().getValue());
            params.put("toDataItem", getValueBOS.get(i).getCurrentData().get(getValueBOS.get(i).getCurrentData().size() - 1));
            ApiComponentVisitor.getToDataType(getValueBOS.get(i).getCurrentData(), dataSetAnalysis, dataModelId, params);
            HashMap<String, String> renderMap = new HashMap<String, String>();
            renderMap.put("toDataType", params.get("toDataType").toString());
            renderMap.put("renderStr", RenderUtil.renderTemplate((String)"/template/common/dataitem/api_param_mapping.ftl", params));
            paramRenderStr.put(params.get("toDataItem").toString(), renderMap);
        }
    }

    private static void getToDataType(List<String> dataItemFields, DataSet dataSetAnalysis, String dataModelId, Map<String, Object> params) throws IOException, LcdpException {
        DataSetObject dataSetObject = dataSetAnalysis.getDataSetObject();
        DataModelBase dataModel = DataModelUtil.getDataModelBase((String)dataModelId);
        ArrayList<DataModelFieldBase> modelFields = new ArrayList();
        if (dataModel != null) {
            modelFields = dataModel.getFields();
        }
        if (dataSetObject.getObjectType().equals(DataSetObjectTypeEnum.DATA_MODEL.getValue())) {
            ApiComponentVisitor.getTypeFromModel(modelFields, dataItemFields, params, 0);
        } else {
            ApiComponentVisitor.getTypeFromObject(dataSetObject.getProperties(), modelFields, dataItemFields, params, 0);
        }
    }

    private static void getTypeFromObject(List<ValueObjectProperty> properties, List<DataModelFieldBase> modelFields, List<String> dataItemFields, Map<String, Object> params, int level) {
        if (ToolUtil.isNotEmpty(properties) && properties.size() > 0) {
            for (ValueObjectProperty property : properties) {
                if (!property.getName().equals(dataItemFields.get(level))) continue;
                if (dataItemFields.size() - 1 > level && ToolUtil.isNotEmpty((Object)property.getProperties()) && property.getProperties().size() > 0) {
                    if (property.getObjectType().equals(DataSetObjectTypeEnum.DATA_MODEL.getValue())) {
                        ApiComponentVisitor.getTypeFromModel(modelFields, dataItemFields, params, level + 1);
                        continue;
                    }
                    if (!property.getObjectType().equals(DataSetObjectTypeEnum.OBJECT.getValue())) continue;
                    ApiComponentVisitor.getTypeFromObject(property.getProperties(), modelFields, dataItemFields, params, level + 1);
                    continue;
                }
                params.put("toDataType", property.getDataType());
            }
        }
    }

    private static void getTypeFromModel(List<DataModelFieldBase> modelFields, List<String> dataItemFields, Map<String, Object> params, int level) {
        for (DataModelFieldBase modelField : modelFields) {
            if (!modelField.getName().equals(dataItemFields.get(level))) continue;
            if (dataItemFields.size() - 1 > level && ToolUtil.isNotEmpty((Object)modelField.getProperties()) && modelField.getProperties().size() > 0) {
                ApiComponentVisitor.getTypeFromModel(modelField.getProperties(), dataItemFields, params, level + 1);
                continue;
            }
            params.put("toDataType", modelField.getDataType());
        }
    }

    public static Map<String, Object> getMappingResult(Ctx ctx, List<? extends DataItemMappingBO> mapsList, ComponentReference from) throws LcdpException {
        Map<String, Object> resultMap = new HashMap<String, Object>(8);
        if (!from.isConfigComplete(ctx)) {
            return resultMap;
        }
        resultMap.put("type", "simple");
        if (ToolUtil.isNotEmpty(mapsList) && ToolUtil.isNotEmpty((Object)(resultMap = ApiComponentVisitor.mapping(ctx, from, mapsList)).get(MAPPING_KEY))) {
            resultMap.put("type", "complex");
        }
        return resultMap;
    }

    private static Map<String, Object> mapping(Ctx ctx, ComponentReference from, List<? extends DataItemMappingBO> mappingList) throws LcdpException {
        HashMap<String, Object> mappingMap = new HashMap<String, Object>(8);
        ArrayList mappingBOS = new ArrayList();
        boolean fromIsComponent = DataFromEnum.INSTANCE.getValue().equals(from.getType());
        boolean toIsComponent = true;
        Map fromFieldMapping = MappingUtils.getFieldMapping((ComponentReference)from, (Ctx)ctx);
        mappingList.forEach(mappingItem -> {
            DataItemMappingBO<String> mapping;
            if (ToolUtil.isNotEmpty((Object)mappingItem.getFromDataItem()) && ToolUtil.isNotEmpty((Object)mappingItem.getToDataItem()) && null != (mapping = ApiComponentVisitor.dealMappingItem(fromIsComponent, toIsComponent, fromFieldMapping, mappingItem))) {
                mappingBOS.add(mapping);
            }
        });
        mappingMap.put(MAPPING_KEY, mappingBOS);
        return mappingMap;
    }

    private static DataItemMappingBO<String> dealMappingItem(boolean fromIsComponent, boolean toIsComponent, Map<String, String> fromFieldMapping, DataItemMappingBO mappingItem) {
        DataItemMappingBO mapping = new DataItemMappingBO();
        boolean canMapping = true;
        if (fromIsComponent) {
            if (ToolUtil.isEmpty(fromFieldMapping) || !fromFieldMapping.containsKey(mappingItem.getFromDataItem().toString())) {
                canMapping = false;
            } else {
                mapping.setFromDataItem((Object)fromFieldMapping.get(mappingItem.getFromDataItem().toString()));
            }
        } else {
            mapping.setFromDataItem((Object)mappingItem.getFromDataItem().toString());
        }
        if (toIsComponent) {
            mapping.setToDataItem((Object)mappingItem.getToDataItem().toString());
        }
        if (canMapping) {
            return mapping;
        }
        return null;
    }
}

