<#if tableInstanceKey?? && tableInstanceKey != "">
    let file = event.currentTarget.files[0];
    let rABS = false;
    const types = file.name.split(".")[1];
    const fileType = ["xlsx", "xlc", "xlm", "xls", "xlt"].some(
        item => item === types
    );
    if (!fileType) {
        self.$message.error('格式错误！请重新选择');
        return;
    }
    let reader = new FileReader();
    FileReader.prototype.readAsBinaryString = function(f) {
        let binary = "";
        let rABS = false;
        let wb;
        let reader = new FileReader();
        reader.onload = function() {
            let bytes = new Uint8Array(reader.result);
            for(let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            if(rABS) {
                wb = XLSX.read(btoa(binary), {
                type: 'base64', cellDates: true
            });
            } else {
                wb = XLSX.read(binary, {
                type: 'binary' ,cellDates: true
            });
        }
        let previewData = XLSX.utils.sheet_to_json(wb.Sheets[wb.SheetNames[0]]);
        let values = [];
        let prop = [];
        self.$refs.${tableInstanceKey!}TableRef.$children.forEach(obj => {
            values.push(obj._props.label)
        });
        self.$refs.${tableInstanceKey!}TableRef.$children.forEach(obj => {
            prop.push(obj._props.prop)
        });
        for (let i = values.length - 1; i >= 0; i--) {
            if (values[i] === undefined) {
                values.splice(i, 1);
                prop.splice(i, 1);
            }
            if (values[i] === '序号') {
                values.splice(i, 1);
                prop.splice(i, 1);
            }
        }
        let newArr = [];
        previewData.forEach((item)=>{
            let obj = {};
            for (let j=0; j < values.length; j++) {
                obj[prop[j]]=item[values[j]];
            }
            newArr.push(obj);
        });
        self.${tableInstanceKey!}Data = newArr;
        <#if importName?? && importName != "">
            ${importName!}['${importMethod!}']({importList: JSON.stringify(self.${tableInstanceKey!}Data)}).then(res => {
            if (res) {
                self.$message.success("导入成功");
            } else {
                self.$message.error("导入失败");
            }
            }).catch(function() {
                self.$message.error('数据请求异常');
            })
        </#if>
    };
    reader.readAsArrayBuffer(f);
    };
    if(rABS) {
        reader.readAsArrayBuffer(file);
    } else {
        reader.readAsBinaryString(file);
    }
</#if>