const seriesResult = [];
<#assign  innerAxisLine = '${innerAxisLine!}'>
<#assign  axisLineWidth = '${axisLineWidth!}'>
<#--标题-->
const echatrsTitle = {
textStyle: {
color: '${titleColor!}',
fontSize: '${titleFontSize!}',
fontFamily: '${fontFamily!}',
fontWeight: '${fontWeight!}',
},
text: '${titleText!}',
left: '${titleAlign!}',
top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
borderRadius: 4,
padding: [6, 5, 3, 5],
offsetCenter: ['20%', '20%'],
};
<#--主题颜色-->
const colorValue = ${topicColorStr!};
<#--提示信息-->
const echatrsTooltip = {
trigger: 'item',
show:${toolShow?string!},
backgroundColor: '${tooltipBgColor!}',
textStyle: {
color: '${toolColor!}',
fontSize: '${toolFontSize!}',
fontFamily: '${toolFontFamily!}',
fontWeight: '${toolFontWeight!}',
fontStyle: '${toolFontStyle!}',
lineHeight: '${toolLineHeight!}',
},
formatter(param) {
const num = param.value
if (num && !isNaN(num)) {
return parseFloat(num).toFixed(0);
}
return '';
},
padding: ['${toolPaddingTop!}', '${toolPaddingLeft!}'],
extraCssText: 'box-shadow: ${toolShadow!};',
};
<#--分割线-->
const splitLine = {
length: '${splitLineLength!}',
show: ${splitLineShow?string!},
lineStyle:{
color: '${splitLineColor!}',
width: '${splitLineWidth!}',
type: '${splitLineType!}',
opacity: 1
}
};
<#--刻度-->
const axisTick = {
show: ${axisTickShow?string!},
splitNumber: '${axisTickSplitNumber!}',
length: '${axisTickLength!}',
lineStyle:{
color:'${axisTickColor!}',
width:'${axisTickWidth!}'
}
};
<#--刻度标签-->
const axisLabel = {
show: ${axisLabelShow?string!},
distance:'${axisLabelDistance!}',
color: '${axisLabelColor!}',
fontSize: '${axisLabelFontSize!}',
formatter(value) {
return parseFloat(value).toFixed(0);
},
};
<#if importName?? && importName != "">
    <#if queryAttr??>
        let ${importName!}Obj = {
        ${queryAttr}
        };
    <#--    若查询条件项为空，则清空option-->
        <#if (queryCheck?? && queryCheck != "")>
            if(${queryCheck}){
            return;
            }
        </#if>
    <#else>
        let ${importName!}Obj = {};
    </#if>
<#--开始基础数据-->
    const settingData  = [];
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    const startData = [
    {
    center: ['25%', '60%'],
    radius: '35%',
    radiusInner: '25%',
    pointerLength: 50,
    offsetCenter: [0, '85%'],
    maxValue: '${maxValueOne!}' ,
    unit: '${detailUnitOne!}' ,
    order: 1,
    },
    {
    center: ['50%', '40%'],
    radius: '55%',
    radiusInner: '43%',
    pointerLength: 90,
    offsetCenter: [0, '85%'],
    maxValue: '${maxValueTwo!}' ,
    unit: '${detailUnitTwo!}' ,
    order: 2,
    },
    {
    center: ['75%', '60%'],
    radius: '35%',
    radiusInner: '25%',
    pointerLength: 50,
    offsetCenter: [0, '85%'],
    maxValue: '${maxValueThere!}' ,
    unit: '${detailUnitThere!}' ,
    order: 3,
    },
    ];
    if (res.code === "0" && res.data.length === 3) {
<#--为开始基础数据赋值查询出来的数据-->
    res.data.forEach((item,index) => {
    startData[index].value = item.${seriesCols!};
    startData[index].title = item.${axisCols!};
    settingData.push(startData[index]);
    });
<#--设置颜色循环-->
    if (colorValue.length < settingData.length) {
    for (let i = 0; colorValue.length < settingData.length; i++) {
    colorValue.push(...colorValue);
    }
    }
    settingData.forEach((e, index) => {
    seriesResult.push({
    name: 'Pressure',
    type: 'gauge',
    startAngle: 180,
    endAngle: 0,
    center: e.center,
    radius: e.radius,
    splitNumber: e.order === 2 ? ${splitNumber!} : ${splitNumberSmall!},
    min: ${minValue!},
    max: e.maxValue,
    axisLine:  {
    show: ${axisLineShow?string!},
    lineStyle: {
    color: [[e.value / e.maxValue, colorValue[index]], [1, '#F3F5F8']],
    width: '${axisLineWidth!}',
    <#if axisLineWidth =="0" >
       opacity: '0',
    <#else>
       opacity: '${axisLineOpacity!}',
    </#if>
    }
    },
    splitLine:splitLine,
    axisTick:axisTick,
    axisLabel:axisLabel,
    pointer:{
    show: ${pointerShow?string!},
    length: e.pointerLength,
    width: '${pointerWidth!}',
    },
    progress: {
    show: false,
    },
    detail:{
    show: ${detailShow?string!},
    valueAnimation: true,
    formatter(param) {
    let unitDataB = e.unit;
    return param + unitDataB;
    },
    backgroundColor: '${detailBackgroundColor!}',
    shadowColor: '${detailShadowColor!}',
    shadowBlur: ${detailShadowBlur!},
    shadowOffsetX: 3,
    shadowOffsetY: 3,
    padding: [4, 5],
    color: '${detailColor!}',
    fontWeight: '${detailFontWeight!}',
    fontSize: '${detailFontSize!}',
    borderRadius: 2,
    },
    title:{
    color: '${gaugeTitleColor!}',
    fontSize: '${gaugeTitleFontSize!}',
    fontFamily: '${gaugeFontFamily!}',
    fontWeight: '${gaugeFontWeight!}',
    offsetCenter: e.offsetCenter,
    },
    data: [{
    value: parseFloat(e.value).toFixed(0),
    name: e.title,
    }],
    }, {
    type: 'gauge',
    startAngle: 180,
    endAngle: 0,
    center: e.center,
    radius: e.radiusInner,
    splitNumber: 8,
    min: 0,
    max: 100,
    pointer: {
    show: false,
    },
    axisLine: {
    show: true,
    lineStyle: {
    color: [[e.value / e.maxValue, colorValue[index]], [1, '#F3F5F8']],
    width: '${innerAxisLine!}',
    <#if innerAxisLine =="0" >
       opacity: '0',
    <#else>
       opacity: '${innerAxisLine!}',
    </#if>
    },
    },
    axisTick: {
    show: false,
    length: 5,
    splitNumber: 5,
    lineStyle: {
    color: '#F3F5F8',
    width: 10,
    },
    },
    splitLine: {
    length: 4,
    show: false,
    lineStyle: {
    width: 10,
    color: '#fff',
    },
    },
    axisLabel: {
    show: false,
    },
    detail: {
    show: false,
    },
    });
    });
    self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    series: seriesResult,
    });
    return self.${instanceKey!}OptionData;
    }else{
    self.$message.error('数据请求失败');
    }
    }).catch(function() {
    self.$message.error('数据请求异常');
    })
<#--    没有设置数据模型时-->
<#else>
<#--基础数据-->
    const defaultData = [
    {
    center: ['25%', '60%'],
    radius: '35%',
    radiusInner: '25%',
    value: 15,
    pointerLength: 50,
    offsetCenter: [0, '85%'],
    title: '${dataTitleOne!}',
    maxValue: ${maxValueOne!} ,
    unit:'${detailUnitOne!}' ,
    color: colorValue[0],
    order: 1,
    },
    {
    center: ['50%', '40%'],
    radius: '55%',
    radiusInner: '43%',
    value: 80,
    pointerLength: 90,
    offsetCenter: [0, '85%'],
    title: '${dataTitleTwo!}',
    maxValue: ${maxValueTwo!} ,
    unit:'${detailUnitTwo!}' ,
    color: colorValue[1],
    order: 2,
    },
    {
    center: ['75%', '60%'],
    radius: '35%',
    radiusInner: '25%',
    value: 20,
    pointerLength: 50,
    offsetCenter: [0, '85%'],
    title: '${dataTitleThere!}',
    maxValue: ${maxValueThere!} ,
    unit:'${detailUnitThere!}' ,
    color: colorValue[2],
    order: 3,
    },
    ];
<#--设置颜色循环-->
    if (colorValue.length < defaultData.length) {
    for (let i = 0; colorValue.length < defaultData.length; i++) {
    colorValue.push(...colorValue);
    }
    }
    defaultData.forEach((e, index) => {
    seriesResult.push({
    name: 'Pressure',
    type: 'gauge',
    startAngle: 180,
    endAngle: 0,
    center: e.center,
    radius: e.radius,
    splitNumber: e.pointerLength === 90 ? ${splitNumber!} : ${splitNumberSmall!},
    min: ${minValue!},
    max: e.maxValue,
    axisLine:  {
    show: ${axisLineShow?string!},
    lineStyle: {
    color: [[e.value / e.maxValue, colorValue[index]], [1, '#F3F5F8']],
    width: '${axisLineWidth!}',
    <#if axisLineWidth =="0" >
       opacity: '0',
    <#else>
       opacity: '${axisLineOpacity!}',
    </#if>
    }
    },
    splitLine:splitLine,
    axisTick:axisTick,
    axisLabel:axisLabel,
    pointer:{
    show: ${pointerShow?string!},
    length: e.pointerLength,
    width: '${pointerWidth!}',
    },
    progress: {
    show: false,
    },
    detail:{
    show: ${detailShow?string!},
    valueAnimation: true,
    formatter(param) {
    let unitDataA = e.unit;
    return param + unitDataA;
    },
    backgroundColor: '${detailBackgroundColor!}',
    shadowColor: '${detailShadowColor!}',
    shadowBlur: '${detailShadowBlur!}',
    shadowOffsetX: 3,
    shadowOffsetY: 3,
    padding: [4, 5],
    color: '${detailColor!}',
    fontWeight: '${detailFontWeight!}',
    fontSize: '${detailFontSize!}',
    borderRadius: 2,
    },
    title:{
    color: '${gaugeTitleColor!}',
    fontSize: '${gaugeTitleFontSize!}',
    fontFamily: '${gaugeFontFamily!}',
    fontWeight: '${gaugeFontWeight!}',
    offsetCenter: e.offsetCenter,
    },
    data: [{
    value: parseFloat(e.value).toFixed(0),
    name: e.title,
    }],
    }, {
    type: 'gauge',
    startAngle: 180,
    endAngle: 0,
    center: e.center,
    radius: e.radiusInner,
    splitNumber: 8,
    min: 0,
    max: 100,
    pointer: {
    show: false,
    },
    axisLine: {
    show: true,
    lineStyle: {
    color: [[e.value / e.maxValue, colorValue[index]], [1, '#F3F5F8']],
    width: '${innerAxisLine!}',
    <#if innerAxisLine =="0" >
       opacity: '0',
    <#else>
       opacity: '${innerAxisLine!}',
    </#if>
    },
    },
    axisTick: {
    show: false,
    length: 5,
    splitNumber: 5,
    lineStyle: {
    color: '#F3F5F8',
    width: 10,
    },
    },
    splitLine: {
    length: 4,
    show: false,
    lineStyle: {
    width: 10,
    color: '#fff',
    },
    },
    axisLabel: {
    show: false,
    },
    detail: {
    show: false,
    },
    });
    });
    self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    series: seriesResult,
    });
    return self.${instanceKey!}OptionData;
</#if>