<#--定义列递归宏-->
<#macro editTree list>
    <#list list! as item>
        <#if (item.isParent?? && item.isParent!)>
            <vxe-table-column align="${item.bodyAlign!}"
                              header-align="${item.align!}"
                    <#--                                      field="${item.prop!}"-->
                              title="${item.label!}"
                    <#if item.width??>width="${item.width!}"</#if>
            >
                <@editTree list = item.children></@editTree>
            </vxe-table-column>
        <#else>
            <#if item.rowSummary?? && item.rowSummary>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  <#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if>
                                  title="${item.label!}"
                                  <#if item.width??>width="${item.width!}"</#if>
                        <#--格式化事件-->
                        <#--                              <#list formatDataMap! as formatItem>-->
                        <#--                                  <#if formatItem?contains(item.prop)>-->
                        <#--                                        :formatter="${instanceKey!}FormatEvent"-->
                        <#--                                        <#break>-->
                        <#--                                  </#if>-->
                        <#--                              </#list>-->
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        >
                <#if item.required?? && item.required!>
                <template slot="header">
                    <span style="margin-right: 4px;color: #F56C6C">*</span>
                    <span>${item.label!}</span>
                </template>
                </#if>
                <#if item.rowCalculate??>
                <template v-slot="{ row }">
                    <span class="vxe-cell--label">{{$numeral(${item.rowCalculate.editFormulaReplace!}).format('${item.rowCalculate.format!}')}}</span>
                </template>
                </#if>
                </vxe-table-column>
            <#else>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  title="${item.label!}"
                                  <#if item.width??>width="${item.width!}" <#else><#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if></#if>
                        <#--格式化事件-->
                        <#--                              <#list formatDataMap! as formatItem>-->
                        <#--                                  <#if formatItem?contains(item.prop)>-->
                        <#--                                        :formatter="${instanceKey!}FormatEvent"-->
                        <#--                                        <#break>-->
                        <#--                                  </#if>-->
                        <#--                              </#list>-->
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#--可编辑列-->
                        <#if item.colEditComponent! != '' && item.colEditComponent! !='empty'>
                            :edit-render="{
                                immediate: true,
                                <#--输入框-->
                                <#if item.colEditComponent! == 'input'>
                                name: 'input',
                                attrs: {type: 'text'},
                                <#--数字框-->
                                <#elseif item.colEditComponent! == 'number'>
                                name: '$input',
                                props: {type: 'number'},
                                <#--日期-->
                                <#elseif item.colEditComponent! == 'date'>
                                name: '$input',
                                props:{type:'${formatDataMap[item_index]!}'},
<#--                                props: {type: 'datetime'},-->
                                <#--下拉框-->
                                <#elseif item.colEditComponent! == 'select'>
                                name: '$select',
                                props: {type: 'select'},
                                options: ${instanceKey!}${item.prop!?cap_first}Options,
                                <#else >
                                </#if>
                                events: {
                                <#--合计行触发事件-->
                                <#if columnSummary?? && columnSummary>
                                input: ${instanceKey!}UpdateFooterEvent,
                                </#if>
                                <#--数据展示替换-->
                                <#if item.showConfig?? && item.showConfig>
                                change: ${instanceKey!}ReplaceData,
                                </#if>
                                }
                              }"
                        </#if>>
                    <#if item.required?? && item.required!>
                        <template slot="header">
                            <span style="margin-right: 4px;color: #F56C6C">*</span>
                            <span>${item.label!}</span>
                        </template>
                    </#if>
                    <#if item.route??>
                        <template slot-scope="scope">
                            <span @click="openRoute(scope.row)" class="jxd_hyperlinks_span" v-if="scope.row.web !== undefined && scope.row.web !== ''">{{scope.row.name}}</span>
                            <span v-if="scope.row.web === undefined || scope.row.web === '' ">{{scope.row.name}}</span>
                        </template>
                    </#if>
                    <#if formatMap?? && formatMap[item_index]??>
                    <#if formatMap[item_index].type! == 'date'>
                    <template v-slot="{ row }">
                        <span class="vxe-cell--label">{{(row.${item.prop!}) ? $moment(row.${item.prop!}).format('${formatMap[item_index].format!}') : '--'}}</span>
                    </template>
                    <#elseif formatMap[item_index].type! == 'number'>
                    <template v-slot="{ row }">
                        <span class="vxe-cell--label">{{$numeral(row.${item.prop!}).format('${formatMap[item_index].format!}')}}</span>
                    </template>
                    <#else>
                    </#if>
                    </#if>
                </vxe-table-column>
            </#if>
        </#if>
    </#list>
</#macro>
<div>
    <vxe-table
        show-overflow
        keep-source
        <#--列表loading-->
        :loading="${instanceKey!}TableLoading"
        <#--隔行变色-->
<#--        <#if stripe?? && stripe>-->
<#--            :stripe="${instanceKey!}Stripe"-->
<#--        </#if>-->
        <#if exportConfig?? && exportConfig!>
            export-config
        </#if>
        <#--列表边框-->
        <#if borderStyle??>
            :border="${instanceKey!}BorderStyle"
        </#if>
        <#if editRulesFlag?? && editRulesFlag>
            :edit-rules="${instanceKey!}EditRules"
        </#if>
        <#--表格高度（分页）-->
        <#if isPagination?? && isPagination>
            <#if tableHeight??>
                height="${tableHeight!}"
            </#if>
        <#else >:height="'100%'"
        </#if>
        ref="${instanceKey!}TableRef"
        <#--单击触发可编辑-->
        :edit-config="{trigger: 'click', mode: 'cell'<#if isDisabled??>, activeMethod: ${instanceKey!}ActiveRowMethod</#if>}"
        <#--合计行方法-->
        <#if columnSummary?? && columnSummary>
            show-footer
            :footer-method="${instanceKey!}ColumnSummaryEvent"
        </#if>
        <#--选择项变化-->
        <#if showSelection?? && showSelection>
        <#if isRadio?? && isRadio!>
            @radio-change="${instanceKey!}SelectRow"
        <#else>
            @checkbox-change="${instanceKey!}SelectRow"
        </#if>
        </#if>
    >
        <#--列表选择框-->
        <#if showSelection?? && showSelection>
            <vxe-table-column align="center" type="<#if isRadio?? && isRadio!>radio<#else>checkbox</#if>" :width="50"></vxe-table-column>
        </#if>
        <#--列表序号列-->
        <#if showIndex?? && showIndex>
            <vxe-table-column align="center" title="序号" type="seq" width="<#if indexWidth??>${indexWidth.localValue!}<#else>60</#if>"></vxe-table-column>
        </#if>
        <#--列表列-->
        <@editTree list= tableShowFields!></@editTree>
    </vxe-table>
    <#if isPagination?? && isPagination!>
        <vxe-pager
                   @page-change="${instanceKey!}PageSizeChange"
                   :layouts="${instanceKey!}Layout"
                   :total="${instanceKey!}TableTotal"
                   :current-page="${instanceKey!}ListQuery.current"
                   :page-size="${instanceKey!}ListQuery.size">
        </vxe-pager>
    </#if>
</div>