const xResult = [];
const sResult = [];
const result = [];
const legend = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end)+'\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
    text: newTitle,
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontFamily: '${fontFamily!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
};
const echatrsTooltip = {
    formatter: '{b} : {c} ({d}%)',
    trigger: 'item',
    backgroundColor: '${tooltipBgColor!}',
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontFamily: '${toolFontFamily!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
    },
};
const textStyle = {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontFamily: '${legendFontFamily!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
};

<#if importName?? && importName != "">
    <#if queryAttr??>
        let ${importName!}Obj = {
        ${queryAttr}
        };
    <#--    若查询条件项为空，则清空option-->
        <#if (queryCheck?? && queryCheck != "")>
            if(${queryCheck}){
            return;
            }
        </#if>
    <#else>
        let ${importName!}Obj = {};
    </#if>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if (res.code === "0") {
            res.data.forEach((item) => {
                result.push({"name": item.${xAxisCols!},"value": item.${seriesCols!}})
                legend.push(item.${xAxisCols!})
            });
            self.${instanceKey!}OptionData.push({
                title: echatrsTitle,
                tooltip: echatrsTooltip,
                legend: {
                    <#if (isShowFlag?? && isShowFlag)>
                        show: true,
                    <#elseif (!isShowFlag?? || !isShowFlag)>
                        show: false,
                    </#if>
                    left: '${legendLocation!}',
                    textStyle: textStyle,
                    data: legend,
                    bottom: 10,
                },
                series: [
                {
                    radius: ['50%', '80%'],
                    type: 'pie',
                    selectedMode: 'single',
                    data: result,
                },
                ],
            });
        } else {
        self.$message.error('数据请求失败');
        }
        }).catch(function() {
            self.$message.error('数据请求异常');
        })
    return self.${instanceKey!}OptionData;
<#--    没有设置数据模型时-->
<#else>
    const seriesResult = [
        { value: 335, name: '直接访问' },
        { value: 310, name: '邮件营销' },
        { value: 234, name: '联盟广告' },
        { value: 135, name: '视频广告' },
        { value: 1548, name: '搜索引擎' },
    ];
    const legendEchart = ['直接访问', '邮件营销', '联盟广告', '视频广告', '搜索引擎'];
    self.${instanceKey!}OptionData.push({
        title: echatrsTitle,
        tooltip: echatrsTooltip,
        legend: {
            <#if (isShowFlag?? && isShowFlag)>
                show: true,
            <#elseif (!isShowFlag?? || !isShowFlag)>
                show: false,
            </#if>
            left: '${legendLocation!}',
            textStyle: textStyle,
            data: legendEchart,
            bottom: 10,
        },
        series: [
            {
            radius: ['50%', '80%'],
            type: 'pie',
            selectedMode: 'single',
            data: seriesResult,
            },
        ],
    });
    return self.${instanceKey!}OptionData;
</#if>