const xResult = [];
const sResult = [];
const result = [];
const legend = [];
const resultSeries = [];
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
const xPaddingTop = parseInt('${xPaddingTop!}', 10);
const xPaddingRight = parseInt('${xPaddingRight!}', 10);
const xPaddingBottom = parseInt('${xPaddingBottom!}', 10);
const xPaddingLeft = parseInt('${xPaddingLeft!}', 10);
const yPaddingTop = parseInt('${yPaddingTop!}', 10);
const yPaddingRight = parseInt('${yPaddingRight!}', 10);
const yPaddingBottom = parseInt('${yPaddingBottom!}', 10);
const yPaddingLeft = parseInt('${yPaddingLeft!}', 10);
let newTitle = '';
if (oldTitle) {
  const titleLength = oldTitle.length;
  const provideLength = numberOfRow;
  const rowNumber = Math.ceil(titleLength / provideLength);
  if (titleLength > provideLength) {
    for (let i = 0; i < rowNumber; i++) {
      let tempStr = ' ';
      const start = i * provideLength;
      const end = start + provideLength;
      if (i === rowNumber - 1) {
        tempStr = oldTitle.substring(start, titleLength);
      } else {
        tempStr = oldTitle.substring(start, end)+'\n';
      }
      newTitle += tempStr;
    }
  } else {
    newTitle = oldTitle;
  }
}
const echatrsTitle = {
  text: newTitle,
  textStyle: {
    color: '${titleColor!}',
    fontSize: '${titleFontSize!}',
    fontFamily: '${fontFamily!}',
    fontWeight: '${fontWeight!}',
    fontStyle: '${fontStyle!}',
  },
    left: '${titleAlign!}',
  };
const echatrsTooltip = {
  trigger: 'axis',
  backgroundColor: '${tooltipBgColor!}',
  textStyle: {
    color: '${toolColor!}',
    fontSize: '${toolFontSize!}',
    fontFamily: '${toolFontFamily!}',
    fontWeight: '${toolFontWeight!}',
    fontStyle: '${toolFontStyle!}',
  },
};
const textStyle = {
  color: '${legendColor!}',
  fontSize: '${legendFontSize!}',
  fontFamily: '${legendFontFamily!}',
  fontWeight: '${legendFontWeight!}',
  fontStyle: '${legendFontStyle!}',
};
const nameTextStyle = {
  color: '${xyColor!}',
  fontSize: '${xyFontSize!}',
  fontFamily: '${xyFontFamily!}',
  fontWeight: '${xyFontWeight!}',
  fontStyle: '${xyFontStyle!}',
  padding: [xPaddingTop, xPaddingRight, xPaddingBottom, xPaddingLeft],
};
const axisLine = {
  show: true,
  type: 'solid',
  lineStyle: {
    width: '${lineWidth!}',
    color: '${lineColor!}',
  },
};
const axisLabel = {
  show: true,
  color: '${xyColor!}',
  fontSize: '${xyFontSize!}',
  fontFamily: '${xyFontFamily!}',
  fontWeight: '${xyFontWeight!}',
  fontStyle: '${xyFontStyle!}',
};
const yAxis = {
  type: 'value',
  name: '${yAxisName!}',
  nameGap: '${yNameGap!}',
  nameLocation: '${nameLocation}',
  nameTextStyle: {
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
    padding: [yPaddingTop, yPaddingRight, yPaddingBottom, yPaddingLeft],
  },
  axisLine: {
    show: true,
    type: 'solid',
    lineStyle: {
      width: '${lineWidth!}',
      color: '${lineColor!}',
    },
  },
  axisLabel: {
    show: true,
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
  },
};
<#if importName?? && importName != "">
  <#if queryAttr??>
    let ${importName!}Obj = {
    ${queryAttr}
    };
  <#--    若查询条件项为空，则清空option-->
    <#if (queryCheck?? && queryCheck != "")>
      if(${queryCheck}){
      return;
      }
    </#if>
  <#else>
    let ${importName!}Obj = {};
  </#if>
  ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
  if (res.code === "0") {
  res.data.forEach((item) => {
    result.push({
    "name": item.${xAxisCols!},
    "value": item.${seriesCols!},
    "legend": item.${legendCols!}
    })
  });
  result.forEach((item,index) => {
    xResult.push(item.name.split(","));
    sResult.push(item.value.split(","));
    legend.push(item.legend)
    resultSeries.push({
      name: legend[index],
      data: sResult[index],
      type: 'bar'
    });
  });
  self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    legend: {
    <#if (isShowFlag?? && isShowFlag)>
      show: true,
    <#elseif (!isShowFlag?? || !isShowFlag)>
      show: false,
    </#if>
    left: '${legendLocation!}',
      textStyle: textStyle,
      data: legend
    },
    xAxis: {
      type: 'category',
      name: '${xAxisName!}',
      nameGap: '${xNameGap!}',
      nameLocation: '${nameLocation!}',
      nameTextStyle: nameTextStyle,
      axisLine: axisLine,
      axisLabel: axisLabel,
      data: xResult[0]
    },
    yAxis: yAxis,
    series: resultSeries
  });
  } else {
    self.$message.error('数据请求失败');
  }
  }).catch(function() {
    self.$message.error('数据请求异常');
  })
  return self.${instanceKey!}OptionData;
<#--    没有设置数据模型时-->
<#else>
  const seriesResult = [];
  const name = ['订单总笔数', '钱包笔数', '借呗笔数'];
  const xFakeResult = [[100, 320, 150, 77, 84, 130, 76], [230, 440, 250, 240, 430, 210, 250], [305, 390, 330, 360, 320, 430, 300]];
  name.forEach((col, index) => {
    seriesResult.push({
      name: col,
      type: 'bar',
      data: xFakeResult[index],
    });
  });
  self.${instanceKey!}OptionData.push({
  title: echatrsTitle,
  tooltip: echatrsTooltip,
  legend: {
    <#if (isShowFlag?? && isShowFlag)>
      show: true,
    <#elseif (!isShowFlag?? || !isShowFlag)>
      show: false,
    </#if>
    left: '${legendLocation!}',
    textStyle: textStyle,
    data: ['订单总笔数', '钱包笔数', '借呗笔数'],
  },
  xAxis: {
    type: 'category',
    name: '${xAxisName!}',
    nameGap: '${xNameGap!}',
    nameLocation: '${nameLocation!}',
    nameTextStyle: nameTextStyle,
    axisLine: axisLine,
    axisLabel: axisLabel,
    data: ['01-01', '01-02', '01-03', '01-04', '01-05', '01-06', '01-07'],
  },
  yAxis: yAxis,
  series: seriesResult,
  });
  return self.${instanceKey!}OptionData;
</#if>