/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MultiGaugeEchartsVisitor
implements VoidVisitor {
    private final FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/multiGaugeEcharts/el_multiGaugeEcharts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        ctx.addData(instanceKey + "Data: null");
        ctx.addData(instanceKey + "OptionData: []");
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Height: " + height);
    }

    private void setParamValue(Map<String, Object> params, Map<String, Object> maps) {
        params.put("titleText", maps.get("title"));
        params.put("titleColor", ToolUtil.isNotEmpty((Object)maps.get("titleColor")) ? maps.get("titleColor") : "#000");
        params.put("gaugeTitleColor", ToolUtil.isNotEmpty((Object)maps.get("gaugeTitleColor")) ? maps.get("gaugeTitleColor") : "#61646A");
        params.put("titleFontSize", ToolUtil.isNotEmpty((Object)maps.get("titleFontSize")) ? maps.get("titleFontSize") : "18");
        params.put("fontFamily", maps.get("fontFamily"));
        params.put("fontWeight", maps.get("fontWeight"));
        params.put("gaugeTitleFontSize", ToolUtil.isNotEmpty((Object)maps.get("gaugeTitleFontSize")) ? maps.get("gaugeTitleFontSize") : "18");
        params.put("gaugeFontFamily", ToolUtil.isNotEmpty((Object)maps.get("gaugeFontFamily")) ? maps.get("gaugeFontFamily") : "Microsoft Yahei");
        params.put("gaugeFontWeight", ToolUtil.isNotEmpty((Object)maps.get("gaugeFontWeight")) ? maps.get("gaugeFontWeight") : "400");
        params.put("titleAlign", maps.get("titleAlign"));
        params.put("titleLeft", maps.get("titleLeft"));
        params.put("titleTop", maps.get("titleTop"));
        params.put("titleBackgroundColor", ToolUtil.isNotEmpty((Object)maps.get("titleBackgroundColor")) ? maps.get("titleBackgroundColor") : "transparent");
        params.put("axisLineShow", Optional.ofNullable(maps.get("axisLineShow")).orElse(false));
        params.put("axisLineWidth", ToolUtil.isNotEmpty((Object)maps.get("axisLineWidth")) ? maps.get("axisLineWidth") : "20");
        params.put("axisLineOpacity", ToolUtil.isNotEmpty((Object)maps.get("axisLineOpacity")) ? maps.get("axisLineOpacity") : "1");
        params.put("innerAxisLine", Optional.ofNullable(maps.get("innerAxisLine")).orElse(5));
        params.put("splitLineShow", Optional.ofNullable(maps.get("splitLineShow")).orElse(false));
        params.put("splitLineLength", Optional.ofNullable(maps.get("splitLineLength")).orElse(19));
        params.put("splitLineWidth", Optional.ofNullable(maps.get("splitLineWidth")).orElse(20));
        params.put("splitLineColor", Optional.ofNullable(maps.get("splitLineColor")).orElse("#fff"));
        params.put("splitLineType", ToolUtil.isNotEmpty((Object)maps.get("splitLineType")) ? maps.get("splitLineType") : "solid");
        params.put("axisTickShow", Optional.ofNullable(maps.get("axisTickShow")).orElse(false));
        params.put("axisTickColor", Optional.ofNullable(maps.get("axisTickColor")).orElse("#fff"));
        params.put("axisTickLength", Optional.ofNullable(maps.get("axisTickLength")).orElse(25));
        params.put("axisTickWidth", Optional.ofNullable(maps.get("axisTickWidth")).orElse(2));
        params.put("axisTickSplitNumber", ToolUtil.isNotEmpty((Object)maps.get("axisTickSplitNumber")) ? maps.get("axisTickSplitNumber") : "4");
        params.put("splitNumber", Optional.ofNullable(maps.get("splitNumber")).orElse(10));
        params.put("splitNumberSmall", Optional.ofNullable(maps.get("splitNumberSmall")).orElse(6));
        params.put("axisLabelShow", Optional.ofNullable(maps.get("axisLabelShow")).orElse(false));
        params.put("axisLabelDistance", ToolUtil.isNotEmpty((Object)maps.get("axisLabelDistance")) ? maps.get("axisLabelDistance") : "12");
        params.put("axisLabelColor", maps.get("axisLabelColor"));
        params.put("axisLabelFontSize", ToolUtil.isNotEmpty((Object)maps.get("axisLabelFontSize")) ? maps.get("axisLabelFontSize") : "12");
        params.put("pointerShow", Optional.ofNullable(maps.get("pointerShow")).orElse(false));
        params.put("pointerWidth", ToolUtil.isNotEmpty((Object)maps.get("pointerWidth")) ? maps.get("pointerWidth") : "5");
        params.put("detailShow", Optional.ofNullable(maps.get("detailShow")).orElse(false));
        params.put("detailColor", ToolUtil.isNotEmpty((Object)maps.get("detailColor")) ? maps.get("detailColor") : "#61646A");
        params.put("detailUnit", maps.get("detailUnit"));
        params.put("detailFontSize", ToolUtil.isNotEmpty((Object)maps.get("detailFontSize")) ? maps.get("detailFontSize") : "14");
        params.put("detailFontWeight", maps.get("detailFontWeight"));
        params.put("detailBackgroundColor", maps.get("detailBackgroundColor"));
        params.put("detailShadowColor", maps.get("detailShadowColor"));
        params.put("detailShadowBlur", maps.get("detailShadowBlur"));
        params.put("tooltipBgColor", maps.get("tooltipBgColor"));
        params.put("toolColor", ToolUtil.isNotEmpty((Object)maps.get("toolColor")) ? maps.get("toolColor") : "#666");
        params.put("toolFontSize", ToolUtil.isNotEmpty((Object)maps.get("toolFontSize")) ? maps.get("toolFontSize") : "12");
        params.put("toolFontFamily", maps.get("toolFontFamily"));
        params.put("toolFontWeight", maps.get("toolFontWeight"));
        params.put("toolFontStyle", maps.get("toolFontStyle"));
        params.put("toolLineHeight", maps.get("toolLineHeight"));
        params.put("toolShow", Optional.ofNullable(maps.get("toolShow")).orElse(false));
        params.put("toolPaddingTop", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingTop")) ? maps.get("toolPaddingTop") : "10");
        params.put("toolPaddingLeft", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingLeft")) ? maps.get("toolPaddingLeft") : "10");
        params.put("toolShadow", maps.get("toolShadow"));
        params.put("minValue", Optional.ofNullable(maps.get("minValue")).orElse(0));
        params.put("maxValueOne", Optional.ofNullable(maps.get("maxValueOne")).orElse(100));
        params.put("maxValueTwo", Optional.ofNullable(maps.get("maxValueTwo")).orElse(100));
        params.put("maxValueThere", Optional.ofNullable(maps.get("maxValueThere")).orElse(100));
        params.put("dataTitleOne", maps.get("dataTitleOne"));
        params.put("dataTitleTwo", maps.get("dataTitleTwo"));
        params.put("dataTitleThere", maps.get("dataTitleThere"));
        params.put("detailUnitOne", maps.get("detailUnitOne"));
        params.put("detailUnitTwo", maps.get("detailUnitTwo"));
        params.put("detailUnitThere", maps.get("detailUnitThere"));
        params.put("topicColorStr", maps.get("topicColor").toString());
    }

    private void setDataModel(Map<String, Object> params, DataSModelAnalysis dataModelAnalysis, LcdpComponent lcdpComponent, Ctx ctx) throws IOException, LcdpException {
        DataSConditionAnalysis dataConditionAnalysis = dataModelAnalysis.getCondition();
        Map dataFieldAnalysisMap = dataModelAnalysis.getFields();
        String labelField = "";
        String valueField = "";
        if (ToolUtil.isNotEmpty((Object)dataFieldAnalysisMap)) {
            for (Map.Entry fieldList : dataFieldAnalysisMap.entrySet()) {
                List fieldAnalyses = (List)fieldList.getValue();
                for (DataSFieldAnalysis dataFieldAnalysis : fieldAnalyses) {
                    String dataItemValue;
                    List dataItemPath = dataFieldAnalysis.getDataItemPath();
                    if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                    switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                        case "label": {
                            labelField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                        case "value": {
                            valueField = dataFieldAnalysis.getFieldName();
                            break;
                        }
                    }
                }
            }
        }
        if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
            String sortConditionName;
            DataSortConditionAnalysis dataSortConditionAnalysis;
            String querySelectionName;
            List conditionList;
            String operationName = "hussarQuery";
            String apiFileName = "";
            String apiFilePath = "";
            String dataModelId = dataModelAnalysis.getDataModelId();
            if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                apiFileName = this.fileMappingService.getFileName(dataModelId);
                apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
            }
            if (ToolUtil.isNotEmpty((Object)dataConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataConditionAnalysis.getQueryConditionModelList()))) {
                params.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                params.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
            }
            if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataConditionAnalysis.getSelectCondition()))) {
                operationName = operationName + querySelectionName;
            }
            if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                operationName = operationName + sortConditionName;
            }
            if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
            }
            params.put("importName", apiFileName);
            params.put("importMethod", operationName);
            params.put("axisCols", labelField);
            params.put("seriesCols", valueField);
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(100);
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        Map maps = lcdpComponent.getProps();
        if (ToolUtil.isNotEmpty((Object)maps)) {
            this.setParamValue(params, maps);
            DataSAnalysis dataAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataModelAnalysis = dataAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataModelAnalysis)) {
                this.setDataModel(params, dataModelAnalysis, lcdpComponent, ctx);
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"/template/elementui/element/multiGaugeEcharts/el_multiGaugeEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"/template/elementui/element/multiGaugeEcharts/el_multiGaugeEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"/template/elementui/element/multiGaugeEcharts/el_multiGaugeEcharts_watch.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/elementui/element/multiGaugeEcharts/el_multiGaugeEcharts_Success.ftl", params));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }
}

