/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GaugeEchartsVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/elementui/element/gaugeEcharts/gauge_echarts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData(instanceKey + "Data: null");
        ctx.addData(instanceKey + "OptionData: []");
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, CharSequence> echartsParams = new HashMap<String, CharSequence>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        Map echartsMaps = lcdpComponent.getProps();
        if (ToolUtil.isNotEmpty((Object)echartsMaps)) {
            echartsParams.put("titleText", (CharSequence)echartsMaps.get("title"));
            echartsParams.put("titleColor", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleColor")) ? echartsMaps.get("titleColor") : "#000"));
            echartsParams.put("titleFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleFontSize")) ? echartsMaps.get("titleFontSize") : "18"));
            echartsParams.put("fontFamily", (CharSequence)echartsMaps.get("fontFamily"));
            echartsParams.put("fontStyle", (CharSequence)echartsMaps.get("fontStyle"));
            echartsParams.put("fontWeight", (CharSequence)echartsMaps.get("fontWeight"));
            echartsParams.put("titleAlign", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("titleAlign")) ? echartsMaps.get("titleAlign") : "center"));
            echartsParams.put("numberOfRow", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("numberOfRow")) ? echartsMaps.get("numberOfRow") : "10"));
            echartsParams.put("tooltipBgColor", (CharSequence)echartsMaps.get("tooltipBgColor"));
            echartsParams.put("toolColor", (CharSequence)echartsMaps.get("toolColor"));
            echartsParams.put("toolFontSize", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("toolFontSize")) ? echartsMaps.get("toolFontSize") : "18"));
            echartsParams.put("toolFontFamily", (CharSequence)echartsMaps.get("toolFontFamily"));
            echartsParams.put("toolFontWeight", (CharSequence)echartsMaps.get("toolFontWeight"));
            echartsParams.put("toolFontStyle", (CharSequence)echartsMaps.get("toolFontStyle"));
            echartsParams.put("pointerName", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("pointerName")) ? echartsMaps.get("pointerName") : ""));
            echartsParams.put("max", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("max")) ? echartsMaps.get("max") : "100"));
            echartsParams.put("min", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("min")) ? echartsMaps.get("min") : "0"));
            echartsParams.put("unit", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("unit")) ? echartsMaps.get("unit") : ""));
            echartsParams.put("gaugeName", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("gaugeName")) ? echartsMaps.get("gaugeName") : ""));
            echartsParams.put("gaugeValue", (CharSequence)(ToolUtil.isNotEmpty(echartsMaps.get("gaugeValue")) ? echartsMaps.get("gaugeValue") : "50"));
            echartsParams.put("seriesName", (CharSequence)echartsMaps.get("seriesName"));
            DataSAnalysis dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String labelField = "";
                String valueField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                labelField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            valueField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    String sortConditionName;
                    DataSortConditionAnalysis dataSortConditionAnalysis;
                    String querySelectionName;
                    List conditionList;
                    String operationName = "hussarQuery";
                    String dataSelectId = lcdpComponent.getInstanceKey();
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                        operationName = operationName + sortConditionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    echartsParams.put("importName", apiFileName);
                    echartsParams.put("importMethod", operationName);
                    echartsParams.put("seriesName", labelField);
                    echartsParams.put("seriesValue", valueField);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"/template/elementui/element/gaugeEcharts/gauge_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"/template/elementui/element/gaugeEcharts/gauge_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"/template/elementui/element/gaugeEcharts/gauge_echarts_watch.ftl", echartsParams));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/elementui/element/gaugeEcharts/gauge_echarts_success.ftl", echartsParams));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }
}

