<#--定义宏递归生成表头-->
<#macro colTree colList>
    <#list colList as item>
    <#--是否为多级表头-->
        <#if item.isParent??>
        <el-table-column label="${item.title!}" header-align="${item.align!}">
            <@colTree colList=item.children></@colTree>
        </el-table-column>
        <#elseif item.rowSummary?? && item.rowSummary>
            <el-table-column label="${item.title!}"
                    prop="${item.field!}"
                    <#if (item.sort?? && item.sort!)>
                        sortable
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                       <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                        width="${item.colWidth.number!}"
                       </#if>
                    </#if>
                     align="${item.bodyAlign!}"
                     header-align="${item.align!}">
                <#if item.rowCalculate??>
                <template slot-scope="scope">
                    {{$numeral(${item.rowCalculate.formulaReplace}).format('${item.rowCalculate.format}')}}
                </template>
                </#if>
            </el-table-column>
        <#else>
            <el-table-column
                    prop="${item.field!}"
                    label="${item.title!}"
                    <#if (item.sort?? && item.sort!)>
                        sortable
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                        <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                        width="${item.colWidth.number!}"
                        </#if>
                    </#if>
                    align="${item.bodyAlign!}"
                    header-align="${item.align!}" :show-overflow-tooltip=true>
                <#if item.field == "">
                    <template>
                        <#if item.hyperlinks??>
                            <span @click="${instanceKey!}${item.field!}CLICK"></span>
                        <#else>
                        </#if>
                    </template>
                <#else>
                    <template slot-scope="scope">
                        <#if item.hyperlinks??>
                            <span class="jxd_hyperlinks_span" @click="${instanceKey!}${item.field!}CLICK(scope.row)">
                            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                                {{(scope.row.${item.field!}) ? $moment(scope.row.${item.field!}).format('${item.selectType.dateFmtSelect!}') : '--'}}
                            <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                {{$numeral(scope.row.${item.field!}).format('${item.selectType.numberFmtSelect!}')}}
                            <#else>
                                {{scope.row.${item.field!}}}
                            </#if>
                            </span>
                        <#elseif item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                            {{(scope.row.${item.field!}) ? $moment(scope.row.${item.field!}).format('${item.selectType.dateFmtSelect!}') : '--'}}
                        <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                            {{$numeral(scope.row.${item.field!}).format('${item.selectType.numberFmtSelect!}')}}
                        <#else>
                            {{scope.row.${item.field!}}}
                        </#if>
                    </template>
                </#if>

            </el-table-column>
        </#if>
    </#list>
</#macro>
<div>
    <el-table
            <#--列表loading-->
            v-loading="${instanceKey!}TableLoading"
            <#--隔行变色-->
<#--            <#if stripe?? && stripe>-->
<#--                :stripe="${instanceKey!}Stripe"-->
<#--            </#if>-->
            <#--列表边框-->
            <#if borderY?? && borderY>
                :border="${instanceKey!}BorderY"
            </#if>
            <#--表格高度（分页）-->
            <#if isPagination?? && isPagination>
                :height="'calc(100% - 53px)'"
            <#else >
                :height="'100%'"
            </#if>
            <#--列表合计-->
            <#if columnSummary?? && columnSummary>
                :summary-method="${instanceKey!}ColumnSummaryEvent"
                show-summary
            </#if>
            <#--选择项变化-->
            @selection-change="${instanceKey!}SelectRow"
            <#--是否复选框只能选择一个-->
            ref="${instanceKey!}TableRef"
            <#if isRadio?? && isRadio!>
                 @select="${instanceKey!}Select" @select-all="${instanceKey!}SelectAll"
            </#if>
            <#--行单选，选中后该行高亮-->
            <#if isSingleSelect?? && isSingleSelect!>
                highlight-current-row @current-change="${instanceKey!}SingleSelectRow"
            </#if>
            <#--层级间缩进-->
            :indent="<#if indent??>${indent!}<#else>16</#if>"
            <#if rowKey??>
                row-key="${rowKey!}"
            </#if>
            :tree-props="{children: 'children', hasChildren: 'hasChildren'}"
            <#--单双击耦合 增加额外计算时间方法-->
            <#if (colClick?? && colClick!) && dblClick?? && dblClick!>
                @row-click="${instanceKey!}ColClickFront"
                @row-dblclick="${instanceKey!}DblClickFront"
            <#else>
                <#--单击事件-->
                <#if colClick?? && colClick>
                    @row-click="${instanceKey!}ColClick"
                </#if>
                <#--双击事件-->
                <#if dblClick?? && dblClick>
                    @row-dblclick="${instanceKey!}DblClick"
                </#if>
            </#if>
            <#if cellClick?? && cellClick>
                @cell-click="${instanceKey!}CellClickInfo"
                :cell-class-name="${instanceKey!}CellClassNAme"
            </#if>
    >
        <#--列表选择框-->
        <#if showSelection?? && showSelection>
            <el-table-column type="selection" :width="50" align="center">
            </el-table-column>
        </#if>
        <#--列表序号列-->
        <#if showIndex?? && showIndex>
            <el-table-column type="index" label="序号" :width="<#if indexWidth??>${indexWidth.localValue!}<#else>60</#if>" align="center">
            </el-table-column>
        </#if>
        <#--列表列-->
        <@colTree colList=tableShowFields!></@colTree>
        <#if tableShowFields?? && tableShowFields?size == 0>
            <el-table-column></el-table-column>
        </#if>
        <#--操作列-->
        <#if needOperation?? && needOperation>
            <el-table-column
                 align="center"
                 header-align="center"
                 <#if !(needOperationAutoWidth?? && needOperationAutoWidth!)>
                     :width="<#if needOperationWidth?? && needOperationWidth! != 0>${needOperationWidth!}<#else>140</#if>"
                 </#if>
                 label="<#if needOperationName??>${needOperationName!}<#else>操作</#if>">
                <template slot-scope="scope">
                    <#if needOperations??>
                    <div style="text-align: center;width: 100%;white-space: break-spaces">
                    <#list needOperations as item>
                       <el-button size="mini" style="margin: 0;float: unset;<#if item.bg??>background: ${item.bg!};</#if><#if item.borderColor??>border-color: ${item.borderColor!};</#if><#if item.color??>color: ${item.color!}</#if>" @click.native.stop="${instanceKey!}${item.eventName?cap_first}(scope.row)">${item.label}</el-button>
                    </#list>
                    </div>
                    </#if>
                </template>
            </el-table-column>
        </#if>
        <#--合计行-->
        <#if rowSummary?? && rowSummary>
            <el-table-column align="${rowCalculate.align!}" label="合计">
                <template slot-scope="scope">
                    <span>{{ ${instanceKey!}RowSummaryEvent(scope.row) }} ${rowCalculate.unit!}</span>
                </template>
            </el-table-column>
        </#if>
    </el-table>
    <#--分页组件-->
    <#if isPagination?? && isPagination>
        <div class="page">
            <el-pagination
                background
<#--               style="height: 8%!important;"-->
                @size-change="${instanceKey!}HandleSizeChange"
                @current-change="${instanceKey!}HandleCurrentChange"
                :page-size="${instanceKey!}ListQuery.size"
                <#if (size?? && size! != 10 && size! != 20 && size! != 50)>
                    :page-sizes="[${size!} 10, 20, 50]"
                </#if>
                <#if (layout??)>
                    :layout="${instanceKey!}Layout"
                </#if>
                :total="${instanceKey!}TableTotal">
            </el-pagination>
        </div>
    </#if>
</div>