/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.constant.TriggerType;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.defaultvalue.DefaultValueAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.defaultvalue.MaxIdTableRule;
import com.jxdinfo.speedcode.common.analysismodel.formcheck.ELFormCheckAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.formcheck.ELFormCheckItemAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.reference.ComponentReference;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigItemInfo;
import com.jxdinfo.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.model.Operation;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.runner.formcheck.FormCheckInfo;
import com.jxdinfo.speedcode.common.runner.formcheck.FormCheckObject;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentBindUtil;
import com.jxdinfo.speedcode.common.utils.DefaultValueUtil;
import com.jxdinfo.speedcode.common.utils.OperationUtil;
import com.jxdinfo.speedcode.common.utils.ReplaceDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FormVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List triggers = lcdpComponent.getTriggers();
        lcdpComponent.registerTemplatePath("/template/elementui/element/form/form.ftl");
        lcdpComponent.addRenderParam("id", (Object)lcdpComponent.getInstanceKey());
        lcdpComponent.addRenderParam("triggers", (Object)triggers);
        this.renderMethod(lcdpComponent, ctx);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderFormData(lcdpComponent, ctx);
    }

    private void renderLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"dataLoadConfig");
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)showConfigAnalyses) && ToolUtil.isNotEmpty((Object)((ShowConfigAnalysis)showConfigAnalyses.get(0)).getDataModelId())) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, (List)showConfigAnalyses);
            showConfigItemInfos.forEach(itemInfo -> {
                if (ToolUtil.isNotEmpty((Object)itemInfo.getQueryObjectAttr())) {
                    itemInfo.setQueryObjectAttrList((List)CollUtil.toList((Object[])itemInfo.getQueryObjectAttr().split(",")));
                }
            });
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos.get(0));
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            replaceDataMap.put("importName", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getImportName());
            replaceDataMap.put("queryObjectAttrList", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getQueryObjectAttrList());
            replaceDataMap.put("importMethod", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getImportMethod());
            replaceDataMap.put("mappingMap", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getMappingRelates());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            replaceDataMap.put("insValue", valueVisitor.getValue(null));
            ctx.addMethod("async " + lcdpComponent.getInstanceKey() + "DataLoad", RenderUtil.renderTemplate((String)"template/elementui/element/form/elForm_dataLoad.ftl", replaceDataMap));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "DataLoad()");
        }
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("labelWidth"))) {
            lcdpComponent.addAttr("labelWidth", lcdpComponent.getProps().get("labelWidth").toString());
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"showConfigs");
        this.renderFormQuery(lcdpComponent, ctx, showConfigAnalyses);
        this.renderReplaceData(lcdpComponent, ctx, showConfigAnalyses);
        this.renderLoad(lcdpComponent, ctx);
        this.renderCheckRule(lcdpComponent, ctx);
    }

    private void renderCheckRule(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List elFormCheckAnalyses;
        Object formCheckInfo = lcdpComponent.getProps().get("formCheck");
        if (ToolUtil.isNotEmpty(formCheckInfo) && (elFormCheckAnalyses = (List)JSONObject.parseObject((String)JSON.toJSONString(formCheckInfo), (TypeReference)new TypeReference<List<ELFormCheckAnalysis>>(){}, (Feature[])new Feature[0])).size() > 0) {
            Map formCheckMap = FormCheckInfo.formCheckMap;
            ArrayList<JSONObject> checkFunctions = new ArrayList<JSONObject>();
            for (ELFormCheckAnalysis elFormCheckAnalysis : elFormCheckAnalyses) {
                HashMap<String, Object> ruleMap = new HashMap<String, Object>();
                String methodName = lcdpComponent.getInstanceKey() + StringUtils.capitalize((String)elFormCheckAnalysis.getId());
                ArrayList<JSONObject> formCheckObjects = new ArrayList<JSONObject>();
                for (ELFormCheckItemAnalysis elFormCheckItemAnalysis : elFormCheckAnalysis.getCheckTypes()) {
                    FormCheckObject formCheckObject = (FormCheckObject)formCheckMap.get(elFormCheckItemAnalysis.getCheckType());
                    if (!ToolUtil.isNotEmpty((Object)formCheckObject)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)formCheckObject));
                    if (ToolUtil.isNotEmpty((Object)elFormCheckItemAnalysis.getErrorMsg())) {
                        String errorMsg = elFormCheckItemAnalysis.getErrorMsg();
                        if (errorMsg.contains("${\u5217\u540d}")) {
                            String title = this.getTitleByField(lcdpComponent, elFormCheckAnalysis.getCheckFormCol());
                            errorMsg = errorMsg.replaceAll("\\$\\{\u5217\u540d}", title);
                        }
                        jsonObject.put("errorMsg", (Object)errorMsg);
                    } else {
                        jsonObject.put("errorMsg", (Object)"");
                    }
                    jsonObject.put("customValue", (Object)elFormCheckItemAnalysis.getCheckValue());
                    formCheckObjects.add(jsonObject);
                }
                ruleMap.put("checkList", formCheckObjects);
                ruleMap.put("field", elFormCheckAnalysis.getCheckFormCol());
                RenderCore renderCore = new RenderCore();
                renderCore.registerParam(ruleMap);
                renderCore.registerTemplatePath("template/elementui/element/form/form_checkMethod.ftl");
                RenderResult renderResult = renderCore.render();
                if (!renderResult.isStatus()) continue;
                ArrayList<String> args = new ArrayList<String>();
                args.add("value");
                ctx.addMethod(methodName, args, renderResult.getRenderString());
                JSONObject singleFunc = new JSONObject();
                singleFunc.put("field", (Object)elFormCheckAnalysis.getCheckFormCol());
                singleFunc.put("methodName", (Object)methodName);
                checkFunctions.add(singleFunc);
            }
            HashMap<String, Object> resultMethod = new HashMap<String, Object>();
            resultMethod.put("checkArray", checkFunctions);
            resultMethod.put("formIns", lcdpComponent.getInstanceKey());
            RenderCore renderCore = new RenderCore();
            renderCore.registerParam(resultMethod);
            renderCore.registerTemplatePath("template/elementui/element/form/form_checkResultHandler.ftl");
            RenderResult renderResult = renderCore.render();
            if (renderResult.isStatus()) {
                ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._FORM_VERIFY, renderResult.getRenderString());
            }
        }
    }

    public String getTitleByField(LcdpComponent lcdpComponent, String field) {
        List tableOptColsAnalyses;
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("component_cols");
        if (ToolUtil.isNotEmpty((Object)optColsJSONArray) && ToolUtil.isNotEmpty((Object)(tableOptColsAnalyses = JSONObject.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class)))) {
            for (TableOptColsAnalysis col : tableOptColsAnalyses) {
                if (!ToolUtil.isNotEmpty((Object)col.getField()) || !col.getField().equals(field)) continue;
                return col.getTitle();
            }
        }
        return "";
    }

    private void renderFormQuery(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        String singleUploadName;
        List<String> singleUpload;
        String checkBoxName;
        List<String> checkBox;
        String multipleImgUploadName;
        List<String> multipleImgUpload2;
        HashMap<String, Object> map = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/elementui/element/form/form_load.ftl");
        Operation operation = OperationUtil.getComponentDefaultOperation((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)"formQuery", (String)("{\nid: " + FormVisitor.getFormQueryId(ctx, lcdpComponent) + ",\n}"));
        map.put("operation", operation);
        map.put("instanceKey", lcdpComponent.getInstanceKey());
        map.put("insForm", lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType());
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getDataModelId()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getField()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getRelateField())) {
            map.put("isShowConfig", true);
        }
        if (lcdpComponent.haveTriggerByTriggerName(TriggerType._FORM_LOADED.getType())) {
            map.put("isLoadedEvent", true);
        }
        if ((multipleImgUpload2 = this.renderSlotData(lcdpComponent, ctx, multipleImgUploadName = "com.jxdinfo.elementui.JXDmultipleImgUpload")).size() > 0) {
            map.put("multipleImgUpload", multipleImgUpload2);
        }
        if ((checkBox = this.renderSlotData(lcdpComponent, ctx, checkBoxName = "com.jxdinfo.elementui.JXDElCheckBox")).size() > 0) {
            map.put("checkBox", checkBox);
        }
        if ((singleUpload = this.renderSlotData(lcdpComponent, ctx, singleUploadName = "com.jxdinfo.elementui.JXDSingleUpload")).size() > 0) {
            map.put("singleUpload", singleUpload);
        }
        renderCore.registerParam(map);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "FormLoad", renderResult.getRenderString());
        }
    }

    private void renderFormData(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List tableOptColsAnalyses;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formData", lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType());
        ArrayList<String> fields = new ArrayList<String>();
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("component_cols");
        if (ToolUtil.isNotEmpty((Object)optColsJSONArray) && ToolUtil.isNotEmpty((Object)(tableOptColsAnalyses = JSONObject.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class)))) {
            for (TableOptColsAnalysis col : tableOptColsAnalyses) {
                if (!ToolUtil.isNotEmpty((Object)col.getField())) continue;
                fields.add(col.getField() + " :" + this.getDefaultValue(lcdpComponent, ctx, col));
            }
        }
        params.put("relateInsFields", fields);
        ctx.addData(RenderUtil.renderTemplate((String)"/template/elementui/element/form/form_data.ftl", params));
    }

    private String getDefaultValue(LcdpComponent lcdpComponent, Ctx ctx, TableOptColsAnalysis col) throws LcdpException {
        String defaultValue = "''";
        if (ToolUtil.isNotEmpty((Object)col)) {
            DefaultValueAnalysis defaultValueAnalysis = col.getDefaultValue();
            if (ToolUtil.isNotEmpty((Object)defaultValueAnalysis) && defaultValueAnalysis.isDefaultValue() && defaultValueAnalysis.getDefaultValueType().equals("maxIdTable")) {
                HashMap<String, String> param = new HashMap<String, String>();
                MaxIdTableRule rule = defaultValueAnalysis.getMaxIdTableRule();
                if (ToolUtil.isNotEmpty((Object)rule)) {
                    String fieldName = rule.getFieldName();
                    String tableName = rule.getTableName();
                    param.put("importName", "getNumber");
                    param.put("fieldName", fieldName);
                    param.put("tableName", tableName);
                    param.put("maxIdData", lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType() + CodeSuffix._POINT.getType() + col.getField());
                    ctx.addImports("import { getNumber } from '@/api/demo/idTableDemo'");
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "getNumber", RenderUtil.renderTemplate((String)"/template/elementui/element/form/form_getNumber.ftl", param));
                    ctx.addCreated(CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "getNumber();");
                }
            } else {
                defaultValue = DefaultValueUtil.renderDefaultValue((DefaultValueAnalysis)defaultValueAnalysis, (String)col.getDataType());
            }
        }
        if (defaultValue.equals("0") || defaultValue.equals("null")) {
            defaultValue = "''";
        }
        return defaultValue;
    }

    private void renderReplaceData(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getDataModelId()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getField()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getRelateField())) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, showConfigAnalyses);
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos);
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            String formValue = valueVisitor.getValue(null);
            replaceDataMap.put("formData", formValue);
            for (ShowConfigItemInfo showConfigItemInfo : showConfigItemInfos) {
                if (!ToolUtil.isNotEmpty((Object)showConfigItemInfo.getTableFieldWhere())) continue;
                HashMap<String, String> replaceWatchData = new HashMap<String, String>();
                replaceWatchData.put("formIns", lcdpComponent.getInstanceKey());
                String methodName = "\"" + formValue.replace(CodePrefix._THIS.getType(), "") + CodeSuffix._POINT.getType() + showConfigItemInfo.getTableFieldWhere() + "\"";
                ctx.addWatch(methodName, RenderUtil.renderTemplate((String)"/template/elementui/element/form/form_watchReplace.ftl", replaceWatchData));
            }
            ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._REPLACE_DATA.getType(), RenderUtil.renderTemplate((String)"/template/elementui/element/form/form_replaceDataMethod.ftl", replaceDataMap));
        }
    }

    private List<String> renderSlotData(LcdpComponent lcdpComponent, Ctx ctx, String name) throws Exception {
        JSONArray componentCols = (JSONArray)lcdpComponent.getProps().get("component_cols");
        ArrayList<String> multipleImgUpload2 = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)componentCols)) {
            for (Object componentCol : componentCols) {
                JSONObject map = JSONObject.parseObject((String)JSON.toJSONString(componentCol));
                String componentInstanceKey = (String)map.get("instanceKey");
                if (!ToolUtil.isNotEmpty((Object)componentInstanceKey)) continue;
                LcdpComponent component = (LcdpComponent)ctx.getComponentMap().get(componentInstanceKey);
                String formColumn = "self." + lcdpComponent.getInstanceKey() + "FormData." + map.get("field");
                if (ToolUtil.isNotEmpty((Object)component) && "com.jxdinfo.elementui.JXDmultipleImgUpload".equals(name) && "com.jxdinfo.elementui.JXDmultipleImgUpload".equals(component.getName())) {
                    multipleImgUpload2.add("self." + component.getInstanceKey() + "Files = self." + component.getInstanceKey() + "GetFileList(" + formColumn + ");");
                    continue;
                }
                if (ToolUtil.isNotEmpty((Object)component) && "com.jxdinfo.elementui.JXDElCheckBox".equals(name) && "com.jxdinfo.elementui.JXDElCheckBox".equals(component.getName())) {
                    multipleImgUpload2.add(formColumn + "=" + formColumn + "=== '1' ||" + formColumn + "=== 'true' ||" + formColumn + "=== 1;");
                    continue;
                }
                if (!ToolUtil.isNotEmpty((Object)component) || !"com.jxdinfo.elementui.JXDSingleUpload".equals(name) || !"com.jxdinfo.elementui.JXDSingleUpload".equals(component.getName())) continue;
                multipleImgUpload2.add("self." + component.getInstanceKey() + "FileQuery(" + formColumn + ");");
            }
        }
        return multipleImgUpload2;
    }

    private static String getFormQueryId(Ctx ctx, LcdpComponent lcdpComponent) throws LcdpException {
        JSONObject datamodel;
        JSONObject reference;
        JSONObject datas = JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()));
        if (ToolUtil.isNotEmpty((Object)datas) && ToolUtil.isNotEmpty((Object)datas.get((Object)"datamodel")) && ToolUtil.isNotEmpty((Object)(reference = (datamodel = (JSONObject)datas.get((Object)"datamodel")).getJSONObject("businessIdData")))) {
            Map fromConfig;
            ComponentReference componentReference = null;
            componentReference = (ComponentReference)JSON.parseObject((String)reference.toString(), ComponentReference.class);
            if (ComponentBindUtil.isReferenceConfig((ComponentReference)componentReference) && ToolUtil.isNotEmpty((fromConfig = ComponentBindUtil.getAssignmentParam((LcdpComponent)lcdpComponent, (Ctx)ctx, (ComponentReference)componentReference)).get("referResult"))) {
                return fromConfig.get("referResult").toString();
            }
        }
        return "self.$route.query.businessId";
    }
}

