/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.event;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.Action;
import com.jxdinfo.speedcode.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ModelUtil;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.ImportExcelDataAction")
public class ImportExcelData
implements ActionVisitor {
    private FileMappingService fileMappingService;

    @Autowired
    public ImportExcelData(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/elementui/event/ImportExcelData.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        map.put("trigger", triggerName);
        Map params = action.getParamValues();
        String dataTableId = "";
        DataSAnalysis dataSAnalysis = null;
        DataSModelAnalysis dataSModelAnalysis = null;
        String apiFileName = "";
        String operationName = "tableSave";
        String apiFilePath = "";
        if (ToolUtil.isNotEmpty((Object)params)) {
            dataTableId = String.valueOf(((Map)params.get("importExcelData")).get("instanceKey"));
        }
        if (ToolUtil.isNotEmpty((Object)dataTableId)) {
            dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((LcdpComponent)ctx.getComponentMap().get(dataTableId)).getDatas()), DataSAnalysis.class);
        }
        if (ToolUtil.isNotEmpty(dataSAnalysis)) {
            dataSModelAnalysis = dataSAnalysis.getDatamodel();
        }
        map.put("tableInstanceKey", dataTableId);
        renderCore.registerParam(map);
        RenderResult renderResult = renderCore.render();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            String dataModelId = dataSModelAnalysis.getDataModelId();
            String pageId = ctx.getPageInfo().getId();
            Boolean isPrivate = ToolUtil.isNotEmpty(params.get("isPrivate")) ? (Boolean)params.get("isPrivate") : false;
            if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                Map importMap = ModelUtil.getImport((Ctx)ctx, (boolean)isPrivate, (String)pageId, (String)dataModelId);
                apiFileName = (String)importMap.get("apiFileName");
                apiFilePath = (String)importMap.get("apiFilePath");
            }
        }
        map.put("importName", apiFileName);
        map.put("importMethod", operationName);
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
            ctx.addMethod(dataTableId + "importF", RenderUtil.renderTemplate((String)"/template/elementui/event/ImportExcelDataMethod.ftl", map));
            ctx.addImports("import XLSX from 'xlsx'");
        }
        if (ToolUtil.isNotEmpty((Object)apiFileName) && ToolUtil.isNotEmpty((Object)apiFilePath)) {
            ctx.addImports("import * as " + apiFileName + " from \"" + apiFilePath + "\"");
        }
    }
}

