const seriesResult = [];
<#--主题颜色-->
const colorValue = ${topicColorStr!};
<#--标题-->
const echatrsTitle = {
text: '${titleText!}',
textStyle: {
color: '${titleColor!}',
fontSize: '${titleFontSize!}',
fontFamily: '${fontFamily!}',
fontWeight: '${fontWeight!}',
},
left: '${titleAlign!}',
top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
};
<#--提示信息-->
const echatrsTooltip = {
trigger: 'item',
backgroundColor: '${tooltipBgColor!}',
show:${toolShow?string!},
textStyle: {
color: '${toolColor!}',
fontSize: '${toolFontSize!}',
fontFamily: '${toolFontFamily!}',
fontWeight: '${toolFontWeight!}',
fontStyle: '${toolFontStyle!}',
lineHeight: '${toolLineHeight!}',
},
padding: ['${toolPaddingTop!}', '${toolPaddingLeft!}'],
extraCssText: 'box-shadow: ${toolShadow!};'
};
<#--图例样式-->
const textStyle = {
color: '${legendColor!}',
fontSize: '${legendFontSize!}',
fontFamily: '${legendFontFamily!}',
fontWeight: '${legendFontWeight!}',
fontStyle: '${legendFontStyle!}',
};
<#--指示器名称(轴名称)样式-->
const radarName = {
show: ${isShowName?string!},
color: '${indicatorNameColor!}',
textStyle:{
fontSize: '${indicatorNameFontSize!}',
fontFamily: '${indicatorNameFontFamily!}',
fontWeight: '${indicatorNameFontWeight!}',
fontStyle: 'normal'
}

};
<#--坐标轴-->
const axisLine = {
lineStyle: {
color: '${axisLineColor!}',
width: '${axisLineWidth!}',
type: '${axisLineType!}',
}
};
<#--分割线颜色splitLineColor-->
<#assign sub = '${splitLineColor!}'/>
<#--分割设置-->
const splitLine = {
lineStyle:{
<#if sub != "">
    color: '${splitLineColor!}',
    width: '${splitLineWidth!}',
    type: '${splitLineType!}',
</#if>
}
};
<#--分割面积样式-->
const splitArea = {
show: ${splitAreaShow?string!},
areaStyle: {
color: ['${splitAreaColorOne!}','${splitAreaColorTwo!}'],
opacity: '${splitAreaOpacity!}'
}
};
<#--刻度线标签样式-->
const axisLabel = {
show: ${axisLabelShow?string!},
margin:'${axisLabelMargin!}',
color: '${axisLabelColor!}',
fontSize: '${axisLabelFontSize!}',
fontFamily: '${axisLabelFontFamily!}',
formatter(value) {
if (!isNaN(value)) {
return parseFloat(value).toFixed(2);
}
}
};
const axisTick = {
show: ${axisTickShow?string!},
length: '${axisTickLength!}',
}
<#if importName?? && importName != "">
    <#if queryAttr??>
        let ${importName!}Obj = {
        ${queryAttr}
        };
    <#--    若查询条件项为空，则清空option-->
        <#if (queryCheck?? && queryCheck != "")>
            if(${queryCheck}){
            return;
            }
        </#if>
    <#else>
        let ${importName!}Obj = {};
    </#if>
    const databaseData = [];
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if (res.code === "0") {
<#--查询到的数据  {预算分配  60  销售,管理,信息技术,客服,研发,市场   43,53,44,62,54},
                {实际开销  70  销售,管理,信息技术,客服,研发,市场   23,33,44,32,24}-->
    res.data.forEach((item) => {
    databaseData.push(
    {"name": item.${axisCols!},
    "value": item.${seriesCols!},
    "max":item.${maxValue!},
    "group":item.${groupValue!}
    });
    });
<#--[销售,管理,信息技术,客服,研发,市场]-->
    const itemName = [];
<#--[[43,53,44,62,54], [23,33,44,32,24]];-->
    const itemValue = [];
<#--[预算分配,实际开销]-->
    const indicatorData = [];
<#--最大值 [60,70]-->
    const itemMaxValue = [];
    const resultSeries = [];
<#--全部数值的数组-->
    databaseData.forEach((item,index) => {
    const subName = item.name.split(",");
    const subMax = item.max.split(",");
    if(index==0){
    itemName.push(...subName);
    }
    if (index == 0) {
    itemMaxValue.push(...subMax);
    }
    indicatorData.push(item.group);
    itemValue.push(item.value.split(","));
    resultSeries.push({
    name: indicatorData[index],
    value: itemValue[index],
    });
    });
<#--设置最大值配置-->
    const indicator = [];
    itemName.forEach((item,index) => {
    indicator.push({
    name: item,
    max: itemMaxValue[index],
    });
    });
<#--雷达图数据-->
    seriesResult.push({
    name: '雷达图',
    type: 'radar',
    symbol: '${symbolIcon!}',
    symbolSize: '${symbolIconSize!}',
    data: resultSeries,
    color: colorValue
    });
    self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    radar: {
    shape: '${radarShape!}',
    splitNumber: ${splitNumber!},
    name: radarName,
    nameGap: '${indicatorNameGap!}',
    indicator: indicator,
    splitLine: splitLine,
    axisLine: axisLine,
    splitArea: splitArea,
    axisLabel: axisLabel,
    axisTick: axisTick,
    },
    legend: {
    show: ${isShowFlag?string!},
    left: '${legendLocation!}',
    textStyle: textStyle,
    itemWidth: ${itemWidth!},
    itemHeight: ${itemHeight!},
    itemGap: ${itemGap!},
    icon: '${itemIcon!}',
    orient: '${itemOrient!}',
    inactiveColor: '${itemInactiveColor!}',
    },
    series: seriesResult,
    });
    } else {
    self.$message.error('数据请求失败');
    }
    }).catch(function() {
    self.$message.error('数据请求异常');
    })
    return self.${instanceKey!}OptionData;
<#--    没有设置数据模型时-->
<#else>
    const name = ['预算分配（Allocated Budget）', '实际开销（Actual Spending）'];
    const dataResult = [];
    const xFakeResult = [[4300, 10000, 28000, 35000, 50000, 19000], [5000, 14000, 28000, 31000, 42000, 21000]];
    name.forEach((col, index) =>{
    dataResult.push({
    value: xFakeResult[index],
    name: col,
    });
    })
    seriesResult.push({
    name: '雷达图',
    type: 'radar',
    symbol:'${symbolIcon!}',
    symbolSize:'${symbolIconSize!}',
    data: dataResult,
    color: colorValue
    });
    self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    radar:{
    shape:'${radarShape!}',
    splitNumber:${splitNumber!},
    name:radarName,
    nameGap: '${indicatorNameGap!}',
    indicator:[
    { name: '销售', max: 6500 },
    { name: '管理', max: 16000 },
    { name: '信息技术', max: 30000 },
    { name: '客服', max: 38000 },
    { name: '研发', max: 52000 },
    { name: '市场', max: 25000 },
    ],
    splitLine:splitLine,
    axisLine:axisLine,
    splitArea:splitArea,
    axisLabel:axisLabel,
    axisTick:axisTick,
    },
    legend: {
    show: ${isShowFlag?string!},
    left: '${legendLocation!}',
    textStyle: textStyle,
    itemWidth: ${itemWidth!},
    itemHeight: ${itemHeight!},
    itemGap: ${itemGap!},
    icon: '${itemIcon!}',
    orient: '${itemOrient!}',
    inactiveColor: '${itemInactiveColor!}',
    },
    series: seriesResult,
    });
    return self.${instanceKey!}OptionData;
</#if>