<template>
    <div class="lcdp_axe_main">
    <div class="lcdp_axe jxd_ins_elBaseWebPage jxd_additional ${pageName} ${rootInstanceKey}">
        ${body!}
        <#if showFlowFileDialog?? && showFlowFileDialog>
            <el-dialog class="flowchart-dialog"
                   :visible="${instanceKey!}ShowFlowFileDialog"
                   :show-close="false"
                   :append-to-body="true"
                   :close-on-click-modal="false"
                   :close-on-press-escape="false">
                <flowfile
                        v-if="${instanceKey!}ShowFlowFileDialog"
                        class="workflow"
                        :businessKey="${instanceKey!}ShowPicProcessKey"
                        :show="${instanceKey!}ShowFlowFileDialog"
                        @close="${instanceKey!}ShowFlowFileDialog=false">
                </flowfile>
            </el-dialog>
        </#if>
        <#if showFlowFile?? && showFlowFile>
            <flowfile
                    v-if="${instanceKey!}ShowFlowFile"
                    class="workflow"
                    :businessKey="${instanceKey!}ShowPicProcessKey"
                    :show="${instanceKey!}ShowFlowFile"
                    @close="${instanceKey!}ShowFlowFile=false">
            </flowfile>
        </#if>
        <#if participantDialog?? && participantDialog>
            <participantDialog @close="${instanceKey!}ParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmParticipant" :selectionBackup='${instanceKey!}SelectionBackup' :tableData ='${instanceKey!}ParticipantData'  :participantDialogVisible='${instanceKey!}ParticipantDialogVisible'>
            </participantDialog>
        </#if>
        <#if consignorDialog?? && consignorDialog>
            <consignorDialog @close="${instanceKey!}ConsignorDialogVisible = false" @comfirm="${instanceKey!}ComfirmConsignor" :selectionBackup='${instanceKey!}SelectedConsignorBackup' :tableData ='${instanceKey!}ConsignorData'  :consignorDialogVisible='${instanceKey!}ConsignorDialogVisible'>
            </consignorDialog>
        </#if>
        <#if customFlowNode?? && customFlowNode>
            <customFlowNode @close="${instanceKey!}CustomFlowNodeVisible = false" :customFlowNodeVisible="${instanceKey!}CustomFlowNodeVisible">
            </customFlowNode>
        </#if>
        <#if customFlowNodeSingle?? && customFlowNodeSingle>
            <customFlowNodeSingle @close="${instanceKey!}CustomFlowNodeSingleVisible = false" :customFlowNodeVisible="${instanceKey!}CustomFlowNodeSingleVisible">
            </customFlowNodeSingle>
        </#if>
        <#if showSelectParticipant??>
            <#list showSelectParticipant as currentKey>
                <selectParticipant @close="${instanceKey!}${currentKey!}SelectParticipantShow = false" :selectParticipantShow="${instanceKey!}${currentKey!}SelectParticipantShow" @save="${instanceKey!}${currentKey!}FlowFormSubmitSave" :taskId="this.$route.query.taskId" :processDefinitionKey="this.$route.query.processDefinitionKey" :doneListIdentification="this.$route.query.doneListIdentification ? this.$route.query.doneListIdentification : '0'">
                </selectParticipant>
            </#list>
        </#if>
        <#if showSelectEntrust??>
            <#list showSelectEntrust as currentKey>
                <selectEntrust @close="${instanceKey!}${currentKey!}SelectEntrustShow = false" :selectEntrustShow="${instanceKey!}${currentKey!}SelectEntrustShow" @save="${instanceKey!}${currentKey!}TaskEntrustSave">
                </selectEntrust>
            </#list>
        </#if>
        <#if showSelectRejectNode??>
            <#list showSelectRejectNode as currentKey>
                <selectRejectNode @close="${instanceKey!}${currentKey!}SelectRejectNodeShow = false" :selectRejectNodeShow="${instanceKey!}${currentKey!}SelectRejectNodeShow" @save="${instanceKey!}${currentKey!}AnyNodeRejectSave" :taskId="this.$route.query.taskId" :doneListIdentification="this.$route.query.doneListIdentification ? this.$route.query.doneListIdentification : '0'">
                </selectRejectNode>
            </#list>
        </#if>
        ${slotCodes.default!}
        ${slot_title!}
    </div>
    </div>
</template>

<script>
    <#list importScripts! as imp>
        ${imp};
    </#list>
    /* ${directives.definitionsBegin} */
    /* ${directives.definitionsEnd} */
    export default {
        name: "${pageName!}",
        components: {
                <#list components as component>
                ${component},
                </#list>
        },
        data() {
            return {
                <#list datas as data>
                ${data},
                </#list>
                /* ${directives.dataBegin} */
                /* ${directives.dataEnd} */
            }
        },
        computed: {
            <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                ${key}(${computed.argBody!}){
                    const self = this;
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                ${key}:{
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            /* ${directives.computedBegin} */
            /* ${directives.computedEnd} */
        },
        watch: {
            <#list watches?keys as key>
            <#assign watch=watches[key]>
                <#if (key!?index_of('\'') > -1)>
                    ${key}:{
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                <#else>
                    ${key}(${watch.argBody!}){
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                </#if>
            </#list>
            /* ${directives.watchBegin} */
            /* ${directives.watchEnd} */
        },
        methods: {
            <#list methods?keys as key>
                <#assign method=methods[key]>
                ${key}(${method.argBody!}){
                    const self = this;
                    <#list method.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            /* ${directives.methodsBegin} */
            /* ${directives.methodsEnd} */
        },
        created() {
            const self = this;
            // ${directives.createdBeforeBegin}
            // ${directives.createdBeforeEnd}
            <#list createds! as created>
            ${created}
            </#list>
            // ${directives.createdAfterBegin}
            // ${directives.createdAfterEnd}
        },
        mounted() {
            const self = this;
            // ${directives.mountedBeforeBegin}
            // ${directives.mountedBeforeEnd}
            <#list mounteds! as mounted>
                ${mounted}
            </#list>
            <#if isOnload?? && isOnload>
                self.${rootInstanceKey!}Onload();
            </#if>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if polls?? && (polls?size>0)>
                    <#list polls as poll>
                        <#assign str = poll.eventName?cap_first/>
                        <#list methods?keys as key>
                            <#if key == rootInstanceKey + str>
                            self.${key}Destroy = setInterval(() => {
                            const self = this;
                                self.${key}();
                                },<#if poll.pollTime??>${poll.pollTime?c}</#if>);
                            </#if>
                        </#list>
                    </#list>
                </#if>
            </#if>
            // ${directives.mountedAfterBegin}
            // ${directives.mountedAfterEnd}
        },
        filters: {
            <#list filters?keys as key>
            <#assign filter=filters[key]>
            ${key}(${filter.argBody!}){
                <#list filter.bodies as body>
                ${body}
                </#list>
            },
            </#list>
        },
        destroyed() {
            const self = this;
            // ${directives.destroyedBeforeBegin}
            // ${directives.destroyedBeforeEnd}
            <#list destroyeds! as destroyed>
                ${destroyed}
            </#list>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if destroyPolls?? && (destroyPolls?size>0)>
                    <#list destroyPolls! as destroyPoll>
                        clearInterval(self.${destroyPoll});
                    </#list>
                </#if>
            </#if>
            // ${directives.destroyedAfterBegin}
            // ${directives.destroyedAfterEnd}
        },
        /* ${directives.optionsBegin} */
        /* ${directives.optionsEnd} */
}
</script>

<!-- ${directives.styleBeforeBegin} -->
<!-- ${directives.styleBeforeEnd} -->

<style>
    /*公共，用于固定*/
    .lcdp_axe_main{transform: scale(1);height: 100%;overflow: auto}
    /*公共，用于设置文字提示的最大宽度*/
    .el-tooltip__popper{
        max-width: 500px;
    }
    ${styles!}
    ${hyperlinksSpan}
</style>

<!-- ${directives.styleAfterBegin} -->
<!-- ${directives.styleAfterEnd} -->
