let legend = [];
const resultSeries = [];
const colorValue = ${topicColorStr!};
<#assign effectScatterValue = effectScatter />
<#assign labelShow = labelShow />
<#assign imgRelativePath = '${imgRelativePath!}' />
<#if imgRelativePath?? && imgRelativePath != "">
    let imgRelativePathS = require('${imgRelativePath!}');
<#else>
    let imgRelativePathS = '${imgRelativePath!}';
</#if>

const cityName =  '${currentProvinceName!}';
<#--标题-->
const echatrsTitle = {
textStyle: {
color: '${titleColor!}',
fontSize: '${titleFontSize!}',
fontFamily: '${fontFamily!}',
fontWeight: '${fontWeight!}',
},
text: '${titleText!}',
textVerticalAlign :'${titleVerticalAlign!}',
left: '${titleAlign!}',
top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
borderRadius: 4,
padding: [6, 5, 3, 5],
};
<#--提示信息字体设置-->
const tooltipTextStyle = {
color: '${toolColor!}',
fontSize: '${toolFontSize!}',
fontFamily: '${toolFontFamily!}',
fontWeight: '${toolFontWeight!}',
fontStyle: '${toolFontStyle!}',
lineHeight: '${toolLineHeight!}',
};
<#--图例字体设置-->
const legendTextStyle ={
color: '${legendColor!}',
fontSize: '${legendFontSize!}',
fontFamily: '${legendFontFamily!}',
fontWeight: '${legendFontWeight!}',
fontStyle: '${legendFontStyle!}',
};
<#--series系列字体设置-->
const seriesItemStyle ={
normal:{
color:'${markerColor!}',
areaColor: '${areaColor!}',
borderColor: '${areaBorderColor!}',
borderWidth: ${areaBorderWidth!},
},
emphasis:{
areaColor: '${areaEmphasisColor!}',
},
};
<#--series系列标签设置-->
const seriesLabel ={
normal:{
show:false,
},
emphasis:{
show:false,
textStyle:{
color:'#fff',
},
},
};
<#--地图-->
const geo = {
map:cityName,
show:true,
roam:false,
label:{
emphasis:{
show:false,
},
},
itemStyle:{
normal:{
areaColor: '#091632',
borderColor: '#1773c3',
shadowColor: '${shadowColor!}',
shadowBlur: '${shadowBlur!}',
},
},
};
<#--formatter标签-->
const formatterLabel ={
normal:{
formatter:'{b}',
position:'right',
<#if (labelShow ?? && labelShow) && (effectScatterValue?? && effectScatterValue)>
    show: false ,
<#else>
    show: true,
</#if>
color: '${labelColor!}',
fontSize: '${labelFontSize!}',
fontFamily: '${labelFontFamily!}',
fontWeight: '${labelFontWeight!}',
},
};
const formatterEmphasis ={
scale:true,
};
const formatterLabelS ={
normal:{
formatter:'{b}',
position:'right',
<#if (labelShow ?? && labelShow) && (effectScatterValue?? && effectScatterValue)>
    show: true ,
<#else>
    show: false,
</#if>
color: '${labelColor!}',
fontSize: '${labelFontSize!}',
fontFamily: '${labelFontFamily!}',
fontWeight: '${labelFontWeight!}',
},
};
<#if importName?? && importName != "">
    <#if queryAttr??>
        let ${importName!}Obj = {
        ${queryAttr}
        };
    <#--    若查询条件项为空，则清空option-->
        <#if (queryCheck?? && queryCheck != "")>
            if(${queryCheck}){
            return;
            }
        </#if>
    <#else>
        let ${importName!}Obj = {};
    </#if>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if (res.code === "0") {
<#--数据库数据数组-->
    let dataBaseArray =res.data;
<#--临时空对象 判断分组条件：图例-->
    let temporaryObject ={};
<#--按照图例进行分组之后的数据数组-->
    let groupedArray =[];
<#--for循环：根据相同的图例进行分组 格式 key：string value值：数组-->
    for(let i = 0; i < dataBaseArray.length; i++){
<#--临时数组 用来接数据库数据数组的每一条数据-->
    let temporaryArray = dataBaseArray[i];
<#--判断数据的图例是不是存在的 不存在走else 存在 走if-->
    if(!temporaryObject[temporaryArray.legend]){
<#--把对应的key值和value值放进分组数组-->
    groupedArray.push({
    legend:temporaryArray.legend,
    data: [temporaryArray],
    });
    temporaryObject[temporaryArray.legend] = temporaryArray ;
    }else{
<#--循环分组数组 -->
    for(let j = 0; j < groupedArray.length; j++){
<#--临时数组-->
    let tempArray = groupedArray[j];
    if(tempArray.legend == temporaryArray.legend){
    tempArray.data.push(temporaryArray);
    break;
    }
    }
    }
    }
<#--地图坐标系数据-->
    let geoMap =[];
<#--地图城市和对应的value数据-->
    let cityData =[];
<#--遍历分组数组 生成特殊格式的地图坐标系数据和地图城市数据-->
    groupedArray.forEach((item, index) => {
    legend.push(item.legend);
    let tempGeoArray =[];
    let tempCityArray =[];
    item.data.forEach((e) => {
    tempGeoArray[e.label] =[e.longitude,e.latitude];
    tempCityArray.push({name:e.label,value:e.value});
    });
    geoMap.push(tempGeoArray);
    cityData.push(tempCityArray);
    });
<#--最终的地图名称和地图坐标系的数据处理-->
    const lastData = function(dataValue,index){
    const res = [];
    for (let i = 0; i < dataValue.length; i++) {
    const geoCoords = geoMap[index][dataValue[i].name];
    if (geoCoords) {
    res.push({
    name: dataValue[i].name,
    value: geoCoords.concat(dataValue[i].value),
    });
    }
    }
    return res;
    };
    legend.forEach((e, index) => {
    resultSeries.push(...[
    {
    <#if effectScatterValue?? && effectScatterValue>
        name: '',
    <#else>
        name:legend[index],
    </#if>
    type: 'scatter',
    coordinateSystem :'geo',
    data: lastData(cityData[index],index),
    symbolSize:'${symbolSize!}',
    <#if imgRelativePath?? && imgRelativePath !="">
        symbol:`image://`+imgRelativePathS,
    <#else>
        symbol:'circle',
    </#if>
    label:formatterLabel,
    itemStyle:{
    normal:{
    color: colorValue[index],
    opacity:1,
    },
    },
    emphasis:formatterEmphasis,
    },
    {
    <#if effectScatterValue?? && effectScatterValue>
        name:legend[index],
    <#else>
        name: '',
    </#if>
    type: 'effectScatter',
    coordinateSystem :'geo',
    data: lastData(cityData[index],index),
    symbolSize(){
    <#if (effectScatter?? && effectScatter)>
        return ${symbolSize!};
    </#if>
    return 0;
    },
    showEffectOn: 'render',
    rippleEffect: {
    brushType: 'stroke',
    },
    hoverAnimation:true,
    label:formatterLabelS,
    itemStyle:{
    normal:{
    color: colorValue[index],
    shadowBlur:10,
    shadowColor: '#333',
    opacity:1,
    },
    },
    zlevel: 1,
    }
    ]);
    });
    self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: {
    trigger: 'item',
    show: ${toolShow?string!},
    backgroundColor: '${tooltipBgColor!}',
    textStyle:tooltipTextStyle,
    formatter: function(param) {
    let paramValue = param.value;
    let res = param.seriesName + '<br/>';
    if (paramValue) {
    return res +=param.name +' : '+param.value[2]+'</br>';
    }
    return '';
    },
    padding:['${toolPaddingTop!}', '${toolPaddingLeft!}'],
    extraCssText: 'box-shadow: ${toolShadow!}',
    },
    legend: {
    show: ${isShowFlag?string!},
    left: '${legendLocation!}',
    textStyle:legendTextStyle,
    itemWidth: ${itemWidth!},
    itemHeight: ${itemHeight!},
    itemGap: ${itemGap!},
    <#if imgRelativePath?? && imgRelativePath !="">
        icon:`image://`+imgRelativePathS,
    <#else>
        icon: '${itemIcon!}',
    </#if>
    orient: '${itemOrient!}',
    inactiveColor: '${itemInactiveColor!}',
    bottom:5,
    borderRadius: 2,
    data:legend ,
    },
    geo:geo,
    series:[
    {
    type: 'map',
    map:cityName,
    geoIndex:1,
    aspectScale:0.75,
    showLegendSymbol:true,
    label:seriesLabel,
    roam:false,
    itemStyle:seriesItemStyle,
    },
    ...resultSeries,
    ],
    });
    } else {
    self.$message.error('数据请求失败');
    }
    }).catch(function() {
    self.$message.error('数据请求异常');
    })
    return self.${instanceKey!}OptionData;
<#--    没有设置数据模型时-->
<#else>
    const seriesResult = [];
    legend = ['光伏', '电机'];
    const geoCoordMap = [
    {
    荆州: [112.239741, 30.335165],
    宜昌: [111.3, 30.7],
    义乌: [120.06, 29.32],
    丽水: [119.92, 28.45],
    洛阳: [112.44, 34.7],
    秦皇岛: [119.57, 39.95],
    株洲: [113.16, 27.83],
    石家庄: [114.48, 38.03],
    莱芜: [117.67, 36.19],
    常德: [111.69, 29.05],
    },{
    保定: [115.48, 38.85],
    湘潭: [112.91, 27.87],
    金华: [119.64, 29.12],
    岳阳: [113.09, 29.37],
    长沙: [113, 28.21],
    衢州: [118.88, 28.97],
    廊坊: [116.7, 39.53],
    菏泽: [115.480656, 35.23375],
    合肥: [117.27, 31.86],
    武汉: [114.31, 30.52],
    大庆: [125.03, 46.58],
    },];
    const data =[[
    { name: '荆州', value: 127 },
    { name: '宜昌', value: 130 },
    { name: '义乌', value: 132 },
    { name: '丽水', value: 133 },
    { name: '洛阳', value: 134 },
    { name: '秦皇岛', value: 136 },
    { name: '株洲', value: 143 },
    { name: '石家庄', value: 147 },
    { name: '莱芜', value: 148 },
    { name: '常德', value: 152 },
    ],[
    { name: '保定', value: 153 },
    { name: '湘潭', value: 154 },
    { name: '金华', value: 157 },
    { name: '岳阳', value: 169 },
    { name: '长沙', value: 175 },
    { name: '衢州', value: 177 },
    { name: '廊坊', value: 193 },
    { name: '菏泽', value: 194 },
    { name: '合肥', value: 229 },
    { name: '武汉', value: 273 },
    { name: '大庆', value: 279 },
    ]];
    const convertData = function(dataValue,index){
    const res = [];
    for (let i = 0; i < dataValue.length; i++) {
    const geoCoord = geoCoordMap[index][dataValue[i].name];
    if (geoCoord) {
    res.push({
    name: dataValue[i].name,
    value: geoCoord.concat(dataValue[i].value),
    });
    }
    }
    return res;
    };
    legend.forEach((e, index) => {
    seriesResult.push(...[
    {
    <#if effectScatterValue?? && effectScatterValue>
        name: '',
    <#else>
        name:legend[index],
    </#if>
    type: 'scatter',
    coordinateSystem :'geo',
    data: convertData(data[index],index),
    symbolSize:'${symbolSize!}',
    <#if imgRelativePath?? && imgRelativePath !="">
        symbol:`image://`+imgRelativePathS,
    <#else>
        symbol:'circle',
    </#if>
    label:formatterLabel,
    itemStyle:{
    normal:{
    color: colorValue[index],
    opacity:1,
    },
    },
    emphasis:formatterEmphasis,
    },
    {
    <#if effectScatterValue?? && effectScatterValue>
        name:legend[index],
    <#else>
        name: '',
    </#if>
    type: 'effectScatter',
    coordinateSystem :'geo',
    data: convertData(data[index],index),
    symbolSize(){
    <#if (effectScatter?? && effectScatter)>
        return ${symbolSize!};
    <#else>
        return 0;
    </#if>
    },
    showEffectOn: 'render',
    rippleEffect: {
    brushType: 'stroke',
    },
    hoverAnimation:true,
    label:formatterLabelS,
    itemStyle:{
    normal:{
    color: colorValue[index],
    shadowBlur:10,
    shadowColor: '#333',
    opacity:1,
    },
    },
    zlevel: 1,
    }
    ]);
    });
    self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: {
    trigger: 'item',
    show: ${toolShow?string!},
    backgroundColor: '${tooltipBgColor!}',
    textStyle:tooltipTextStyle,
    formatter: function(param) {
    let paramValue = param.value;
    let res = param.seriesName + '<br/>';
    if (paramValue) {
    return res +=param.name +' : '+param.value[2]+'</br>';
    }
    return '';
    },
    padding:['${toolPaddingTop!}', '${toolPaddingLeft!}'],
    extraCssText: 'box-shadow: ${toolShadow!}',
    },
    legend: {
    show: ${isShowFlag?string!},
    left: '${legendLocation!}',
    textStyle:legendTextStyle,
    itemWidth: ${itemWidth!},
    itemHeight: ${itemHeight!},
    itemGap: ${itemGap!},
    <#if imgRelativePath?? && imgRelativePath !="">
        icon:`image://`+imgRelativePathS,
    <#else>
        icon: '${itemIcon!}',
    </#if>
    orient: '${itemOrient!}',
    inactiveColor: '${itemInactiveColor!}',
    bottom:5,
    borderRadius: 2,
    data:legend ,
    },
    geo:geo,
    series:
    [{
    type: 'map',
    map:cityName,
    geoIndex:1,
    aspectScale:0.75,
    showLegendSymbol:true,
    label:seriesLabel,
    roam:false,
    itemStyle:seriesItemStyle,
    },
    ...seriesResult,
    ],
    });
    return self.${instanceKey!}OptionData;
</#if>