<#if tableInstanceKey?? && tableInstanceKey != "">
    let file = event.currentTarget.files[0];
    let rABS = false;
    const types = file.name.split(".")[1];
    const fileType = ["xlsx", "xlc", "xlm", "xls", "xlt"].some(
        item => item === types
    );
    if (!fileType) {
        self.$message.error('文件格式错误，请重新选择！');
        return;
    }
    let reader = new FileReader();
    FileReader.prototype.readAsBinaryString = function(f) {
        let binary = "";
        let rABS = false;
        let wb;
        let reader = new FileReader();
        reader.onload = function() {
            let bytes = new Uint8Array(reader.result);
            for(let i = 0; i < bytes.byteLength; i++) {
                binary += String.fromCharCode(bytes[i]);
            }
            if(rABS) {
                wb = XLSX.read(btoa(binary), {
                type: 'base64', cellDates: true
            });
            } else {
                wb = XLSX.read(binary, {
                type: 'binary' ,cellDates: true
            });
        }
        let previewData = XLSX.utils.sheet_to_json(wb.Sheets[wb.SheetNames[0]]);
        <#assign map=cols/>
        <#assign keys=map?keys/>
        let values = [
        <#list keys! as key>
            <#if (key_index != (keys?size-1))>
                "${map[key]}",
            <#else>
                "${map[key]}"
            </#if>
        </#list>
        ];
        let prop = [
        <#list keys! as key>
            <#if (key_index != (keys?size-1))>
                "${key}",
            <#else>
                "${key}"
            </#if>
        </#list>
        ];
        let valuesCopy = values.slice(0);
        let keys= Object.keys(previewData[0]);
        if (JSON.stringify(keys.sort()) != JSON.stringify(valuesCopy.sort())) {
            self.$message.error('导入模板错误，请重新选择！');
            return;
        }
        let newArr = [];
        previewData.forEach((item)=>{
            let obj = {};
            for (let j=0; j < values.length; j++) {
                obj[prop[j]]=item[values[j]];
            }
            newArr.push(obj);
        });
        self.${tableInstanceKey!}Data = newArr;
        <#if importName?? && importName != "">
            ${importName!}['${importMethod!}']({importList: JSON.stringify(self.${tableInstanceKey!}Data)}).then(res => {
            if (res) {
                self.$message.success("导入成功");
            if (callback && typeof callback === 'function'){
            callback();
            }
            } else {
                self.$message.error("导入失败");
            }
            }).catch(function() {
                self.$message.error('数据请求异常');
            })
        </#if>
    };
    reader.readAsArrayBuffer(f);
    };
    if(rABS) {
        reader.readAsArrayBuffer(file);
    } else {
        reader.readAsBinaryString(file);
    }
</#if>