/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StripShapeVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/elementui/element/StripShapeEcharts/el_stripShapeEcharts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer width = lcdpComponent.getWidth();
        Integer height = lcdpComponent.getHeight();
        ctx.addData(instanceKey + "Data: null");
        ctx.addData(instanceKey + "OptionData: []");
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Height: " + height);
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        Map maps = lcdpComponent.getProps();
        if (ToolUtil.isNotEmpty((Object)maps)) {
            this.params(params, maps);
            this.setModelValue(lcdpComponent, ctx, params);
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"template/elementui/element/StripShapeEcharts/el_stripShapeEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"template/elementui/element/StripShapeEcharts/el_stripShapeEcharts_watch.ftl", params));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"template/elementui/element/StripShapeEcharts/el_stripShapeEcharts_watch.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"template/elementui/element/StripShapeEcharts/el_stripShapeEcharts_Success.ftl", params));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }

    private void params(Map<String, Object> params, Map<String, Object> maps) {
        params.put("titleText", maps.get("title"));
        params.put("titleColor", ToolUtil.isNotEmpty((Object)maps.get("titleColor")) ? maps.get("titleColor") : "#000");
        params.put("titleFontSize", ToolUtil.isNotEmpty((Object)maps.get("titleFontSize")) ? maps.get("titleFontSize") : "18");
        params.put("fontFamily", maps.get("fontFamily"));
        params.put("fontWeight", maps.get("fontWeight"));
        params.put("titleAlign", maps.get("titleAlign"));
        params.put("titleVerticalAlign", maps.get("titleVerticalAlign"));
        params.put("titleLeft", maps.get("titleLeft"));
        params.put("titleTop", maps.get("titleTop"));
        params.put("titleBackgroundColor", ToolUtil.isNotEmpty((Object)maps.get("titleBackgroundColor")) ? maps.get("titleBackgroundColor") : "transparent");
        params.put("xAxisName", maps.get("xAxisName"));
        params.put("yAxisName", maps.get("yBarAxisName"));
        params.put("nameLocation", ToolUtil.isNotEmpty((Object)maps.get("nameLocation")) ? maps.get("nameLocation") : "end");
        params.put("xyColor", ToolUtil.isNotEmpty((Object)maps.get("xyColor")) ? maps.get("xyColor") : "#999999");
        params.put("xyFontSize", ToolUtil.isNotEmpty((Object)maps.get("xyFontSize")) ? maps.get("xyFontSize") : "12");
        params.put("xyFontFamily", maps.get("xyFontFamily"));
        params.put("xyFontWeight", maps.get("xyFontWeight"));
        params.put("xyFontStyle", maps.get("xyFontStyle"));
        params.put("lineColor", ToolUtil.isNotEmpty((Object)maps.get("lineColor")) ? maps.get("lineColor") : "#E1E1E1");
        params.put("lineWidth", ToolUtil.isNotEmpty((Object)maps.get("lineWidth")) ? maps.get("lineWidth") : "1");
        params.put("nameGap", Optional.ofNullable(maps.get("nameGap")).orElse(10));
        params.put("xSplitLineShow", Optional.ofNullable(maps.get("xSplitLineShow")).orElse(false));
        params.put("xSplitLineType", ToolUtil.isNotEmpty((Object)maps.get("xSplitLineType")) ? maps.get("xSplitLineType") : "solid");
        params.put("xSplitLineColor", Optional.ofNullable(maps.get("xSplitLineColor")).orElse("#dddddd"));
        params.put("barMin", maps.get("barMin"));
        params.put("barMax", maps.get("barMax"));
        params.put("gridLeft", ToolUtil.isNotEmpty((Object)maps.get("gridLeft")) ? maps.get("gridLeft") : "60");
        params.put("gridTop", ToolUtil.isNotEmpty((Object)maps.get("gridTop")) ? maps.get("gridTop") : "50");
        params.put("gridRight", ToolUtil.isNotEmpty((Object)maps.get("gridRight")) ? maps.get("gridRight") : "60");
        params.put("gridBottom", ToolUtil.isNotEmpty((Object)maps.get("gridBottom")) ? maps.get("gridBottom") : "45");
        params.put("containLabel", Optional.ofNullable(maps.get("containLabel")).orElse(false));
        params.put("tooltipBgColor", maps.get("tooltipBgColor"));
        params.put("toolColor", ToolUtil.isNotEmpty((Object)maps.get("toolColor")) ? maps.get("toolColor") : "#666");
        params.put("toolFontSize", ToolUtil.isNotEmpty((Object)maps.get("toolFontSize")) ? maps.get("toolFontSize") : "12");
        params.put("toolFontFamily", maps.get("toolFontFamily"));
        params.put("toolFontWeight", maps.get("toolFontWeight"));
        params.put("toolFontStyle", maps.get("toolFontStyle"));
        params.put("toolLineHeight", maps.get("toolLineHeight"));
        params.put("toolShow", Optional.ofNullable(maps.get("toolShow")).orElse(false));
        params.put("toolPaddingTop", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingTop")) ? maps.get("toolPaddingTop") : "10");
        params.put("toolPaddingLeft", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingLeft")) ? maps.get("toolPaddingLeft") : "10");
        params.put("toolShadow", maps.get("toolShadow"));
        params.put("xyAxisTickLength", maps.get("xyAxisTickLength"));
        params.put("xyAxisPointerType", maps.get("xyAxisPointerType"));
        params.put("xyAxisPointerColor", maps.get("xyAxisPointerColor"));
        params.put("isShowFlag", Optional.ofNullable(maps.get("isShowFlag")).orElse(false));
        params.put("legendLocation", ToolUtil.isNotEmpty((Object)maps.get("legendLocation")) ? maps.get("legendLocation") : "right");
        params.put("legendColor", ToolUtil.isNotEmpty((Object)maps.get("legendColor")) ? maps.get("legendColor") : "#999999");
        params.put("legendFontSize", ToolUtil.isNotEmpty((Object)maps.get("legendFontSize")) ? maps.get("legendFontSize") : "16");
        params.put("legendFontFamily", maps.get("legendFontFamily"));
        params.put("legendFontWeight", maps.get("legendFontWeight"));
        params.put("legendFontStyle", maps.get("legendFontStyle"));
        params.put("itemWidth", Optional.ofNullable(maps.get("itemWidth")).orElse(22));
        params.put("itemHeight", Optional.ofNullable(maps.get("itemHeight")).orElse(10));
        params.put("itemGap", Optional.ofNullable(maps.get("itemGap")).orElse(30));
        params.put("itemOrient", ToolUtil.isNotEmpty((Object)maps.get("itemOrient")) ? maps.get("itemOrient") : "horizontal");
        params.put("itemIcon", maps.get("itemIcon"));
        params.put("itemInactiveColor", maps.get("itemInactiveColor"));
        params.put("labelShow", Optional.ofNullable(maps.get("labelShow")).orElse(false));
        params.put("labelColor", ToolUtil.isNotEmpty((Object)maps.get("labelColor")) ? maps.get("labelColor") : "#E1E1E1");
        params.put("labelFontSize", ToolUtil.isNotEmpty((Object)maps.get("labelFontSize")) ? maps.get("labelFontSize") : "14");
        params.put("labelPosition", maps.get("labelPosition"));
        params.put("labelDistance", maps.get("labelDistance"));
        params.put("barUnit", maps.get("barUnit"));
        params.put("barWidth", Optional.ofNullable(maps.get("barWidth")).orElse(12));
        params.put("barGap", maps.get("barGap"));
        params.put("barSeriesName", maps.get("barSeriesName"));
        params.put("topicColorStr", maps.get("topicColor").toString());
        params.put("barRadius", Optional.ofNullable(maps.get("barRadius")).orElse(0));
    }

    private void setModelValue(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) throws LcdpException, IOException {
        DataSAnalysis datasAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis datasModelAnalysis = datasAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)datasModelAnalysis)) {
            DataSConditionAnalysis datasConditionAnalysis = datasModelAnalysis.getCondition();
            Map datasFieldAnalysisMap = datasModelAnalysis.getFields();
            String labelField = "";
            String valueField = "";
            String legendField = "";
            if (ToolUtil.isNotEmpty((Object)datasFieldAnalysisMap)) {
                for (Map.Entry fieldList : datasFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis datasFieldAnalysis : fieldAnalyses) {
                        String dataItemValue;
                        List dataItemPath = datasFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                        switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                            case "label": {
                                labelField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "value": {
                                valueField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "legend": {
                                legendField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField) && ToolUtil.isNotEmpty((Object)legendField)) {
                String sortConditionName;
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                String operationName = "hussarQuery";
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = datasModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
                }
                if (ToolUtil.isNotEmpty((Object)datasConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = datasConditionAnalysis.getQueryConditionModelList()))) {
                    params.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    params.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = datasConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = datasModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                    operationName = operationName + sortConditionName;
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                params.put("importName", apiFileName);
                params.put("importMethod", operationName);
                params.put("yAxisCols", labelField);
                params.put("seriesCols", valueField);
                params.put("legendCols", legendField);
            }
        }
    }
}

