/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentBindUtil;
import com.jxdinfo.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import java.util.HashMap;
import java.util.List;

public class ElTabsVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/elementui/element/tabs/el_tabs.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        ComponentBindUtil.renderReferenceData((LcdpComponent)lcdpComponent, (Ctx)ctx, (boolean)false);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        HashMap tabMap = new HashMap();
        tabMap.put("active", lcdpComponent.getProps().get("defaultActiveTab"));
        tabMap.put("stretch", lcdpComponent.getProps().get("stretch"));
        tabMap.put("id", lcdpComponent.getInstanceKey());
        List tabList = JSONArray.parseArray((String)lcdpComponent.getProps().get("tabList").toString(), HashMap.class);
        int index = 0;
        for (HashMap tab : tabList) {
            String routePath = "";
            if (ToolUtil.isNotEmpty(tab.get("outLink"))) {
                routePath = tab.get("outLink").toString();
                tab.put("outLink", routePath);
                tab.put("url", "");
                continue;
            }
            if (!ToolUtil.isNotEmpty(tab.get("url"))) continue;
            String id = ((HashMap)JSONObject.parseObject((String)tab.get("url").toString(), HashMap.class)).get("id").toString();
            routePath = this.fileMappingService.getFormatPath(id);
            String pageName = routePath.substring(routePath.lastIndexOf(47) + 1);
            tab.put("url", routePath);
            tab.put("pageName", "<" + pageName + index + "/>");
            ctx.addImports("import " + pageName.toLowerCase() + index + " from '@/views" + routePath + "'");
            ctx.addComponent(pageName.toLowerCase() + index);
            ++index;
        }
        String dataArrayStr = RenderUtil.renderTemplate((String)"template/elementui/element/tabs/tab_data.ftl", tabMap);
        ctx.addData(dataArrayStr);
        lcdpComponent.addRenderParam("tabs", (Object)tabList);
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) {
        ctx.addComputed("url", "return window.location.origin + '/#';");
    }
}

