const xResult = [];
const sResult = [];
const result = [];
const legend = [];
const resultSeries = [];
const echatrsTitle = {
    text: '${titleText!}',
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontFamily: '${fontFamily!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
};
const echatrsTooltip = {
    trigger: 'axis',
    backgroundColor: '${tooltipBgColor!}',
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontFamily: '${toolFontFamily!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
    },
};
const textStyle = {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontFamily: '${legendFontFamily!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
};
const nameTextStyle = {
    color: '${xColor!}',
    fontSize: '${xFontSize!}',
    fontFamily: '${xFontFamily!}',
    fontWeight: '${xFontWeight!}',
    fontStyle: '${xFontStyle!}',
};
const axisLine = {
    show: true,
    type: 'solid',
    lineStyle: {
        width: '${lineWidth!}',
        color: '${lineColor!}',
    },
};
const axisLabel = {
    show: true,
    color: '${xColor!}',
    fontSize: '${xFontSize!}',
    fontFamily: '${xFontFamily!}',
    fontWeight: '${xFontWeight!}',
    fontStyle: '${xFontStyle!}',
};
const yAxis = {
    type: 'value',
    name: '${yAxisName!}',
    nameLocation: '${nameLocation}',
    nameTextStyle: {
        color: '${xColor!}',
        fontSize: '${xFontSize!}',
        fontFamily: '${xFontFamily!}',
        fontWeight: '${xFontWeight!}',
        fontStyle: '${xFontStyle!}',
    },
    axisLine: {
        show: true,
        type: 'solid',
        lineStyle: {
            width: '${lineWidth!}',
            color: '${lineColor!}',
        },
    },
    axisLabel: {
        show: true,
        color: '${xColor!}',
        fontSize: '${xFontSize!}',
        fontFamily: '${xFontFamily!}',
        fontWeight: '${xFontWeight!}',
        fontStyle: '${xFontStyle!}',
    },
};
<#if importName?? && importName != "">
    <#if queryAttr??>
        let ${importName!}Obj = {
        ${queryAttr}
        };
    <#--    若查询条件项为空，则清空option-->
        <#if (queryCheck?? && queryCheck != "")>
            if(${queryCheck}){
            return;
            }
        </#if>
    <#else>
        let ${importName!}Obj = {};
    </#if>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if (res.code === "0") {
        res.data.forEach((item) => {
            result.push({"name": item.${xAxisCols!},"value": item.${seriesCols!}})
        });
        result.forEach((item,index) => {
            xResult.push(item.name.split(",").slice(1));
            sResult.push(item.value.split(","));
            legend.push(item.name.split(",").shift())
            resultSeries.push({
                <#if (smooth?? && smooth)>
                    smooth: true,
                </#if>
                symbol: '${symbolIcon!}',
                symbolSize: '${symbolSize!}',
                lineStyle: {
                    width: '${seriesLineWidth!}',
                },
                name: legend[index],
                data: sResult[index],
                type: 'line'
            });
        });
        self.${instanceKey!}OptionData.push({
            title: echatrsTitle,
            tooltip: echatrsTooltip,
            legend: {
            <#if (isShowFlag?? && isShowFlag)>
                show: true,
            </#if>
            left: '${legendLocation!}',
                textStyle: textStyle,
                data: legend
            },
            xAxis: {
                type: 'category',
                name: '${xAxisName!}',
                nameLocation: '${nameLocation!}',
                nameTextStyle: nameTextStyle,
                axisLine: axisLine,
                axisLabel: axisLabel,
                data: xResult[0]
            },
            yAxis: yAxis,
            series: resultSeries
        });
    } else {
        self.$message.error('数据请求失败');
    }
    }).catch(function() {
     self.$message.error('数据请求异常');
    })
    return self.${instanceKey!}OptionData;
<#--    没有设置数据模型时-->
<#else>
    const seriesResult = [];
    const name = ['订单总笔数', '钱包笔数', '借呗笔数'];
    const xFakeResult = [[100, 320, 150, 77, 84, 130, 76], [230, 440, 250, 240, 430, 210, 250], [305, 390, 330, 360, 320, 430, 300]];
    name.forEach((col, index) => {
        seriesResult.push({
            name: col,
            type: 'line',
            <#if (smooth?? && smooth)>
                smooth: true,
            </#if>
            symbol: '${symbolIcon!}',
            symbolSize: '${symbolSize!}',
            data: xFakeResult[index],
            lineStyle: {
                width: '${seriesLineWidth!}',
            },
        });
    });
    self.${instanceKey!}OptionData.push({
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    legend: {
        <#if (isShowFlag?? && isShowFlag)>
            show: true,
        </#if>
        left: '${legendLocation!}',
        textStyle: textStyle,
        data: ['订单总笔数', '钱包笔数', '借呗笔数'],
    },
    xAxis: {
        type: 'category',
        name: '${xAxisName!}',
        nameLocation: '${nameLocation!}',
        nameTextStyle: nameTextStyle,
        axisLine: axisLine,
        axisLabel: axisLabel,
         data: ['01-01', '01-02', '01-03', '01-04', '01-05', '01-06', '01-07'],
    },
    yAxis: yAxis,
    series: seriesResult,
});
    return self.${instanceKey!}OptionData;
</#if>