/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.Action;
import com.jxdinfo.speedcode.codegenerator.core.action.visitor.ActionVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.ImportExcelDataAction")
public class ImportExcelData
implements ActionVisitor {
    private FileMappingService fileMappingService;

    @Autowired
    public ImportExcelData(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        String dataModelId;
        HashMap<String, Object> map = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/elementui/event/ImportExcelData.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        map.put("trigger", triggerName);
        Map params = action.getParamValues();
        String dataTableId = "";
        DataSAnalysis dataSAnalysis = null;
        DataSModelAnalysis dataSModelAnalysis = null;
        String apiFileName = "";
        String operationName = "tableSave";
        String apiFilePath = "";
        HashMap<String, String> cols = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)params)) {
            dataTableId = String.valueOf(((Map)params.get("importExcelData")).get("instanceKey"));
        }
        if (ToolUtil.isNotEmpty((Object)dataTableId)) {
            JSONArray optCols;
            dataSAnalysis = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((LcdpComponent)ctx.getComponentMap().get(dataTableId)).getDatas()), DataSAnalysis.class);
            LcdpComponent tableComponent = (LcdpComponent)ctx.getComponentMap().get(dataTableId);
            if (ToolUtil.isNotEmpty((Object)tableComponent) && ToolUtil.isNotEmpty((Object)tableComponent.getProps()) && ToolUtil.isNotEmpty(tableComponent.getProps().get("opt_cols")) && ToolUtil.isNotEmpty((Object)(optCols = (JSONArray)tableComponent.getProps().get("opt_cols")))) {
                this.getCols(optCols, cols);
            }
        }
        if (ToolUtil.isNotEmpty(dataSAnalysis)) {
            dataSModelAnalysis = dataSAnalysis.getDatamodel();
        }
        map.put("tableInstanceKey", dataTableId);
        map.put("cols", cols);
        renderCore.registerParam(map);
        RenderResult renderResult = renderCore.render();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis) && ToolUtil.isNotEmpty((Object)(dataModelId = dataSModelAnalysis.getDataModelId()))) {
            apiFileName = this.fileMappingService.getFileName(dataModelId);
            apiFilePath = this.fileMappingService.getImportPath(dataModelId).toLowerCase();
        }
        map.put("importName", apiFileName);
        map.put("importMethod", operationName);
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
            ctx.addMethod(dataTableId + "importF", RenderUtil.renderTemplate((String)"/template/elementui/event/ImportExcelDataMethod.ftl", map));
            ctx.addImports("import XLSX from 'xlsx'");
        }
        if (ToolUtil.isNotEmpty((Object)apiFileName) && ToolUtil.isNotEmpty((Object)apiFilePath)) {
            ctx.addImports("import * as " + apiFileName + " from \"" + apiFilePath + "\"");
        }
    }

    private void getCols(JSONArray optCols, Map<String, String> cols) {
        for (Object optCol : optCols) {
            if (!ToolUtil.isNotEmpty(optCol)) continue;
            JSONObject col = (JSONObject)optCol;
            if (ToolUtil.isNotEmpty((Object)col.get((Object)"children"))) {
                JSONArray childrenCols = (JSONArray)col.get((Object)"children");
                this.getCols(childrenCols, cols);
                continue;
            }
            if (!ToolUtil.isNotEmpty((Object)col.get((Object)"field")) || !ToolUtil.isNotEmpty((Object)col.get((Object)"title"))) continue;
            cols.put((String)col.get((Object)"field"), (String)col.get((Object)"title"));
        }
    }
}

