<template>
   <div class="lcdp_axe jxd_ins_elBaseWebPage ${pageName} ${rootInstanceKey}">
        ${body!}
        <#if showFlowFile?? && showFlowFile>
            <flowfile
                    v-if="${instanceKey!}ShowFlowFile"
                    class="workflow"
                    :businessKey="${instanceKey!}ShowPicProcessKey"
                    :show="${instanceKey!}ShowFlowFile"
                    @close="${instanceKey!}ShowFlowFile=false"/>
        </#if>
       <#if participantDialog?? && participantDialog>
            <participantDialog @close="${instanceKey!}ParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmParticipant" :selectionBackup='${instanceKey!}SelectionBackup' :tableData ='${instanceKey!}ParticipantData'  :participantDialogVisible='${instanceKey!}ParticipantDialogVisible'>
            </participantDialog>
       </#if>
       <#if consignorDialog?? && consignorDialog>
            <consignorDialog @close="${instanceKey!}ConsignorDialogVisible = false" @comfirm="${instanceKey!}ComfirmConsignor" :selectionBackup='${instanceKey!}SelectedConsignorBackup' :tableData ='${instanceKey!}ConsignorData'  :consignorDialogVisible='${instanceKey!}ConsignorDialogVisible'>
            </consignorDialog>
       </#if>
        ${slotCodes.default!}
        ${slot_title!}
    </div>
</template>

<script>
    <#list importScripts! as imp>
        ${imp};
    </#list>
    export default {
        name: "${pageName!}",
        components: {
                <#list components as component>
                ${component},
                </#list>
        },
        data() {
            return {
                <#list datas as data>
                ${data},
                </#list>
            }
        },
        computed: {
            <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                ${key}(${computed.argBody!}){
                    const self = this;
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                ${key}:{
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
        },
        watch: {
            <#list watches?keys as key>
            <#assign watch=watches[key]>
                <#if (key!?index_of('\'') > -1)>
                    ${key}:{
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                <#else>
                    ${key}(${watch.argBody!}){
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                </#if>
            </#list>
        },
        methods: {
            <#list methods?keys as key>
                <#assign method=methods[key]>
                ${key}(${method.argBody!}){
                    const self = this;
                    <#list method.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
        },
        mounted() {
            <#list mounteds! as mounted>
                ${mounted}
            </#list>
            <#if isOnload?? && isOnload>
                this.${rootInstanceKey!}Onload();
            </#if>
        },
        filters: {
            <#list filters?keys as key>
            <#assign filter=filters[key]>
            ${key}(${filter.argBody!}){
                <#list filter.bodies as body>
                ${body}
                </#list>
            },
            </#list>
        }
}
</script>

<style>
    /*公共，用于固定*/
    .lcdp_axe_main{transform: scale(1);height: 100%}
    ${styles!}
    ${hyperlinksSpan}
</style>