/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.constant.TriggerType;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.defaultvalue.DefaultValueAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.formcheck.ELFormCheckAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.formcheck.ELFormCheckItemAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigItemInfo;
import com.jxdinfo.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.render.RenderCore;
import com.jxdinfo.speedcode.common.render.RenderResult;
import com.jxdinfo.speedcode.common.runner.formcheck.FormCheckInfo;
import com.jxdinfo.speedcode.common.runner.formcheck.FormCheckObject;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.DefaultValueUtil;
import com.jxdinfo.speedcode.common.utils.ReplaceDataUtil;
import com.jxdinfo.speedcode.file.filemapping.service.FileMappingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FormVisitor
implements VoidVisitor {
    private final FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List triggers = lcdpComponent.getTriggers();
        lcdpComponent.registerTemplatePath("/template/elementui/element/form/form.ftl");
        lcdpComponent.addRenderParam("id", (Object)lcdpComponent.getInstanceKey());
        lcdpComponent.addRenderParam("triggers", (Object)triggers);
        this.renderMethod(lcdpComponent, ctx);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderFormData(lcdpComponent, ctx);
    }

    private void renderLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"dataLoadConfig");
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty((Object)showConfigAnalyses) && ToolUtil.isNotEmpty((Object)((ShowConfigAnalysis)showConfigAnalyses.get(0)).getDataModelId())) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, (List)showConfigAnalyses);
            showConfigItemInfos.forEach(itemInfo -> {
                if (ToolUtil.isNotEmpty((Object)itemInfo.getQueryObjectAttr())) {
                    itemInfo.setQueryObjectAttrList((List)CollUtil.toList((Object[])itemInfo.getQueryObjectAttr().split(",")));
                }
            });
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos.get(0));
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            replaceDataMap.put("importName", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getImportName());
            replaceDataMap.put("queryObjectAttrList", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getQueryObjectAttrList());
            replaceDataMap.put("importMethod", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getImportMethod());
            replaceDataMap.put("mappingMap", ((ShowConfigItemInfo)showConfigItemInfos.get(0)).getMappingRelates());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            replaceDataMap.put("insValue", valueVisitor.getValue(null));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "DataLoad", RenderUtil.renderTemplate((String)"template/elementui/element/form/elForm_dataLoad.ftl", replaceDataMap));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "DataLoad()");
        }
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("labelWidth"))) {
            lcdpComponent.addAttr("labelWidth", lcdpComponent.getProps().get("labelWidth").toString());
        }
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"showConfigs");
        this.renderFormQuery(lcdpComponent, ctx, showConfigAnalyses);
        this.renderReplaceData(lcdpComponent, ctx, showConfigAnalyses);
        this.renderLoad(lcdpComponent, ctx);
        this.renderCheckRule(lcdpComponent, ctx);
    }

    private void renderCheckRule(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List elFormCheckAnalyses;
        Object formCheckInfo = lcdpComponent.getProps().get("formCheck");
        if (ToolUtil.isNotEmpty(formCheckInfo) && (elFormCheckAnalyses = (List)JSONObject.parseObject((String)JSON.toJSONString(formCheckInfo), (TypeReference)new TypeReference<List<ELFormCheckAnalysis>>(){}, (Feature[])new Feature[0])).size() > 0) {
            Map formCheckMap = FormCheckInfo.formCheckMap;
            ArrayList<JSONObject> checkFunctions = new ArrayList<JSONObject>();
            for (ELFormCheckAnalysis elFormCheckAnalysis : elFormCheckAnalyses) {
                HashMap<String, Object> ruleMap = new HashMap<String, Object>();
                String methodName = lcdpComponent.getInstanceKey() + StringUtils.capitalize((String)elFormCheckAnalysis.getId());
                ArrayList<JSONObject> formCheckObjects = new ArrayList<JSONObject>();
                for (ELFormCheckItemAnalysis elFormCheckItemAnalysis : elFormCheckAnalysis.getCheckTypes()) {
                    FormCheckObject formCheckObject = (FormCheckObject)formCheckMap.get(elFormCheckItemAnalysis.getCheckType());
                    if (!ToolUtil.isNotEmpty((Object)formCheckObject)) continue;
                    JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)formCheckObject));
                    if (ToolUtil.isNotEmpty((Object)elFormCheckItemAnalysis.getErrorMsg())) {
                        jsonObject.put("errorMsg", (Object)elFormCheckItemAnalysis.getErrorMsg());
                    } else {
                        jsonObject.put("errorMsg", (Object)"");
                    }
                    jsonObject.put("customValue", (Object)elFormCheckItemAnalysis.getCheckValue());
                    formCheckObjects.add(jsonObject);
                }
                ruleMap.put("checkList", formCheckObjects);
                ruleMap.put("field", elFormCheckAnalysis.getCheckFormCol());
                RenderCore renderCore = new RenderCore();
                renderCore.registerParam(ruleMap);
                renderCore.registerTemplatePath("template/elementui/element/form/form_checkMethod.ftl");
                RenderResult renderResult = renderCore.render();
                if (!renderResult.isStatus()) continue;
                ArrayList<String> args = new ArrayList<String>();
                args.add("value");
                ctx.addMethod(methodName, args, renderResult.getRenderString());
                JSONObject singleFunc = new JSONObject();
                singleFunc.put("field", (Object)elFormCheckAnalysis.getCheckFormCol());
                singleFunc.put("methodName", (Object)methodName);
                checkFunctions.add(singleFunc);
            }
            HashMap<String, Object> resultMethod = new HashMap<String, Object>();
            resultMethod.put("checkArray", checkFunctions);
            resultMethod.put("formIns", lcdpComponent.getInstanceKey());
            RenderCore renderCore = new RenderCore();
            renderCore.registerParam(resultMethod);
            renderCore.registerTemplatePath("template/elementui/element/form/form_checkResultHandler.ftl");
            RenderResult renderResult = renderCore.render();
            if (renderResult.isStatus()) {
                ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._FORM_VERIFY, renderResult.getRenderString());
            }
        }
    }

    private void renderFormQuery(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        String formDataModelID;
        DataSModelAnalysis formDataModel;
        HashMap<String, Object> map = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/elementui/element/form/form_load.ftl");
        String apiFilePath = "";
        String operationName = "formQuery";
        String apiFileName = "";
        String dataModelPrimary = "businessId";
        DataSAnalysis formDataS = (DataSAnalysis)JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        if (ToolUtil.isNotEmpty((Object)formDataS) && ToolUtil.isNotEmpty((Object)(formDataModel = formDataS.getDatamodel())) && ToolUtil.isNotEmpty((Object)(formDataModelID = formDataModel.getDataModelId()))) {
            apiFilePath = this.fileMappingService.getImportPath(formDataModelID).toLowerCase();
            apiFileName = this.fileMappingService.getFileName(formDataModelID);
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            String importTemplate = "import * as ${name} from \"${apiFilePath}\"";
            ctx.addImports(importTemplate.replace("${name}", apiFileName).replace("${apiFilePath}", apiFilePath));
        }
        map.put("importName", apiFileName);
        map.put("importMethod", operationName);
        map.put("insForm", lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType());
        map.put("instanceKey", lcdpComponent.getInstanceKey());
        map.put("dataModelPrimary", dataModelPrimary);
        if (lcdpComponent.haveTriggerByTriggerName(TriggerType._FORM_LOADED.getType())) {
            map.put("isLoadedEvent", true);
        }
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.size() > 0 && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getDataModelId()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getField()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getRelateField())) {
            map.put("isShowConfig", true);
        }
        renderCore.registerParam(map);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "FormLoad", renderResult.getRenderString());
        }
    }

    private void renderFormData(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        List tableOptColsAnalyses;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formData", lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType());
        ArrayList<String> fields = new ArrayList<String>();
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("component_cols");
        if (ToolUtil.isNotEmpty((Object)optColsJSONArray) && ToolUtil.isNotEmpty((Object)(tableOptColsAnalyses = JSONObject.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class)))) {
            for (TableOptColsAnalysis col : tableOptColsAnalyses) {
                if (!ToolUtil.isNotEmpty((Object)col.getField())) continue;
                fields.add(col.getField() + " :" + this.getDefaultValue(col));
            }
        }
        params.put("relateInsFields", fields);
        ctx.addData(RenderUtil.renderTemplate((String)"/template/elementui/element/form/form_data.ftl", params));
    }

    private String getDefaultValue(TableOptColsAnalysis col) {
        String defaultValue = "''";
        if (ToolUtil.isNotEmpty((Object)col)) {
            DefaultValueAnalysis defaultValueAnalysis = col.getDefaultValue();
            defaultValue = DefaultValueUtil.renderDefaultValue((DefaultValueAnalysis)defaultValueAnalysis, (String)col.getDataType());
        }
        return defaultValue;
    }

    private void renderReplaceData(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getDataModelId()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getField()) && ToolUtil.isNotEmpty((Object)showConfigAnalyses.get(0).getRelateField())) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, showConfigAnalyses);
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos);
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            String formValue = valueVisitor.getValue(null);
            replaceDataMap.put("formData", formValue);
            for (ShowConfigItemInfo showConfigItemInfo : showConfigItemInfos) {
                if (!ToolUtil.isNotEmpty((Object)showConfigItemInfo.getTableFieldWhere())) continue;
                HashMap<String, String> replaceWatchData = new HashMap<String, String>();
                replaceWatchData.put("formIns", lcdpComponent.getInstanceKey());
                String methodName = "\"" + formValue.replace(CodePrefix._THIS.getType(), "") + CodeSuffix._POINT.getType() + showConfigItemInfo.getTableFieldWhere() + "\"";
                ctx.addWatch(methodName, RenderUtil.renderTemplate((String)"/template/elementui/element/form/form_watchReplace.ftl", replaceWatchData));
            }
            ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._REPLACE_DATA.getType(), RenderUtil.renderTemplate((String)"/template/elementui/element/form/form_replaceDataMethod.ftl", replaceDataMap));
        }
    }
}

