<#--定义宏递归生成表头-->
<#macro colTree colList>
    <#list colList as item>
    <#--是否为多级表头-->
        <#if item.isParent??>
        <el-table-column label="${item.title!}" header-align="${item.align!}">
            <@colTree colList=item.children></@colTree>
        </el-table-column>
        <#elseif item.rowSummary?? && item.rowSummary>
            <el-table-column label="${item.title!}"
                    prop="${item.field!}"
                    <#if (item.sort?? && item.sort!)>
                        sortable
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                       <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                        width="${item.colWidth.number!}"
                       </#if>
                    </#if>
                     align="${item.bodyAlign!}"
                     header-align="${item.align!}">
                <#if item.rowCalculate??>
                <template slot-scope="scope">
                    {{$numeral(${item.rowCalculate.formulaReplace}).format('${item.rowCalculate.format}')}}
                </template>
                </#if>
            </el-table-column>
        <#else>
            <el-table-column
                    prop="${item.field!}"
                    label="${item.title!}"
                    <#if (item.sort?? && item.sort!)>
                        sortable
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                        <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                        width="${item.colWidth.number!}"
                        </#if>
                    </#if>
                    align="${item.bodyAlign!}"
                    header-align="${item.align!}" :show-overflow-tooltip=true>
                <#if item.field == "">
                    <template>
                        <#if item.hyperlinks??>
                            <span @click="${instanceKey!}${item.field!}CLICK"></span>
                        <#else>
                        </#if>
                    </template>
                <#else>
                    <template slot-scope="scope">
                        <#if item.hyperlinks??>
                            <span class="jxd_hyperlinks_span" @click="${instanceKey!}${item.field!}CLICK(scope.row)">
                            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                            {{$moment(scope.row.${item.field!}.format).format('${item.selectType.dateFmtSelect!}')}}
                            <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                {{(scope.row.${item.field!} !== '') ? $moment(scope.row.${item.field!}).format('${item.selectType.dateFmtSelect!}') : '--'}}
                            <#else>
                                {{scope.row.${item.field!}}}
                            </#if>
                            </span>
                        <#elseif item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                            {{(scope.row.${item.field!} !== '') ? $moment(scope.row.${item.field!}).format('${item.selectType.dateFmtSelect!}') : '--'}}
                        <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                            {{$numeral(scope.row.${item.field!}).format('${item.selectType.numberFmtSelect!}')}}
                        <#else>
                            {{scope.row.${item.field!}}}
                        </#if>
                    </template>
                </#if>

            </el-table-column>
        </#if>
    </#list>
</#macro>
<div>
    <el-table
            <#--列表loading-->
            v-loading="${instanceKey!}TableLoading"
            <#--隔行变色-->
<#--            <#if stripe?? && stripe>-->
<#--                :stripe="${instanceKey!}Stripe"-->
<#--            </#if>-->
            <#--列表边框-->
            <#if borderY?? && borderY>
                :border="${instanceKey!}BorderY"
            </#if>
            <#--表格高度（分页）-->
            <#if isPagination?? && isPagination>
                :height="'calc(100% - 53px)'"
            <#else >
                :height="'100%'"
            </#if>
            <#--列表合计-->
            <#if columnSummary?? && columnSummary>
                :summary-method="${instanceKey!}ColumnSummaryEvent"
                show-summary
            </#if>
            <#--选择项变化-->
            @selection-change="${instanceKey!}SelectRow"
    >
        <#--列表选择框-->
        <#if showSelection?? && showSelection>
            <el-table-column type="selection" :width="50" align="center">
            </el-table-column>
        </#if>
        <#--列表序号列-->
        <#if showIndex?? && showIndex>
            <el-table-column type="index" label="序号" :width="<#if indexWidth??>${indexWidth.localValue!}<#else>60</#if>" align="center">
            </el-table-column>
        </#if>
        <#--列表列-->
        <@colTree colList=tableShowFields!></@colTree>
        <#--操作列-->
        <#if needOperation?? && needOperation>
            <el-table-column fixed="right"
                 align="${item.bodyAlign!}"
                 header-align="${item.headerAlign!}"
                 :width="160"
                 label="操作">
                <template>
                    <el-button size="mini">编辑</el-button>
                    <el-button size="mini" type="danger">删除</el-button>
                </template>
            </el-table-column>
        </#if>
        <#--合计行-->
        <#if rowSummary?? && rowSummary>
            <el-table-column align="${rowCalculate.align!}" label="合计">
                <template slot-scope="scope">
                    <span>{{ ${instanceKey!}RowSummaryEvent(scope.row) }} ${rowCalculate.unit!}</span>
                </template>
            </el-table-column>
        </#if>
    </el-table>
    <#--分页组件-->
    <#if isPagination?? && isPagination>
        <div class="page">
            <el-pagination
                background
<#--                style="height: 8%!important;"-->
                @size-change="${instanceKey!}HandleSizeChange"
                @current-change="${instanceKey!}HandleCurrentChange"
                <#if (currentPage??)>
                    :current-page.sync="${instanceKey!}CurrentPage"
                </#if>
                :page-size="${instanceKey!}ListQuery.size"
                <#if (pageCount??)>
                    :page-count="${instanceKey!}PageCount"
                </#if>
                <#if (layout??)>
                    :layout="${instanceKey!}Layout"
                </#if>
                :total="${instanceKey!}TableTotal">
            </el-pagination>
        </div>
    </#if>
</div>