<#--定义列递归宏-->
<#macro editTree list>
    <#list list! as item>
        <#if (item.isParent?? && item.isParent!)>
            <vxe-table-column align="${item.bodyAlign!}"
                              header-align="${item.align!}"
                    <#--                                      field="${item.prop!}"-->
                              title="${item.label!}"
                              width="${item.width!}"
                    <#--格式化事件-->
                    <#--                              <#list formatDataMap! as formatItem>-->
                    <#--                                  <#if formatItem?contains(item.prop)>-->
                    <#--                                        :formatter="${instanceKey!}FormatEvent"-->
                    <#--                                        <#break>-->
                    <#--                                  </#if>-->
                    <#--                              </#list>-->
                    <#--                            <#if (item.sort?? && item.sort)>-->
                    <#--                                sortable-->
                    <#--                            </#if>-->
                    <#--可编辑列-->
                    <#if item.colEditComponent! != ''>
                        :edit-render="{
                                immediate: true,
                                <#--输入框-->
                                <#if item.colEditComponent! == 'input'>
                                name: 'input',
                                attrs: {type: 'text'},
                                <#--数字框-->
                                <#elseif item.colEditComponent! == 'number'>
                                name: '$input',
                                props: {type: 'number'},
                                <#--日期-->
                                <#elseif item.colEditComponent! == 'date'>
                                name: '$input',
                                props:{type:'${formatDataMap[item_index]!}'},
<#--                                props: {type: 'datetime'},-->
                                <#--下拉框-->
                                <#elseif item.colEditComponent! == 'select'>
                                name: '$select',
                                props: {type: 'select'},
                                options: ${instanceKey!}${item.prop!?cap_first}Options,
                                <#else >
                                </#if>
                                events: {
                                <#--合计行触发事件-->
                                <#if columnSummary?? && columnSummary>
                                input: ${instanceKey!}UpdateFooterEvent,
                                </#if>
                                <#--数据展示替换-->
                                <#if item.showConfig?? && item.showConfig>
                                change: ${instanceKey!}ReplaceData,
                                </#if>
                                }
                              }"
                    </#if>
            >
                <@editTree list = item.children></@editTree>
            </vxe-table-column>
        <#else>
            <#if (item.colEditComponent! == 'control')>
            <#--操作列-->
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  title="${item.title!}"
                                  width="${item.width!}"
                        <#--                                  <#if (item.sort?? && item.sort)>-->
                        <#--                                    sortable-->
                        <#--                                  </#if>-->
                >
                    <template v-slot="{ row }">
                        <template v-if="$refs.${instanceKey!}TableRef.isActiveByRow(row)">
                            <vxe-button @click="${instanceKey!}SaveRowEvent(row)">确定</vxe-button>
                            <vxe-button @click="${instanceKey!}CancelRowEvent(row)">取消</vxe-button>
                        </template>
                        <template v-else>
                            <vxe-button @click="${instanceKey!}EditRowEvent(row)">编辑</vxe-button>
                            <vxe-button @click="${instanceKey!}RemoveEvent(row)">删除</vxe-button>
                        </template>
                    </template>
                </vxe-table-column>
            <#elseif item.rowSummary?? && item.rowSummary>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  title="${item.label!}"
                                  width="${item.width!}"
                        <#--格式化事件-->
                        <#--                              <#list formatDataMap! as formatItem>-->
                        <#--                                  <#if formatItem?contains(item.prop)>-->
                        <#--                                        :formatter="${instanceKey!}FormatEvent"-->
                        <#--                                        <#break>-->
                        <#--                                  </#if>-->
                        <#--                              </#list>-->
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        >
                <#if item.rowCalculate??>
                <template v-slot="{ row }">
                    <span class="vxe-cell--label">{{$numeral(${item.rowCalculate.editFormulaReplace!}).format('${item.rowCalculate.format!}')}}</span>
                </template>
                </#if>
                </vxe-table-column>
            <#else>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  title="${item.label!}"
                                  width="${item.width!}"
                        <#--格式化事件-->
                        <#--                              <#list formatDataMap! as formatItem>-->
                        <#--                                  <#if formatItem?contains(item.prop)>-->
                        <#--                                        :formatter="${instanceKey!}FormatEvent"-->
                        <#--                                        <#break>-->
                        <#--                                  </#if>-->
                        <#--                              </#list>-->
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#--可编辑列-->
                        <#if item.colEditComponent! != ''>
                            :edit-render="{
                                immediate: true,
                                <#--输入框-->
                                <#if item.colEditComponent! == 'input'>
                                name: 'input',
                                attrs: {type: 'text'},
                                <#--数字框-->
                                <#elseif item.colEditComponent! == 'number'>
                                name: '$input',
                                props: {type: 'number'},
                                <#--日期-->
                                <#elseif item.colEditComponent! == 'date'>
                                name: '$input',
                                props:{type:'${formatDataMap[item_index]!}'},
<#--                                props: {type: 'datetime'},-->
                                <#--下拉框-->
                                <#elseif item.colEditComponent! == 'select'>
                                name: '$select',
                                props: {type: 'select'},
                                options: ${instanceKey!}${item.prop!?cap_first}Options,
                                <#else >
                                </#if>
                                events: {
                                <#--合计行触发事件-->
                                <#if columnSummary?? && columnSummary>
                                input: ${instanceKey!}UpdateFooterEvent,
                                </#if>
                                <#--数据展示替换-->
                                <#if item.showConfig?? && item.showConfig>
                                change: ${instanceKey!}ReplaceData,
                                </#if>
                                }
                              }"
                        </#if>>
<#--                    <#if item.colEditComponent! != '' && item.colEditComponent! == 'date'>-->
<#--                        <#if (formatDataMap[item_index]?? && formatDataMap[item_index] == 'datetime')>-->
<#--                            <template v-slot="{ row }">-->
<#--                                {{(row.${item.prop!} !== '') ? $moment(row.${item.prop!}).format('YYYY-MM-DD HH:mm:ss') : '--'}}-->
<#--                            </template>-->
<#--                        </#if>-->
<#--                    <#elseif item.colEditComponent! != '' && item.colEditComponent! == 'number'>-->
<#--                        <#if (formatDataMap[item_index]??)>-->
<#--                            <template v-slot="{ row }">-->
<#--                                {{$numeral(row.${item.prop!}).format('${formatDataMap[item_index]!}')}}-->
<#--                            </template>-->
<#--                        </#if>-->
<#--                    </#if>-->
                    <#if formatMap?? && formatMap[item_index]??>
                    <#if formatMap[item_index].type! == 'date'>
                    <template v-slot="{ row }">
                        {{(row.${item.prop!} !== '') ? $moment(row.${item.prop!}).format('${formatMap[item_index].format!}') : '--'}}
                    </template>
                    <#elseif formatMap[item_index].type! == 'number'>
                    <template v-slot="{ row }">
                        {{$numeral(row.${item.prop!}).format('${formatMap[item_index].format!}')}}
                    </template>
                    <#else>
                    </#if>
                    </#if>
                </vxe-table-column>
            </#if>
        </#if>

    </#list>
</#macro>
<div>
    <vxe-table
        <#--列表loading-->
        :loading="${instanceKey!}TableLoading"
        <#--隔行变色-->
        <#if stripe?? && stripe>
            :stripe="${instanceKey!}Stripe"
        </#if>
        highlight-hover-row
        <#--列表边框-->
        <#if borderStyle??>
            :border="${instanceKey!}BorderStyle"
        </#if>
        <#--表格高度（分页）-->
        <#if isPagination?? && isPagination>
            :height="'calc(100% - 48px)'"
        <#else >:height="'100%'"
        </#if>
        ref="${instanceKey!}TableRef"
        <#--单击触发可编辑-->
        :edit-config="{trigger: 'click', mode: 'cell'}"
        <#--列合计方法-->
        <#if columnSummary?? && columnSummary>
            show-footer
            :footer-method="${instanceKey!}ColumnSummaryEvent"
        </#if>

    >
        <#--列表选择框-->
        <#if showSelection?? && showSelection>
            <vxe-table-column align="center" type="checkbox" :width="50"></vxe-table-column>
        </#if>
        <#--列表序号列-->
        <#if showIndex?? && showIndex>
            <vxe-table-column align="center" title="序号" type="seq" width="<#if indexWidth??>${indexWidth.localValue!}<#else>60</#if>"></vxe-table-column>
        </#if>
        <#--列表列-->
        <@editTree list= tableShowFields!></@editTree>
        <#if rowSummary?? && rowSummary>
            <vxe-table-column align="${rowCalculate.align!}" title="合计"
                <#if columnCalculate??>
                    <#list columnCalculate.columnFields! as item>
                        <#if item == 'showRowSummary'>
                            field="showRowSummary"
                            <#break>
                        </#if>
                    </#list>
                </#if>
            >
                <template v-slot="{ row }">
                    <span>{{ ${instanceKey!}RowSummaryEvent(row) }} ${rowCalculate.unit!}</span>
                </template>
            </vxe-table-column>
        </#if>
    </vxe-table>
</div>