/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CaseFormat;
import com.jxdinfo.speedcode.codegenerator.core.action.EventConfig;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.reference.ColWidth;
import com.jxdinfo.speedcode.common.analysismodel.reference.RowCalculate;
import com.jxdinfo.speedcode.common.analysismodel.select.SelectOptionsAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigMappingAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.table.EditRulesData;
import com.jxdinfo.speedcode.common.analysismodel.table.EditTableFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.table.EditTableRulesAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.constant.DataConfigConstant;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.util.FileUtil;
import com.jxdinfo.speedcode.common.util.LoggerUtil;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentDataUtil;
import com.jxdinfo.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.common.utils.RenderRouterUtil;
import com.jxdinfo.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.speedcode.common.utils.ReplaceDataUtil;
import com.jxdinfo.speedcode.common.utils.TableFieldUtil;
import com.jxdinfo.speedcode.elementui.comm.TableMethodUtil;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VxeTableVoidVisitor
implements VoidVisitor {
    protected static final Logger logger = LoggerFactory.getLogger(VxeTableVoidVisitor.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u5206\u9875\u53c2\u6570\uff1apageSize------");
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("pageSize"))) {
            Integer size = (Integer)lcdpComponent.getProps().get("pageSize");
            lcdpComponent.addRenderParam("size", (Object)size);
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("tableHeight"))) {
            Object tableHeight = lcdpComponent.getProps().get("tableHeight");
            lcdpComponent.addRenderParam("tableHeight", tableHeight);
        }
        lcdpComponent.registerTemplatePath("/template/elementui/element/vxeTable/el_vxeTable.ftl");
        Map dataParams = lcdpComponent.getRenderParamsToBind();
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u663e\u793a\u5217\u53c2\u6570\uff1apageSize------");
        }
        List colsList = (List)lcdpComponent.getProps().get("opt_cols");
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx, colsList, dataParams);
        this.renderOptionLoad(lcdpComponent, ctx);
        this.renderEditEules(lcdpComponent, ctx);
        this.componentHaveEvent(lcdpComponent, ctx);
        TableMethodUtil.tableExportOrTemplateDown(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        boolean isPagination;
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u7684data\u6570\u636e\uff1a\u5f00\u59cb------");
        }
        ctx.addData(lcdpComponent.getInstanceKey() + "ChooseData: []");
        Map dataParams = lcdpComponent.getRenderParamsToBind();
        this.renderTableData(lcdpComponent, ctx);
        this.renderTotalData(lcdpComponent, ctx, dataParams);
        this.renderSelectData(lcdpComponent, ctx);
        this.renderCurRowData(lcdpComponent, ctx);
        this.renderPageData(lcdpComponent, ctx, dataParams);
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "TableRef");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
        List layouts = (List)lcdpComponent.getProps().get("layouts");
        StringBuilder layoutsString = new StringBuilder();
        if (ToolUtil.isNotEmpty((Object)layouts) && layouts.size() > 0) {
            layoutsString.append('[');
            for (String str : layouts) {
                layoutsString.append('\'');
                layoutsString.append(str);
                layoutsString.append("',");
            }
            layoutsString.append(']');
        }
        lcdpComponent.addRenderParam("layoutsString", (Object)layoutsString.toString());
        dataParams.put("layoutsString", layoutsString.toString());
        String dataArrayStr = RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_data.ftl", (Map)dataParams);
        ctx.addData(dataArrayStr);
        String instanceKey = lcdpComponent.getInstanceKey();
        StringBuilder stringBuffer = new StringBuilder(instanceKey + "OptCols: [");
        JSONArray colsJson = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        if (ToolUtil.isNotEmpty((Object)colsJson)) {
            List colsList = TableFieldUtil.getRealAllTableFieldList(Collections.singletonList("opt_cols"), (LcdpComponent)lcdpComponent);
            for (TableOptColsAnalysis stringObjectMap : colsList) {
                if (ToolUtil.isNotEmpty((Object)stringObjectMap.getField())) {
                    stringBuffer.append("{ field: \n");
                    stringBuffer.append("    '").append(stringObjectMap.getField());
                    stringBuffer.append("',\n");
                } else {
                    stringBuffer.append("{\n");
                }
                if (ToolUtil.isNotEmpty((Object)stringObjectMap.getColEditComponent())) {
                    stringBuffer.append("colEditComponent: \n");
                    stringBuffer.append("    '").append(stringObjectMap.getColEditComponent());
                    stringBuffer.append("'},\n");
                    continue;
                }
                stringBuffer.append("},\n");
            }
        }
        stringBuffer.append(']');
        ctx.addData(stringBuffer.toString());
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5206\u9875\u53c2\u6570\uff1aisPagination------");
        }
        if ((isPagination = ToolUtil.isNotEmpty(lcdpComponent.getProps().get("isPagination"))) && ((Boolean)lcdpComponent.getProps().get("isPagination")).booleanValue()) {
            ctx.addData(lcdpComponent.getInstanceKey() + "PageHidden: false");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u7684data\u6570\u636e\uff1a\u5f00\u59cb------");
        }
    }

    private void renderPageData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        ArrayList<String> pageDataItems = new ArrayList<String>();
        pageDataItems.add("pagination");
        StringBuilder pageDefault = new StringBuilder(16);
        pageDefault.append("{\ncurrent: 1,\nsize: ");
        RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._IS_CHECK.getType(), Collections.singletonList("checkSuccess"), (String)"true");
        if (null != dataParams.get("pageSize")) {
            pageDefault.append(Integer.parseInt(dataParams.get("pageSize").toString())).append(",\n}");
        } else {
            pageDefault.append("10,\n}");
        }
        String pageData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_PAGE_DATA.getType(), pageDataItems, (String)pageDefault.toString());
        lcdpComponent.addRenderParam("ListQuery", (Object)pageData);
        dataParams.put("ListQuery", pageData);
    }

    private void renderSelectData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ArrayList<String> selectItems = new ArrayList<String>();
        selectItems.add("data");
        RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_DATA_CHECKED.getType(), selectItems, (String)"[]");
    }

    private void renderCurRowData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        ArrayList<String> curRowItems = new ArrayList<String>();
        curRowItems.add("curRowData");
        RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._CUR_ROW_DATA.getType(), curRowItems, (String)"{}");
    }

    private void renderTotalData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        if (null != dataParams.get("isPagination") && ((Boolean)dataParams.get("isPagination")).booleanValue()) {
            ArrayList<String> totalItems = new ArrayList<String>();
            totalItems.add("total");
            String totalData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_TOTAL.getType(), totalItems, (String)"0");
            lcdpComponent.addRenderParam("TableTotal", (Object)totalData);
            dataParams.put("TableTotal", totalData);
        }
    }

    private void renderTableData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)"[]");
        lcdpComponent.addAttr(CodePrefix._DATA.getType(), valueData);
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx, List<Map<String, Object>> opt_colsList, Map<String, Object> dataParams) throws Exception {
        boolean isSortChange;
        boolean isTableMenu;
        boolean isControlColumn;
        Object isPagination;
        Map columnCalculateMap;
        Map rowCalculateMap;
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u663e\u793a\u5217\u53c2\u6570\uff1aisPagination------");
        }
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        JSONArray allColumns = this.getAllColumns(optColsJSONArray);
        ArrayList<String> fields = new ArrayList<String>();
        for (int i = 0; i < allColumns.size(); ++i) {
            if (!ToolUtil.isNotEmpty((Object)allColumns.get(i))) continue;
            String field = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"field"));
            String colDisabled = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"colDisabled"));
            if (colDisabled != "true") continue;
            fields.add(field);
        }
        Map renderParamsMap = lcdpComponent.getRenderParams();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> column = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(fields)) {
            params.put("fields", fields);
            column.add("{column}");
        }
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u7981\u7528\u53c2\u6570\uff1adisabled------");
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("disabled"))) {
            boolean disabled = (Boolean)lcdpComponent.getProps().get("disabled");
            lcdpComponent.addRenderParam("isDisabled", (Object)disabled);
            ctx.addMethod(lcdpComponent.getInstanceKey() + "ActiveRowMethod", column, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_ActiveRowMethod.ftl", params));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u590d\u9009\u6846\u7981\u7528\u5f00\u59cb------");
        }
        ctx.addMethod(lcdpComponent.getInstanceKey() + "Selectable", "return !" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "Disabled;");
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u590d\u9009\u6846\u7981\u7528\u7ed3\u675f------");
        }
        StringBuilder rowCalculateColumnContact = new StringBuilder();
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u5408\u8ba1\u884c\u53c2\u6570\uff1aRowCalculate------");
        }
        if (ToolUtil.isNotEmpty((Object)(rowCalculateMap = (Map)lcdpComponent.getProps().get("RowCalculate"))) && ToolUtil.isNotEmpty(rowCalculateMap.get("columnData"))) {
            ctx.addData(lcdpComponent.getInstanceKey() + "RowCalculateColumn:" + rowCalculateMap.get("columnData"));
            List rowCalculateColumn = (List)rowCalculateMap.get("columnData");
            if (rowCalculateColumn.size() > 0) {
                for (int i = 0; i < rowCalculateColumn.size(); ++i) {
                    rowCalculateColumnContact.append("const ").append('p').append(i + 1).append(" = ").append("Number(this.$numeral(row[this.").append(lcdpComponent.getInstanceKey()).append("RowCalculateColumn[").append(i).append("]]).format('").append((Object)("".equals(rowCalculateMap.get("format")) ? "0.00" : rowCalculateMap.get("format"))).append("'))").append(";\n");
                }
            }
        }
        params.put("rowCalculateColumnContact", rowCalculateColumnContact);
        if (ToolUtil.isNotEmpty((Object)rowCalculateMap)) {
            params.put("rowCalculateFormula", rowCalculateMap.get("formula"));
            params.put("unit", rowCalculateMap.get("unit"));
            params.put("format", rowCalculateMap.get("format"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u5408\u8ba1\u884c\u914d\u7f6e\u53c2\u6570\uff1acolumnCalculate------");
        }
        if (ToolUtil.isNotEmpty((Object)(columnCalculateMap = (Map)lcdpComponent.getProps().get("columnCalculate")))) {
            params.put("columnCalculateMap", columnCalculateMap);
            params.put("columnSummaryMatch", ToolUtil.isEmpty(lcdpComponent.getProps().get("columnSummaryMatch")) ? Boolean.valueOf(true) : lcdpComponent.getProps().get("columnSummaryMatch"));
            List fileds = (List)columnCalculateMap.get("columnFields");
            if (ToolUtil.isNotEmpty((Object)fileds) && fileds.size() > 0) {
                String dataArrayStr = RenderUtil.renderTemplate((String)"/template/elementui/element/table/table_assignmentData.ftl", params);
                ctx.addData(dataArrayStr);
            }
        }
        LcdpComponent editTableIns = (LcdpComponent)ctx.getComponentMap().get(lcdpComponent.getInstanceKey());
        ValueVisitor valueVisitor = (ValueVisitor)editTableIns.getProvideVisitor("value");
        valueVisitor.visit(editTableIns, ctx, null);
        String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
        params.put("dataName", dataName);
        List eventConfigs = lcdpComponent.getEvents();
        if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
            for (EventConfig eventConfig : eventConfigs) {
                if ("rowSelection".equals(eventConfig.getTrigger())) {
                    params.put("rowSelection", true);
                }
                if (!"rowSelectionChange".equals(eventConfig.getTrigger())) continue;
                params.put("rowSelectionChange", true);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5355\u9009\u53c2\u6570\uff1aisRadio------");
        }
        Boolean isRadio = (Boolean)lcdpComponent.getProps().get("isRadio");
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u8de8\u9875\u9762\u591a\u9009\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u8de8\u9875\u9762\u591a\u9009\u53c2\u6570\uff1acrossPageSelect------");
        }
        Boolean crossPageSelect = (Boolean)lcdpComponent.getProps().get("crossPageSelect");
        ArrayList<String> selectRow = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)isRadio) && isRadio.booleanValue()) {
            lcdpComponent.addRenderParam("isRadio", (Object)true);
            selectRow.add("{ row }");
            params.put("isRadio", true);
        } else {
            if (ToolUtil.isNotEmpty((Object)crossPageSelect) && crossPageSelect.booleanValue()) {
                params.put("crossPageSelect", true);
                lcdpComponent.addRenderParam("crossPageSelect", (Object)true);
                selectRow.add("{ selection, reserves }");
            } else {
                selectRow.add("{ selection }");
            }
            ctx.addMethod(lcdpComponent.getInstanceKey() + "SelectAll", selectRow, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxe_table_select_all_method.ftl", params));
        }
        ctx.addImports("import * as _ from 'lodash'");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "SelectRow", selectRow, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxe_table_select_row_method.ftl", params));
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u8de8\u9875\u9762\u591a\u9009\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u5206\u9875\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        ArrayList<String> handleSizeChange = new ArrayList<String>();
        handleSizeChange.add("pageSize");
        ArrayList<String> handleCurrentChange = new ArrayList<String>();
        handleCurrentChange.add("currentPage");
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5206\u9875\u53c2\u6570\uff1aisPagination------");
        }
        if (ToolUtil.isNotEmpty(isPagination = lcdpComponent.getProps().get("isPagination")) && Boolean.valueOf(isPagination.toString()).booleanValue()) {
            ArrayList<String> pageDataItems = new ArrayList<String>();
            pageDataItems.add("pagination");
            StringBuilder pageDefault = new StringBuilder(16);
            pageDefault.append("{\ncurrent: 1,\nsize: ");
            if (null != dataParams.get("pageSize")) {
                pageDefault.append(Integer.parseInt(dataParams.get("pageSize").toString())).append(",\n}");
            } else {
                pageDefault.append("10,\n}");
            }
            params.put("ListQuery", RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_PAGE_DATA.getType(), pageDataItems, (String)pageDefault.toString()));
            params.put("isSortChange", this.renderSortOverall(lcdpComponent, ctx));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleSizeChange", handleSizeChange, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleSizeChangeMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleCurrentChange", handleCurrentChange, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleCurrentChangeMethod.ftl", params));
            ArrayList<String> indexAdd = new ArrayList<String>();
            indexAdd.add("{ seq }");
            Boolean showIndex = (Boolean)lcdpComponent.getProps().get("showIndex");
            if (ToolUtil.isNotEmpty((Object)showIndex) && showIndex.booleanValue()) {
                ctx.addMethod(lcdpComponent.getInstanceKey() + "indexAdd", indexAdd, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_indexAddMethod.ftl", params));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u5206\u9875\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u64cd\u4f5c\u5217\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        ArrayList<String> handleEditRowEvent = new ArrayList<String>();
        handleEditRowEvent.add("row");
        boolean bl = isControlColumn = ToolUtil.isNotEmpty((Object)renderParamsMap) && ToolUtil.isNotEmpty(renderParamsMap.get("isControlColumn")) && (Boolean)renderParamsMap.get("isControlColumn") != false;
        if (isControlColumn) {
            params.put("strategy", ctx.getStrategy());
            ctx.addMethod(lcdpComponent.getInstanceKey() + "EditRowEvent", handleEditRowEvent, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleEditRowEventMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "RemoveEvent", handleEditRowEvent, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleRemoveEventMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "SaveRowEvent", handleEditRowEvent, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleSaveRowEventMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "CancelRowEvent", handleEditRowEvent, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleCancelRowEventMethod.ftl", params));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u64cd\u4f5c\u5217\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u5408\u8ba1\u884c\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        ArrayList<String> handleColumnSummaryEvent = new ArrayList<String>();
        handleColumnSummaryEvent.add("{ columns, data }");
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("columnSummary")) && ((Boolean)lcdpComponent.getProps().get("columnSummary")).booleanValue()) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "ColumnSummaryEvent", handleColumnSummaryEvent, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleColumnSummaryEventMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "UpdateFooterEvent", RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_handleUpdateFooterEventMethod.ftl", params));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u5408\u8ba1\u884c\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u53f3\u952e\u83dc\u5355\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5f00\u542f\u53f3\u952e\u83dc\u5355\u53c2\u6570\uff1aisTableMenu------");
        }
        boolean bl2 = isTableMenu = ToolUtil.isNotEmpty(lcdpComponent.getProps().get("isTableMenu")) && (Boolean)lcdpComponent.getProps().get("isTableMenu") != false;
        if (isTableMenu) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("{menu, row, column}");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "ContextMenuClickEvent", args, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_contextMenuClickEventMethod.ftl", params));
            ArrayList visibleArgs = new ArrayList();
            visibleArgs.add("{options, column}");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "MenuVisibleMethod", (List)visibleArgs, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_contextMenuVisibleMethod.ftl", params));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u53f3\u952e\u83dc\u5355\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u683c\u5f0f\u5316\u6570\u636e\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        ArrayList<StringBuilder> formatDataMap = new ArrayList<StringBuilder>();
        if (ToolUtil.isNotEmpty(opt_colsList)) {
            for (Map<String, Object> stringObjectMap : opt_colsList) {
                StringBuilder formatData = new StringBuilder();
                if (ToolUtil.isNotEmpty(stringObjectMap) && ToolUtil.isNotEmpty((Object)stringObjectMap.get("colEditComponent"))) {
                    String field;
                    String colEditComponent = String.valueOf(stringObjectMap.get("colEditComponent"));
                    Map selectTypeMap = (Map)stringObjectMap.get("selectFormat");
                    if (ToolUtil.isNotEmpty((Object)selectTypeMap) && ToolUtil.isNotEmpty((Object)(field = String.valueOf(stringObjectMap.get("field"))))) {
                        String dateFmt;
                        if ("number".equals(colEditComponent)) {
                            String numberFmt = String.valueOf(selectTypeMap.get("numberFmtSelect"));
                            if (ToolUtil.isNotEmpty((Object)numberFmt)) {
                                formatData.append(numberFmt);
                                formatDataMap.add(formatData);
                                continue;
                            }
                        } else if ("date".equals(colEditComponent) && ToolUtil.isNotEmpty((Object)(dateFmt = String.valueOf(selectTypeMap.get("dateFmtSelect"))))) {
                            formatData.append(dateFmt);
                            formatDataMap.add(formatData);
                            continue;
                        }
                    }
                }
                formatDataMap.add(formatData);
            }
            if (ToolUtil.isNotEmpty(formatDataMap)) {
                lcdpComponent.addRenderParam("formatDataMap", formatDataMap);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u683c\u5f0f\u5316\u6570\u636e\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"showConfigs");
        this.renderReplaceData(lcdpComponent, ctx, showConfigAnalyses);
        this.renderTableLoad(lcdpComponent, ctx, showConfigAnalyses, formatDataMap);
        this.renderTableCol(lcdpComponent, showConfigAnalyses, ctx, opt_colsList);
        this.renderTableInit(lcdpComponent, ctx, showConfigAnalyses);
        Boolean isRowSpan = this.renderRowSpan(lcdpComponent, ctx);
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u5168\u5c40\u6392\u5e8f\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (isSortChange = this.renderSortOverall(lcdpComponent, ctx)) {
            ArrayList<String> orderParams = new ArrayList<String>();
            orderParams.add("val");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "SortChange", orderParams, RenderUtil.renderTemplate((String)"template/elementui/element/vxeTable/vxeTable_sortChangeMethod.ftl", params));
            ctx.addData(lcdpComponent.getInstanceKey() + "ForOrderType: []");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "ShowSortType", RenderUtil.renderTemplate((String)"template/elementui/element/vxeTable/vxeTable_ShowSortTypeMethod.ftl", params));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u5168\u5c40\u6392\u5e8f\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u8d85\u94fe\u63a5\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (ToolUtil.isNotEmpty((Object)allColumns)) {
            List tableOptColsAnalyses = JSON.parseArray((String)allColumns.toJSONString(), TableOptColsAnalysis.class);
            Boolean isLinkExist = true;
            for (int i = 0; i < tableOptColsAnalyses.size(); ++i) {
                Map hyperlinks = ((TableOptColsAnalysis)tableOptColsAnalyses.get(i)).getHyperlinks();
                if (!ToolUtil.isNotEmpty((Object)hyperlinks) || !ToolUtil.isNotEmpty(hyperlinks.get("fileId"))) continue;
                if (ToolUtil.isNotEmpty(hyperlinks.get("jumpType"))) {
                    params.put("jumpType", hyperlinks.get("jumpType"));
                }
                String id = String.valueOf(hyperlinks.get("fileId"));
                String routerPath = null;
                if (ToolUtil.isNotEmpty((Object)id)) {
                    routerPath = FileUtil.posixPath((String[])new String[]{"/", "${tenantCommon.appRoutePrefix}", this.fileMappingService.getFormatPath(id)});
                }
                params.put("url", routerPath);
                HashMap<String, String> paramConfig = new HashMap<String, String>();
                HashMap paramBody = new HashMap();
                Map pageParamConfig = (Map)hyperlinks.get("pageParamConfig");
                Set pageParamSet = pageParamConfig.keySet();
                HashMap<String, String> optColsFieldMap = new HashMap<String, String>();
                ArrayList<String> pageKeyList = new ArrayList<String>();
                block5: for (String key : pageParamSet) {
                    pageKeyList.add("row");
                    Map pageParam = (Map)pageParamConfig.get(key);
                    JSONArray instanceData = (JSONArray)pageParam.get("instanceData");
                    String instanceKey = String.valueOf(pageParam.get("instanceKey"));
                    LcdpComponent hyperlinksLcdp = (LcdpComponent)ctx.getComponentMap().get(instanceKey);
                    if (ToolUtil.isNotEmpty((Object)hyperlinksLcdp) && hyperlinksLcdp.getName().indexOf("JXDElVxeTable") >= 0) {
                        JSONArray hyperlinks_LcdpOptCols;
                        if (logger.isDebugEnabled()) {
                            logger.debug(" -----\u83b7\u53d6\u8d85\u94fe\u63a5\u663e\u793a\u5217\u53c2\u6570\uff1aopt_cols------");
                        }
                        if (ToolUtil.isNotEmpty((Object)(hyperlinks_LcdpOptCols = (JSONArray)hyperlinksLcdp.getProps().get("opt_cols")))) {
                            JSONArray hyperlinksLcdpOptCols = this.getAllColumns(hyperlinks_LcdpOptCols);
                            List hyperlinksLcdpOptColsAnalyses = JSON.parseArray((String)hyperlinksLcdpOptCols.toJSONString(), TableOptColsAnalysis.class);
                            if (logger.isDebugEnabled()) {
                                logger.debug(" -----\u83b7\u53d6\u8d85\u94fe\u63a5\u9690\u85cf\u5217\u53c2\u6570\uff1ahidden_cols------");
                            }
                            for (TableOptColsAnalysis t : hyperlinksLcdpOptColsAnalyses) {
                                if (!t.getId().equals(instanceData.getString(1))) continue;
                                optColsFieldMap.put(key, "row." + t.getField());
                                break;
                            }
                        }
                        JSONArray hyperlinksLcdpHiddenCols = (JSONArray)hyperlinksLcdp.getProps().get("hidden_cols");
                        List hyperlinksLcdpHiddenColsAnalyses = JSON.parseArray((String)hyperlinksLcdpHiddenCols.toJSONString(), TableOptColsAnalysis.class);
                        for (TableOptColsAnalysis t : hyperlinksLcdpHiddenColsAnalyses) {
                            if (!t.getId().equals(instanceData.getString(1))) continue;
                            optColsFieldMap.put(key, "row." + t.getField());
                            continue block5;
                        }
                        continue;
                    }
                    ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)pageParamConfig.get(key).toString(), ComponentReference.class);
                    ComponentData paramData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                    if (null != paramData) {
                        paramConfig.put(key, paramData.getRenderValue());
                        continue;
                    }
                    paramConfig.put(key, "''");
                }
                params.put("params", optColsFieldMap);
                if (ToolUtil.isNotEmpty(paramConfig)) {
                    String paramStr = "";
                    Object[] keySet = paramConfig.keySet().toArray();
                    for (int j = 0; j < keySet.length; ++j) {
                        JSONObject ppcElement = (JSONObject)pageParamConfig.get(keySet[j]);
                        if (j == keySet.length - 1) {
                            if (ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant")) {
                                paramStr = paramStr + keySet[j] + "=" + paramConfig.get(keySet[j]).toString().replaceAll("'", "");
                                continue;
                            }
                            paramStr = paramStr + keySet[j] + "=${" + paramConfig.get(keySet[j]) + "}";
                            continue;
                        }
                        paramStr = ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant") ? paramStr + keySet[j] + "=" + paramConfig.get(keySet[j]).toString().replaceAll("'", "") + "&" : paramStr + keySet[j] + "=${" + paramConfig.get(keySet[j]) + "}&";
                    }
                    params.put("paramStr", paramStr);
                }
                params.put("paramConfig", paramConfig);
                String firstParams = RenderUtil.renderTemplate((String)"/template/elementui/element/table/get_params.ftl", params);
                Map hyperlinksParams = ((TableOptColsAnalysis)tableOptColsAnalyses.get(i)).getHyperlinksParams();
                if (ToolUtil.isNotEmpty((Object)hyperlinksParams)) {
                    String hussarRouter = RenderRouterUtil.hussarRouter((TableOptColsAnalysis)((TableOptColsAnalysis)tableOptColsAnalyses.get(i)), (Ctx)ctx, (FileMappingService)this.fileMappingService, (String)firstParams, (String)hyperlinks.get("fileId").toString());
                    params.put("hussarRouter", hussarRouter);
                }
                params.put("strategy", ctx.getStrategy());
                ctx.addMethod(lcdpComponent.getInstanceKey() + ((TableOptColsAnalysis)tableOptColsAnalyses.get(i)).getField() + "CLICK", pageKeyList, RenderUtil.renderTemplate((String)"/template/elementui/element/table/table_hyperlinksMethod.ftl", params));
                if (!isLinkExist.booleanValue()) continue;
                isLinkExist = false;
                ctx.addMethod(lcdpComponent.getInstanceKey() + "ToolTipsDisplay", RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_toolTipDisplay.ftl", params));
                ctx.addDeactivated(CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "ToolTipsDisplay();");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u8d85\u94fe\u63a5\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private void renderTableInit(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u521d\u59cb\u5316\u8868\u683c\u6570\u636e\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        HashMap<String, Object> tableInitMap = new HashMap<String, Object>();
        tableInitMap.put("instanceKey", lcdpComponent.getInstanceKey());
        ArrayList<String> valueItem = new ArrayList<String>();
        valueItem.add("value");
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, valueItem))) {
            tableInitMap.put("referenceData", "exist");
        }
        if (ToolUtil.isNotEmpty(showConfigAnalyses)) {
            tableInitMap.put("replaceData", true);
            LcdpComponent editTableIns = (LcdpComponent)ctx.getComponentMap().get(lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)editTableIns.getProvideVisitor("value");
            valueVisitor.visit(editTableIns, ctx, null);
            String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
            tableInitMap.put("dataName", dataName);
        }
        ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_INTI.getType(), RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/initVxeTable.ftl", tableInitMap));
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u521d\u59cb\u5316\u8868\u683c\u6570\u636e\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private void renderTableLoad(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses, List<StringBuilder> formatDataMap) throws Exception {
        List eventConfigs;
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u8868\u683c\u52a0\u8f7d\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        String operationName = "hussarQuery";
        String operationNameByOrderOverall = "";
        String dataTableId = lcdpComponent.getInstanceKey();
        tableMap.put("instanceKey", dataTableId);
        String apiFileName = "";
        String apiFilePath = "";
        StringBuilder queryAttr = new StringBuilder(128);
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            lcdpComponent.addRenderParam("hasDataSAnalysis", (Object)true);
        }
        Map fields = new HashMap();
        String primary = "";
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            Object isSummary;
            Object isProc;
            Object isPagination;
            String sortConditionName;
            DataSortConditionAnalysis dataSortConditionAnalysis;
            DataSConditionAnalysis dataSConditionAnalysis;
            fields = dataSModelAnalysis.getFields();
            String dataModelId = dataSModelAnalysis.getDataModelId();
            if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                if (ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId).getPrimaryField())) {
                    primary = DataModelUtil.getDataModelBase((String)dataModelId).getPrimaryField().getName();
                    lcdpComponent.addRenderParam("rowId", (Object)primary);
                }
                apiFileName = this.fileMappingService.getFileName(dataModelId);
                apiFilePath = this.fileMappingService.getImportPath(dataModelId);
            }
            if (ToolUtil.isNotEmpty((Object)(dataSConditionAnalysis = dataSModelAnalysis.getCondition()))) {
                List conditionList = dataSConditionAnalysis.getQueryConditionModelList();
                queryAttr = QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx);
                String querySelectionName = dataSConditionAnalysis.getSelectCondition();
                if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                    operationName = operationName + querySelectionName;
                }
            }
            if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                operationName = operationName + sortConditionName;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5206\u9875\u53c2\u6570\uff1aisPagination------");
            }
            if (ToolUtil.isNotEmpty(isPagination = lcdpComponent.getProps().get("isPagination")) && Boolean.valueOf(isPagination.toString()).booleanValue()) {
                Boolean isTableLoadByOrderDy;
                operationName = operationName + CodeSuffix._TABLE_PAGE_SUFFIX.getType();
                if (logger.isDebugEnabled()) {
                    logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5168\u5c40\u6392\u5e8f\u53c2\u6570\uff1aisSortOverall------");
                }
                if (ToolUtil.isNotEmpty((Object)(isTableLoadByOrderDy = (Boolean)lcdpComponent.getProps().get("isSortOverall"))) && Boolean.valueOf(isTableLoadByOrderDy.toString()).booleanValue()) {
                    operationNameByOrderOverall = operationName + CodeSuffix._TABLE_ORDER_CUSTOM_SUFFIX.getType();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(" -----\u83b7\u53d6\u662f\u5426\u6d41\u7a0b\u8868\u683c\u53c2\u6570\uff1aflowTable------");
            }
            if (ToolUtil.isNotEmpty(isProc = lcdpComponent.getProps().get("flowTable")) && Boolean.valueOf(isProc.toString()).booleanValue()) {
                operationName = operationName + CodeSuffix._IS_PROC.getType();
            }
            if (ToolUtil.isNotEmpty(isSummary = lcdpComponent.getProps().get("processSummary")) && Boolean.parseBoolean(isSummary.toString())) {
                operationName = operationName + CodeSuffix._IS_SUMMARY.getType();
            }
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
        }
        tableMap.put("importName", apiFileName);
        tableMap.put("importMethod", operationName);
        tableMap.put("queryAttr", queryAttr);
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.size() > 0) {
            tableMap.put("isShowConfig", true);
        }
        tableMap.putAll(lcdpComponent.getRenderParamsToBind());
        JSONArray optCols = (JSONArray)tableMap.get("opt_cols");
        JSONArray hiddenCols = (JSONArray)tableMap.get("hidden_cols");
        List cols = JSON.parseArray((String)optCols.toJSONString(), TableOptColsAnalysis.class);
        if (ToolUtil.isNotEmpty((Object)hiddenCols)) {
            List hidden = JSON.parseArray((String)hiddenCols.toJSONString(), TableOptColsAnalysis.class);
            cols.addAll(hidden);
        }
        ArrayList<TableOptColsAnalysis> realCols = new ArrayList<TableOptColsAnalysis>();
        this.getCols(cols, realCols);
        HashMap<String, String> colFields = new HashMap<String, String>();
        String col = "";
        String field = "";
        if (ToolUtil.isNotEmpty(fields) && ToolUtil.isNotEmpty(realCols)) {
            for (TableOptColsAnalysis tableOptColsAnalysis : realCols) {
                boolean flag = true;
                for (List modelField : fields.values()) {
                    List dataItems;
                    if (modelField.size() <= 0 || !ToolUtil.isNotEmpty((Object)tableOptColsAnalysis) || !ToolUtil.isNotEmpty((Object)(dataItems = ((DataSFieldAnalysis)modelField.get(0)).getDataItemPath())) || dataItems.size() <= 1 || !tableOptColsAnalysis.getId().equals(dataItems.get(1))) continue;
                    col = tableOptColsAnalysis.getField();
                    field = ((DataSFieldAnalysis)modelField.get(0)).getFieldName();
                    colFields.put(col, field);
                    flag = false;
                    break;
                }
                if (!flag) continue;
                col = tableOptColsAnalysis.getField();
                colFields.put(col, col);
            }
        }
        boolean containPrimary = false;
        if (ToolUtil.isNotEmpty(fields)) {
            for (List modelField : fields.values()) {
                if (modelField.size() <= 0 || !primary.equals(((DataSFieldAnalysis)modelField.get(0)).getFieldName())) continue;
                containPrimary = true;
                break;
            }
        }
        if (!containPrimary && ToolUtil.isNotEmpty((Object)primary)) {
            colFields.put(primary, primary);
        }
        tableMap.put("colFields", colFields);
        LcdpComponent editTableIns = (LcdpComponent)ctx.getComponentMap().get(lcdpComponent.getInstanceKey());
        ValueVisitor valueVisitor = (ValueVisitor)editTableIns.getProvideVisitor("value");
        valueVisitor.visit(editTableIns, ctx, null);
        String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
        tableMap.put("dataName", dataName.substring(dataName.indexOf(46) + 1));
        if (ToolUtil.isNotEmpty(formatDataMap)) {
            tableMap.put("isformat", true);
        }
        tableMap.put("renderSortOverall", this.renderSortOverall(lcdpComponent, ctx));
        tableMap.put("importMethodByOrderDy", operationNameByOrderOverall);
        tableMap.put("strategy", ctx.getStrategy());
        ArrayList<String> callbacks = new ArrayList<String>();
        callbacks.add("callback");
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u6d41\u7a0b\u8868\u683c\u53c2\u6570\uff1aflowTable------");
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("flowTable")) && ((Boolean)lcdpComponent.getProps().get("flowTable")).booleanValue()) {
            tableMap.put("isFlowTable", true);
        }
        if (ToolUtil.isNotEmpty((Object)(eventConfigs = lcdpComponent.getEvents()))) {
            for (EventConfig eventConfig : eventConfigs) {
                if (!"rowSelectionChange".equals(eventConfig.getTrigger())) continue;
                tableMap.put("rowSelectionChange", true);
            }
        }
        ctx.addMethod(lcdpComponent.getInstanceKey() + "TableLoad", callbacks, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_tableLoadMethod.ftl", tableMap));
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5206\u9875\u53c2\u6570\uff1aisPagination\uff0c\u83b7\u53d6\u662f\u5426\u5168\u5c40\u6392\u5e8f\u53c2\u6570\uff1aisSortOverall------");
        }
        Boolean isPagination = (Boolean)lcdpComponent.getProps().get("isPagination");
        Boolean isTableLoadByOrderDy = (Boolean)lcdpComponent.getProps().get("isSortOverall");
        if (ToolUtil.isNotEmpty((Object)isTableLoadByOrderDy) && isTableLoadByOrderDy.booleanValue() && ToolUtil.isNotEmpty((Object)isPagination) && Boolean.valueOf(isPagination.toString()).booleanValue()) {
            tableMap.put("importMethod", operationNameByOrderOverall);
            ctx.addMethod(lcdpComponent.getInstanceKey() + "TableLoadByOrderDy", callbacks, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_tableLoadMethod.ftl", tableMap));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u8868\u683c\u52a0\u8f7d\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private void renderTableCol(LcdpComponent lcdpComponent, List<ShowConfigAnalysis> showConfigAnalyses, Ctx ctx, List<Map<String, Object>> optColsList) throws Exception {
        int i;
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3\u8868\u683c\u5217\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u8868\u683c\u5217\u53c2\u6570\uff1aopt_cols------");
        }
        JSONArray optCols_JSONArray = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)lcdpComponent)) {
            optCols_JSONArray = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        }
        List tableOptColsAnalyses = JSON.parseArray((String)optCols_JSONArray.toJSONString(), TableOptColsAnalysis.class);
        JSONArray optColsJSONArray = new JSONArray();
        List<EditTableFieldAnalysis> tableFieldAnalyses = this.tableFildCopy(tableOptColsAnalyses, lcdpComponent, showConfigAnalyses);
        lcdpComponent.addRenderParam("tableShowFields", tableFieldAnalyses);
        if (ToolUtil.isNotEmpty((Object)optCols_JSONArray)) {
            optColsJSONArray = this.getAllColumns(optCols_JSONArray);
        }
        if (ToolUtil.isNotEmpty((Object)optColsJSONArray)) {
            tableOptColsAnalyses = JSON.parseArray((String)optColsJSONArray.toJSONString(), TableOptColsAnalysis.class);
            tableFieldAnalyses = this.tableFildCopy(tableOptColsAnalyses, lcdpComponent, showConfigAnalyses);
            String instanceKey = lcdpComponent.getInstanceKey();
            boolean existCheckboxGroup = false;
            if (ToolUtil.isNotEmpty(tableFieldAnalyses)) {
                for (i = 0; i < tableFieldAnalyses.size(); ++i) {
                    String option = " [";
                    EditTableFieldAnalysis editTableFieldAnalysis = tableFieldAnalyses.get(i);
                    if (!ToolUtil.isNotEmpty((Object)editTableFieldAnalysis)) continue;
                    String editComponent = editTableFieldAnalysis.getColEditComponent();
                    if ("select".equals(editComponent) || "radioGroup".equals(editComponent) || "checkboxGroup".equals(editComponent)) {
                        if (ToolUtil.isNotEmpty((Object)editTableFieldAnalysis.getDataType())) {
                            String name;
                            Object value;
                            SelectOptionsAnalysis selectOptionsAnalysis;
                            int j;
                            List optionsList;
                            JSONObject selectFormat;
                            JSONArray cols;
                            if ("number".equals(editTableFieldAnalysis.getDataType())) {
                                if (ToolUtil.isNotEmpty((Object)editTableFieldAnalysis.getSelectFormat()) && ToolUtil.isNotEmpty((Object)(cols = (selectFormat = editTableFieldAnalysis.getSelectFormat()).getJSONArray("cols")))) {
                                    optionsList = JSON.parseArray((String)cols.toJSONString(), SelectOptionsAnalysis.class);
                                    for (j = 0; j < optionsList.size(); ++j) {
                                        selectOptionsAnalysis = (SelectOptionsAnalysis)optionsList.get(j);
                                        value = Integer.parseInt(selectOptionsAnalysis.getValue());
                                        name = selectOptionsAnalysis.getName();
                                        option = option + "{\n            label: '" + name + "',\n            value: " + value + ",\n          },";
                                    }
                                }
                            } else if (ToolUtil.isNotEmpty((Object)editTableFieldAnalysis.getSelectFormat()) && ToolUtil.isNotEmpty((Object)(cols = (selectFormat = editTableFieldAnalysis.getSelectFormat()).getJSONArray("cols")))) {
                                optionsList = JSON.parseArray((String)cols.toJSONString(), SelectOptionsAnalysis.class);
                                for (j = 0; j < optionsList.size(); ++j) {
                                    selectOptionsAnalysis = (SelectOptionsAnalysis)optionsList.get(j);
                                    value = selectOptionsAnalysis.getValue();
                                    name = selectOptionsAnalysis.getName();
                                    option = option + "{\n            label: '" + name + "',\n            value: '" + (String)value + "',\n          },";
                                }
                            }
                        }
                        option = option + ']';
                        ctx.addData(instanceKey + StringUtils.capitalize((String)editTableFieldAnalysis.getProp()) + "Options:" + option + "");
                    }
                    if (!"checkboxGroup".equals(editComponent)) continue;
                    existCheckboxGroup = true;
                }
            }
            if (existCheckboxGroup) {
                ArrayList<String> methodParams = new ArrayList<String>();
                methodParams.add("value, row, field");
                ctx.addMethod(instanceKey + "CheckboxGroupInput", methodParams, "value.forEach((item, index) => {  if (!item) {    value.splice(index, 1);  }});row[field] = value.join(',');");
            }
        }
        JSONArray allColumns = this.getAllColumns(optColsJSONArray);
        boolean hasDialogEditComponent = false;
        for (i = 0; i < allColumns.size(); ++i) {
            ArrayList<String> args;
            HashMap<String, String> params = new HashMap<String, String>();
            if (!ToolUtil.isNotEmpty((Object)allColumns.get(i))) continue;
            String field = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"field"));
            String columnColor = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"columnColor"));
            String columnBackgroundColor = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"columnBackgroundColor"));
            String columnBorderColor = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"columnBorderColor"));
            String columnFontFamily = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"columnFontFamily"));
            String colEditComponent = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"colEditComponent"));
            String selectFormat = String.valueOf(((JSONObject)allColumns.get(i)).get((Object)"selectFormat"));
            if (ToolUtil.isNotEmpty((Object)field)) {
                params.put("field", field);
            }
            if (ToolUtil.isNotEmpty((Object)columnColor)) {
                params.put("columnColor", columnColor);
            }
            if (ToolUtil.isNotEmpty((Object)columnBackgroundColor)) {
                params.put("columnBackgroundColor", columnBackgroundColor);
            }
            if (ToolUtil.isNotEmpty((Object)columnBorderColor)) {
                params.put("columnBorderColor", columnBorderColor);
            }
            if (ToolUtil.isNotEmpty((Object)columnFontFamily)) {
                params.put("columnFontFamily", columnFontFamily);
            }
            if (ToolUtil.isNotEmpty((Object)columnColor) || ToolUtil.isNotEmpty((Object)columnBackgroundColor) || ToolUtil.isNotEmpty((Object)columnBorderColor) || ToolUtil.isNotEmpty((Object)columnFontFamily)) {
                args = new ArrayList<String>();
                args.add("row");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "CellStyle", args, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxe_table_column_style.ftl", params));
                Boolean columnStyle = true;
                lcdpComponent.addRenderParam("columnStyle", (Object)columnStyle);
            }
            if (!ToolUtil.isNotEmpty((Object)colEditComponent) || !"dialog".equals(colEditComponent)) continue;
            args = new ArrayList();
            HashMap<String, String> dialogParam = new HashMap<String, String>(2);
            if (ToolUtil.isNotEmpty((Object)selectFormat)) {
                Map selectFormatMap = (Map)JSON.parseObject((String)selectFormat, HashMap.class);
                boolean showDialogSelectDom = Boolean.parseBoolean(selectFormatMap.get("showDialogSelectDom").toString());
                Object dialogSelectDom = selectFormatMap.get("dialogSelectDom");
                if (ToolUtil.isNotEmpty((Object)showDialogSelectDom) && ToolUtil.isNotEmpty(dialogSelectDom) && showDialogSelectDom) {
                    dialogParam.put("dialogIns", dialogSelectDom.toString());
                }
            }
            dialogParam.put("curIns", lcdpComponent.getInstanceKey());
            args.add("val");
            ctx.addMethod(lcdpComponent.getInstanceKey() + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, field) + "EditEvent", args, RenderUtil.renderTemplate((String)"template/elementui/element/editTable/editTable_colDialog.ftl", dialogParam));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3\u8868\u683c\u5217\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private List<EditTableFieldAnalysis> tableFildCopy(List<TableOptColsAnalysis> list, LcdpComponent lcdpComponent, List<ShowConfigAnalysis> showConfigAnalyses) {
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        boolean isSetControlColumn = false;
        ArrayList<EditTableFieldAnalysis> tableFieldAnalyses = new ArrayList<EditTableFieldAnalysis>();
        for (TableOptColsAnalysis tableOptColsAnalysis : list) {
            EditTableFieldAnalysis editTableFieldAnalysis = new EditTableFieldAnalysis();
            editTableFieldAnalysis.setIsParent(tableOptColsAnalysis.isParent());
            if (editTableFieldAnalysis.getIsParent() && tableOptColsAnalysis.getChildren().size() > 0) {
                editTableFieldAnalysis.setChildren(this.tableFildCopy(tableOptColsAnalysis.getChildren(), lcdpComponent, showConfigAnalyses));
            }
            editTableFieldAnalysis.setAlign(tableOptColsAnalysis.getAlign());
            editTableFieldAnalysis.setBodyAlign(tableOptColsAnalysis.getBodyAlign());
            editTableFieldAnalysis.setLabel(tableOptColsAnalysis.getTitle());
            editTableFieldAnalysis.setProp(tableOptColsAnalysis.getField());
            if (ToolUtil.isNotEmpty((Object)tableOptColsAnalysis.getId())) {
                editTableFieldAnalysis.setId(tableOptColsAnalysis.getId());
            } else {
                editTableFieldAnalysis.setId("");
            }
            editTableFieldAnalysis.setDataType(tableOptColsAnalysis.getDataType());
            editTableFieldAnalysis.setSort(tableOptColsAnalysis.isSort());
            editTableFieldAnalysis.setColEditComponent(tableOptColsAnalysis.getColEditComponent());
            editTableFieldAnalysis.setSelectFormat(tableOptColsAnalysis.getSelectFormat());
            editTableFieldAnalysis.setColComponent(tableOptColsAnalysis.getColComponent());
            editTableFieldAnalysis.setSelectType(tableOptColsAnalysis.getSelectType());
            editTableFieldAnalysis.setField(tableOptColsAnalysis.getField());
            editTableFieldAnalysis.setHyperlinks(tableOptColsAnalysis.getHyperlinks());
            ColWidth colWidth = tableOptColsAnalysis.getColWidth();
            if (ToolUtil.isNotEmpty((Object)colWidth) && !"0".equals(colWidth.getNumber()) && colWidth.isSelfCustom()) {
                editTableFieldAnalysis.setWidth(colWidth.getNumber());
                editTableFieldAnalysis.setIsMinWidth(colWidth.getIsMinWidth());
            }
            if (tableOptColsAnalysis.getRowSummary()) {
                RowCalculate rowCalculate = tableOptColsAnalysis.getRowCalculate();
                editTableFieldAnalysis.setRowSummary(true);
                editTableFieldAnalysis.setRowCalculate(rowCalculate);
            }
            if ("control".equals(tableOptColsAnalysis.getColEditComponent()) && !isSetControlColumn) {
                lcdpComponent.addRenderParam("isControlColumn", (Object)true);
                isSetControlColumn = true;
            }
            if (ToolUtil.isNotEmpty((Object)dataSAnalysis) && ToolUtil.isNotEmpty((Object)dataSAnalysis.getDatamodel()) && ToolUtil.isNotEmpty((Object)dataSAnalysis.getDatamodel().getFields())) {
                Map dataSFieldAnalysisMap = dataSAnalysis.getDatamodel().getFields();
                block1: for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                        List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                        if (dataItemPath.size() <= 0 || !((String)dataItemPath.get(dataItemPath.size() - 1)).equals(tableOptColsAnalysis.getId())) continue;
                        editTableFieldAnalysis.setProp(dataSFieldAnalysis.getFieldName());
                        continue block1;
                    }
                }
            }
            if (ToolUtil.isNotEmpty(showConfigAnalyses)) {
                block3: for (ShowConfigAnalysis showConfigAnalysis : showConfigAnalyses) {
                    if (!ToolUtil.isNotEmpty((Object)showConfigAnalysis.getRelations())) continue;
                    for (ShowConfigMappingAnalysis showConfigMappingAnalysis : showConfigAnalysis.getRelations()) {
                        if (!tableOptColsAnalysis.getField().equals(showConfigMappingAnalysis.getField())) continue;
                        editTableFieldAnalysis.setShowConfig(true);
                        break block3;
                    }
                }
            }
            tableFieldAnalyses.add(editTableFieldAnalysis);
        }
        return tableFieldAnalyses;
    }

    private void renderOptionLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u52a0\u8f7d\u4e0b\u62c9\u6846\u3001\u5355\u9009\u6846\u7ec4\u3001\u590d\u9009\u6846\u7ec4\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        Map renderParamsMap = lcdpComponent.getRenderParams();
        List editTableFieldAnalyses = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)renderParamsMap) && ToolUtil.isNotEmpty(renderParamsMap.get("tableShowFields"))) {
            JSONArray colsJson = JSON.parseArray((String)JSONObject.toJSONString(renderParamsMap.get("tableShowFields")));
            editTableFieldAnalyses = this.getAllColumns(colsJson).toJavaList(EditTableFieldAnalysis.class);
        }
        Map dataSAnalysis = lcdpComponent.getDatas();
        HashMap<String, String> dataColumns = new HashMap<String, String>();
        dataColumns.put("datamodelColumn", "select");
        dataColumns.put("datamodelColumnRadio", "radioGroup");
        dataColumns.put("datamodelColumnCheckbox", "checkboxGroup");
        for (String dataColumn : dataColumns.keySet()) {
            List datamodelColumnMap = (List)dataSAnalysis.get(dataColumn);
            if (!ToolUtil.isNotEmpty((Object)datamodelColumnMap) || datamodelColumnMap.size() <= 0) continue;
            for (Map stringObjectMap : datamodelColumnMap) {
                if (!ToolUtil.isNotEmpty((Object)stringObjectMap) || editTableFieldAnalyses.size() <= 0) continue;
                for (EditTableFieldAnalysis fieldAnalysis : editTableFieldAnalyses) {
                    EditTableFieldAnalysis editTableFieldAnalysis;
                    String columnField;
                    if (!ToolUtil.isNotEmpty(stringObjectMap.get("fieldId")) || !ToolUtil.isNotEmpty((Object)fieldAnalysis) || !(columnField = String.valueOf(stringObjectMap.get("fieldId"))).equals((editTableFieldAnalysis = fieldAnalysis).getId()) || !((String)dataColumns.get(dataColumn)).equals(editTableFieldAnalysis.getColEditComponent())) continue;
                    boolean isBindData = false;
                    String labelField = String.valueOf(stringObjectMap.get("selectLabel"));
                    String valueField = String.valueOf(stringObjectMap.get("selectValue"));
                    if (DataConfigConstant.CommonModelCategory.DICT.getVal().equals(stringObjectMap.get("dataModelId"))) {
                        labelField = "label";
                        valueField = "value";
                    }
                    if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)valueField)) {
                        isBindData = true;
                        HashMap selectMap = new HashMap();
                        String operationName = "hussarQuery";
                        String editTableId = lcdpComponent.getInstanceKey();
                        String apiFileName = "";
                        String apiFilePath = "";
                        String dataModelId = String.valueOf(stringObjectMap.get("dataModelId"));
                        if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                            apiFileName = this.fileMappingService.getFileName(dataModelId);
                            apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                        }
                        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                        }
                        if (DataConfigConstant.CommonModelCategory.DICT.getVal().equals(stringObjectMap.get("dataModelId"))) {
                            operationName = DataConfigConstant.CommonModelCategory.DICT.getImportMethod();
                            selectMap.put("dictType", stringObjectMap.get("dictType"));
                        } else {
                            String sortConditionName;
                            DataSConditionAnalysis dataSortConditionAnalysis;
                            String querySelectionName;
                            List conditionList;
                            DataSConditionAnalysis dataSConditionAnalysis = (DataSConditionAnalysis)JSON.parseObject((String)JSON.toJSONString(stringObjectMap.get("condition")), DataSConditionAnalysis.class);
                            if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                                selectMap.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                                selectMap.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                            }
                            if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                                operationName = operationName + querySelectionName;
                            }
                            if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = (DataSConditionAnalysis)JSON.parseObject((String)JSON.toJSONString(stringObjectMap.get("sortCondition")), DataSConditionAnalysis.class))) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                                operationName = operationName + sortConditionName;
                            }
                        }
                        selectMap.put("importName", apiFileName);
                        selectMap.put("importMethod", operationName);
                        selectMap.put("insOption", editTableId + StringUtils.capitalize((String)fieldAnalysis.getProp()) + "Options");
                        selectMap.put("label", labelField);
                        selectMap.put("value", valueField);
                        selectMap.putAll(lcdpComponent.getRenderParamsToBind());
                        ctx.addMethod(lcdpComponent.getInstanceKey() + StringUtils.capitalize((String)fieldAnalysis.getProp()) + "OptionLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_optionLoadMethod.ftl", selectMap));
                        ctx.addAsyncCreated(CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + StringUtils.capitalize((String)fieldAnalysis.getProp()) + "OptionLoad()");
                    }
                    if (isBindData) continue;
                    ctx.addMethod(lcdpComponent.getInstanceKey() + StringUtils.capitalize((String)fieldAnalysis.getProp()) + "OptionLoad", "");
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u52a0\u8f7d\u4e0b\u62c9\u6846\u3001\u5355\u9009\u6846\u7ec4\u3001\u590d\u9009\u6846\u7ec4\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private void renderReplaceData(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        LoggerUtil.printLogger((Logger)logger, (String)" -----\u6e32\u67d3vxe\u8868\u683c\u6570\u636e\u5c55\u793a\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(showConfigAnalyses)) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, showConfigAnalyses);
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos);
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            replaceDataMap.put("tableData", valueVisitor.getDataItemValue(null).getRenderValue());
            String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
            replaceDataMap.put("dataName", dataName);
            ArrayList<String> convert = new ArrayList<String>();
            convert.add("convert");
            replaceDataMap.put("strategy", ctx.getStrategy());
            ctx.addMethod("async " + lcdpComponent.getInstanceKey() + CodeSuffix._REPLACE_DATA.getType(), convert, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_replaceDataMethod.ftl", replaceDataMap).replace("this", "self"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u6570\u636e\u5c55\u793a\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private void renderEditEules(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u6570\u636e\u6821\u9a8c\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u6570\u636e\u6821\u9a8c\u53c2\u6570\uff1avalidRules------");
        }
        JSONArray validRules = (JSONArray)lcdpComponent.getProps().get("validRules");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        if (ToolUtil.isNotEmpty((Object)validRules)) {
            List editTableRulesAnalysis = JSON.parseArray((String)validRules.toJSONString(), EditTableRulesAnalysis.class);
            StringBuffer rulesData = new StringBuffer();
            rulesData.append(lcdpComponent.getInstanceKey()).append("EditRules: {");
            for (EditTableRulesAnalysis rules : editTableRulesAnalysis) {
                rulesData.append(rules.getValue()).append(": [");
                List editRulesData = rules.getEditRulesData();
                for (EditRulesData e : editRulesData) {
                    if (e.getName().equals("required")) {
                        rulesData.append("{ ").append(e.getName()).append(": true").append(',');
                    } else if (e.getName().equals("pattern") && e.getValue().contains("/")) {
                        rulesData.append("{ ").append(e.getName()).append(": ").append(e.getValue()).append(',');
                    } else {
                        rulesData.append("{ ").append(e.getName()).append(": '").append(e.getValue()).append("',");
                    }
                    if (e.getMessage().equals("")) {
                        if (e.getName().equals("required")) {
                            rulesData.append(" message: '").append("\u5185\u5bb9\u5fc5\u586b").append("'},");
                        }
                        if (e.getName().equals("max")) {
                            rulesData.append(" message: '").append("\u8d85\u51fa\u6700\u5927\u957f\u5ea6").append("'},");
                        }
                        if (e.getName().equals("min")) {
                            rulesData.append(" message: '").append("\u4f4e\u4e8e\u6700\u5c0f\u957f\u5ea6").append("'},");
                        }
                        if (e.getName().equals("pattern")) {
                            rulesData.append(" message: '").append("\u683c\u5f0f\u4e0d\u6b63\u786e").append("'},");
                        }
                        if (!e.getName().equals("type")) continue;
                        rulesData.append(" message: '").append("\u6570\u636e\u7c7b\u578b\u4e0d\u6b63\u786e").append("'},");
                        continue;
                    }
                    rulesData.append(" message: '").append(e.getMessage()).append("'},");
                }
                rulesData.append("],");
            }
            rulesData.append("},");
            ctx.addData(rulesData.toString());
            lcdpComponent.addRenderParam("editRulesFlag", (Object)true);
            ArrayList<String> callbacks = new ArrayList<String>();
            callbacks.add("callback, formCheck");
            ctx.addAsyncMethod(lcdpComponent.getInstanceKey() + "ValidEvent", callbacks, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxe_table_validate.ftl", params));
        } else {
            lcdpComponent.addRenderParam("editRulesFlag", (Object)false);
            ctx.addMethod(lcdpComponent.getInstanceKey() + "ValidEvent", "");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u6570\u636e\u6821\u9a8c\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private void componentHaveEvent(LcdpComponent lcdpComponent, Ctx ctx) {
        List triggers;
        List eventConfigs;
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u4e8b\u4ef6\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (ToolUtil.isNotEmpty((Object)(eventConfigs = lcdpComponent.getEvents()))) {
            for (EventConfig eventConfig : eventConfigs) {
                if (!"cellClick".equals(eventConfig.getTrigger())) continue;
                lcdpComponent.addRenderParam("cellClick", (Object)true);
                ArrayList<String> cellParams = new ArrayList<String>();
                ArrayList<String> cellClassParams = new ArrayList<String>();
                cellClassParams.add("cell");
                cellParams.add("{row, column}");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "CellClickInfo", cellParams, CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "CellClick(row, column.property);");
            }
        }
        if (ToolUtil.isNotEmpty((Object)(triggers = lcdpComponent.getTrigger()))) {
            triggers.clear();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u4e8b\u4ef6\u65b9\u6cd5\uff1a\u7ed3\u675f------");
        }
    }

    private void getCols(List<TableOptColsAnalysis> cols, List<TableOptColsAnalysis> realCols) {
        for (TableOptColsAnalysis col : cols) {
            boolean isNotEmptyCol = ToolUtil.isNotEmpty((Object)col);
            boolean isNotEmptyChildren = ToolUtil.isNotEmpty((Object)col.getChildren());
            if (!isNotEmptyCol) continue;
            if (isNotEmptyChildren) {
                List childrenCols = col.getChildren();
                this.getCols(childrenCols, realCols);
                continue;
            }
            realCols.add(col);
        }
    }

    private JSONArray getAllColumns(JSONArray cols) {
        JSONArray allColumns = new JSONArray();
        for (Object col : cols) {
            JSONObject colObj = (JSONObject)col;
            if (Boolean.TRUE.equals(colObj.getBoolean("isParent"))) {
                JSONArray allChildCols = this.getAllColumns(colObj.getJSONArray("children"));
                for (Object childCol : allChildCols) {
                    JSONObject childColObj = (JSONObject)childCol;
                    allColumns.add((Object)childColObj);
                }
                continue;
            }
            allColumns.add((Object)colObj);
        }
        return allColumns;
    }

    private boolean renderSortOverall(LcdpComponent lcdpComponent, Ctx ctx) {
        boolean isSortOverallFlag = false;
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u662f\u5426\u5206\u9875\u53c2\u6570\uff1avalidRules\uff0c\u83b7\u53d6\u662f\u5426\u5168\u5c40\u6392\u5e8f\u53c2\u6570\uff1aisSortOverall------");
        }
        Object isPagination = lcdpComponent.getProps().get("isPagination");
        Boolean isSortOverall = (Boolean)lcdpComponent.getProps().get("isSortOverall");
        if (ToolUtil.isNotEmpty((Object)isSortOverall) && isSortOverall.booleanValue() && ToolUtil.isNotEmpty(isPagination) && Boolean.valueOf(isPagination.toString()).booleanValue()) {
            lcdpComponent.addRenderParam("isSortChange", (Object)isSortOverall);
            isSortOverallFlag = isSortOverall;
        }
        return isSortOverallFlag;
    }

    private Boolean renderRowSpan(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u6e32\u67d3vxe\u8868\u683c\u5408\u5e76\u884c\u65b9\u6cd5\uff1a\u5f00\u59cb------");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" -----\u83b7\u53d6\u5217\u53c2\u6570\uff1aopt_cols------");
        }
        JSONArray optColsJSONObject = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        ArrayList<String> rowSpans = new ArrayList<String>();
        HashMap<String, Object> rowSpanParams = new HashMap<String, Object>();
        for (int i = 0; i < optColsJSONObject.size(); ++i) {
            if (!optColsJSONObject.getJSONObject(i).containsKey((Object)"rowSpan") || !((Boolean)optColsJSONObject.getJSONObject(i).get((Object)"rowSpan")).booleanValue()) continue;
            rowSpans.add((String)optColsJSONObject.getJSONObject(i).get((Object)"field"));
        }
        rowSpanParams.put("rowSpanParams", rowSpans);
        rowSpanParams.put("instanceKey", lcdpComponent.getInstanceKey());
        StringBuffer columnFileds = new StringBuffer();
        StringBuffer columnIndexs = new StringBuffer();
        StringBuffer elseIfColumnIndexs = new StringBuffer();
        ArrayList colParams = new ArrayList();
        for (int i = 0; i < optColsJSONObject.size(); ++i) {
            HashMap<String, Object> colParam = new HashMap<String, Object>();
            Object isRowMerge = optColsJSONObject.getJSONObject(i).get((Object)"isRowMerge");
            if (!ToolUtil.isNotEmpty((Object)isRowMerge) || !((Boolean)isRowMerge).booleanValue()) continue;
            JSONObject rowMergeFiled = (JSONObject)optColsJSONObject.getJSONObject(i).get((Object)"rowMergeFiled");
            if (((Boolean)lcdpComponent.getProps().get("showIndex")).booleanValue() && ((Boolean)lcdpComponent.getProps().get("showSelection")).booleanValue()) {
                columnIndexs.append("_columnIndex ===").append(i + 2);
                elseIfColumnIndexs.append("_columnIndex ===").append(i + 3);
            }
            if (ToolUtil.isNotEmpty((Object)rowMergeFiled)) {
                JSONArray columnData = rowMergeFiled.getJSONArray("columnData");
                for (int j = 0; j < columnData.size(); ++j) {
                    String columnFiled = columnData.get(j).toString();
                    String firstCol = columnData.get(0).toString();
                    if (j < columnData.size() && columnData.size() == 2) {
                        columnFileds.append("row.").append(columnFiled);
                        if (j < columnData.size() - 1) {
                            columnFileds.append("===");
                        }
                    } else if (j < columnData.size() && columnData.size() > 2) {
                        columnFileds.append("row.").append(firstCol).append(" === ").append("row. ").append(columnFiled);
                        if (j < columnData.size() - 1) {
                            columnFileds.append(" && ");
                        }
                        elseIfColumnIndexs.append(" || _columnIndex ===").append(i + 4);
                    }
                    lcdpComponent.addRenderParam("isRowMerge", (Object)true);
                    rowSpanParams.put("isRowMerge", true);
                }
                colParam.put("colSize", columnData.size());
            }
            colParam.put("columnFileds", columnFileds.toString());
            columnFileds.setLength(0);
            colParam.put("columnIndexs", columnIndexs.toString());
            columnIndexs.setLength(0);
            colParam.put("elseIfColumnIndexs", elseIfColumnIndexs.toString());
            elseIfColumnIndexs.setLength(0);
            colParams.add(colParam);
            rowSpanParams.put("colParams", colParams);
        }
        if (rowSpans.size() > 0) {
            lcdpComponent.addRenderParam("isRowSpan", (Object)true);
            rowSpanParams.put("isRowSpan", true);
            ArrayList<String> params = new ArrayList<String>();
            params.add("{ row, _rowIndex, _columnIndex, column, visibleData }");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "RowSpan", params, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_row_span.ftl", rowSpanParams));
        }
        if (colParams.size() > 0) {
            lcdpComponent.addRenderParam("isRowSpan", (Object)true);
            rowSpanParams.put("isRowMerge", true);
            ArrayList<String> params = new ArrayList<String>();
            params.add("{ row, _rowIndex, _columnIndex, column, visibleData }");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "RowSpan", params, RenderUtil.renderTemplate((String)"/template/elementui/element/vxeTable/vxeTable_row_span.ftl", rowSpanParams));
        }
        return rowSpans.size() > 0 || columnFileds.length() > 0;
    }
}

