/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.ClassAdapter;
import com.jxdinfo.speedcode.codegenerator.core.component.ClazzFactory;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.StyleFactory;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.speedcode.common.util.LoggerUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.elementui.visitor.element.TableVoidVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Table
extends LcdpComponent {
    protected static final Logger logger = LoggerFactory.getLogger(Table.class);

    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElTable";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elTable");
    }

    public String getAttrRenderTagName() {
        return "el-table";
    }

    public String getDefaultValue() {
        return "[]";
    }

    public VoidVisitor visitor() {
        return new TableVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pageHeight", "${prefix} .page{height:${val};text-align: center;padding: 10px 0;}");
        map.put("pageInnerHeight", "${prefix} .page .el-pagination{height:43px}");
        map.put("tHeadLineHeight", "${prefix} th{height:${val};}body,${prefix} .el-table .cell{line-height:unset;}");
        map.put("tHeadThPadding", "${prefix} thead th{padding:${val};}");
        map.put("tHeadPadding", "${prefix} thead th .cell{padding:${val};}");
        map.put("tHeadBgColor", "${prefix} .el-table .has-gutter th,${prefix} .el-table__fixed-header-wrapper th{background:${val};}");
        map.put("tHeadFontSize", "${prefix} thead th{font-size:${val};}${prefix} thead th .el-checkbox__inner{width:${val};height:${val};}${prefix} thead th .el-checkbox__inner::after{left:40%;height:70%;}");
        map.put("tHeadFontColor", "${prefix} .el-table .has-gutter th,${prefix} .el-table__fixed-header-wrapper th{color:${val};}");
        map.put("tHeadFontWeight", "${prefix} .el-table .has-gutter th,${prefix} .el-table__fixed-header-wrapper th{font-weight:${val};}");
        map.put("tBodyLineHeight", "${prefix} tbody td{height:${val};}body,${prefix} .el-table .cell{line-height:unset;}${prefix} .el-table .cell.el-tooltip{height: 17px;}${prefix} .el-table td ,${prefix} .el-table th {padding: 0 0!important;}");
        map.put("tBodyPadding", "${prefix} tbody td{padding:${val};}");
        map.put("tBodyBorderColor", "${prefix} .el-table tr td{border-bottom: 1px solid ${val};}");
        map.put("tHeadBorderXColor", "${prefix} .el-table .has-gutter th,${prefix} .el-table__fixed-header-wrapper th{border-bottom: 1px solid ${val};}");
        map.put("tHeadBorderYColor", "${prefix} .el-table .has-gutter th:not(:nth-last-of-type(1)),${prefix} .el-table__fixed-header-wrapper th:not(:nth-last-of-type(1)){border-right: 1px solid ${val};}");
        map.put("tBodyBorderXColor", "${prefix} .el-table tbody tr td{border-bottom: 1px solid ${val};}");
        map.put("tBodyBorderYColor", "${prefix} .el-table--border tbody tr td:not(:last-of-type){border-right: 1px solid ${val};}${prefix} .el-table--border{border: 0 solid ${val};}");
        map.put("tBodyOddRowBgColor", "${prefix} tbody tr:nth-of-type(odd){background:${val};}${prefix} .el-table__footer tbody tr td{background:${val};}${prefix} .el-table__footer tbody tr td:first-of-type .cell{padding:unset;}");
        map.put("tBodyEvenRowBgColor", "${prefix} tbody tr:nth-of-type(even){background:${val};}");
        map.put("tBodyFloatBgColor", "${prefix} tbody tr:hover td{background:${val};}");
        map.put("tBodyFloatBgColorFix", " ${prefix} tbody tr.hover-row td{background:${val};}");
        map.put("tBodySelectedBgColor", "${prefix} .el-table__body tr.current-row > td {background: ${val};}");
        map.put("tBodyFontSize", "${prefix} tbody td{font-size:${val};}${prefix} tbody td .el-checkbox__inner{width:${val};height:${val};}${prefix} tbody td .el-checkbox__inner::after{left:40%;height:70%;}");
        map.put("tBodyFontColor", "${prefix} tbody td{color:${val};}");
        map.put("tBodyFontWeight", "${prefix} tbody td{font-weight:${val};}");
        map.put("tBodyFloatFontColor", "${prefix} tbody tr:hover td{color:${val};}");
        map.put("tBodyFloatFontColorFix", "${prefix} tbody tr.hover-row td{color:${val};}");
        map.put("pageTextAlign", "${prefix} .page .el-pagination{text-align:${val};padding:0 20px;}");
        map.put("pageBgColor", "${prefix} .page{background:${val};}");
        map.put("pageCountBgColor", "${prefix} .page .el-pager li, ${prefix} .page .btn-prev, ${prefix} .page .btn-next{background:${val};}${prefix} .el-pagination button:disabled{background:${val} !important;}${prefix} .el-pagination .el-select .el-input .el-input__inner{background:${val};}");
        map.put("pageColor", "${prefix} .page .el-pager li{color:${val};}");
        map.put("pageBorderColor", "${prefix} .page .el-pager li{border:1px ${val} solid;}");
        map.put("pageFloatBgColor", "${prefix} .page .el-pager li.number:hover{background:${val};}");
        map.put("pageFloatBorderColor", "${prefix} .page .el-pager li.number:hover{border:1px ${val} solid;}");
        map.put("pageFloatFontColor", "${prefix} .page .el-pager li.number:hover{color:${val};}");
        map.put("pageCheckedBg", "${prefix} .page .el-pager li.number.active:not(.disabled).active{background:${val};}");
        map.put("pageCheckedColor", "${prefix} .page .el-pager li.number.active:not(.disabled).active{color:${val};}");
        map.put("pageFontColor", "${prefix} .page .el-pager li{color:${val};}");
        map.put("pageJumpMargin", "${prefix} .page .el-pagination__jump{margin-left:${val};}");
        map.put("pageTotalMargin", "${prefix} .page .el-pagination__total{margin-left:24px;}");
        map.put("selectionMargin", "${prefix} .el-table td .cell{padding-left:${val};}");
        map.put("tHeadBorderColor", "${prefix} .el-table th{border-bottom: 1px solid ${val};}");
        map.put("borderTop", "${prefix} .el-table__body tr.current-row > td {border-top: ${val};}");
        map.put("inputMaxWidth", "${prefix} .page .el-pagination .el-select .el-input .el-input__inner {max-width: ${val};}");
        map.put("divWidth", "${prefix} .page .el-pagination .el-select .el-input {width: ${val};}");
        map.put("pageVertical", "${prefix} .page .el-pagination .el-pagination__jump .el-input .el-input__inner {vertical-align: ${val};}");
        map.put("fluidHeight", "${prefix} .el-table {height: ${val};}${prefix} .el-table .el-table__body-wrapper {height: ${val};}${prefix} {height: ${val};}");
        map.put("fixTop", "${prefix} .el-table__fixed-body-wrapper {top: ${val}!important;}");
        return map;
    }

    public static Table newComponent(JSONObject jsonObject) {
        Table table = (Table)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)Table.class.getName()));
        Object backgroundImg = table.getStyles().get("backgroundImageBack");
        boolean autoHeight = table.isAutoHeight();
        table.getStyles().remove("backgroundImageBack");
        if (autoHeight) {
            table.getInnerStyles().put("fluidHeight", "auto!important");
        } else {
            table.getInnerStyles().put("fluidHeight", null);
        }
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            table.getStyles().put("backgroundImage", backgroundImg);
        }
        table.getInnerStyles().put("borderTop", "1px solid transparent");
        table.getInnerStyles().put("inputMaxWidth", "90px");
        table.getInnerStyles().put("divWidth", "auto");
        table.getInnerStyles().put("pageVertical", "middle");
        Object tBodyFloatFontColor = table.getInnerStyles().get("tBodyFloatFontColor");
        Object tBodyFloatBgColor = table.getInnerStyles().get("tBodyFloatBgColor");
        Boolean fixOperaColumn = BooleanUtils.toBoolean((String)String.valueOf(table.getProps().get("fixOperaColumn")));
        Boolean needOperationFixed = BooleanUtils.toBoolean((String)String.valueOf(table.getProps().get("needOperationFixed")));
        Boolean fixFlag = false;
        JSONArray cols = (JSONArray)table.getProps().get("opt_cols");
        List tableOptColsAnalyses = JSON.parseArray((String)cols.toJSONString(), TableOptColsAnalysis.class);
        for (TableOptColsAnalysis tableOptColsAnalysis : tableOptColsAnalyses) {
            if (!ToolUtil.isNotEmpty((Object)tableOptColsAnalysis.getFixed()) || !tableOptColsAnalysis.getFixed().getFixed().booleanValue()) continue;
            fixFlag = true;
            break;
        }
        LoggerUtil.printLogger((Logger)logger, (String)"\u6839\u636e\u8868\u683c\u56fa\u5b9a\u5217\u52a8\u6001\u751f\u6210\u6837\u5f0f\u4ee3\u7801");
        if (fixOperaColumn.booleanValue() || fixFlag.booleanValue() || needOperationFixed.booleanValue()) {
            if (ToolUtil.isNotEmpty(tBodyFloatFontColor)) {
                table.getInnerStyles().remove("tBodyFloatFontColor");
                table.getInnerStyles().put("tBodyFloatFontColorFix", tBodyFloatFontColor.toString());
            }
            if (ToolUtil.isNotEmpty(tBodyFloatBgColor)) {
                table.getInnerStyles().remove("tBodyFloatBgColor");
                table.getInnerStyles().put("tBodyFloatBgColorFix", tBodyFloatBgColor.toString());
            }
        } else {
            table.getInnerStyles().remove("tBodyFloatBgColorFix");
            table.getInnerStyles().remove("tBodyFloatFontColorFix");
        }
        return table;
    }
}

