/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.ClassAdapter;
import com.jxdinfo.speedcode.codegenerator.core.component.ClazzFactory;
import com.jxdinfo.speedcode.codegenerator.core.component.InteractiveClassFactory;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.StyleFactory;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.elementui.comm.TextAlignForVertical;
import com.jxdinfo.speedcode.elementui.visitor.element.ButtonVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class Button
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElButton";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)":disabled");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elButton");
    }

    public VoidVisitor visitor() {
        return new ButtonVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("buttonMarginLeft", "${prefix} {margin-left:${val};}");
        map.put("buttonFontSize", "${prefix} {font-size:${val};}");
        map.put("fontFamily", "${prefix} {font-family:${val};}");
        map.put("fontSize", "${prefix} span *{font-size:${val};}");
        map.put("fontWeight", "${prefix} {font-weight:${val};}");
        map.put("fontStyle", "${prefix} {font-style:${val};}");
        map.put("textDecoration", "${prefix} {text-decoration:${val};}");
        map.put("color", "${prefix} {color:${val};}");
        map.put("lineHeight", "${prefix} {line-height:${val};}");
        map.put("textAlign", "${prefix} {text-align:${val};}");
        map.put("iconMarginLeft", "${prefix} span i{margin-left:${val};}");
        map.put("itemAlign", "${prefix} > span {align-items:${val};}");
        map.put("itemJustifyContent", "${prefix} > span {justify-content:${val};}");
        map.put("itemDisplay", "${prefix} > span {display:${val};}");
        return map;
    }

    public static Button newComponent(JSONObject jsonObject) {
        Button button = (Button)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)Button.class.getName()));
        Object backgroundImg = button.getStyles().get("backgroundImageBack");
        button.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            button.getStyles().put("backgroundImage", backgroundImg);
        }
        TextAlignForVertical.setTextAlign(button, "innerStyles");
        Boolean isRightActive = (Boolean)button.getProps().get("isRightActive");
        if (ToolUtil.isNotEmpty((Object)isRightActive) && isRightActive.booleanValue()) {
            button.getInnerStyles().put("iconMarginLeft", "5px");
        }
        button.getInnerStyles().put("buttonMarginLeft", "0");
        button.getInnerStyles().put("buttonFontSize", 0);
        button.addClassName("button_additional");
        return button;
    }
}

