/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.provide;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.common.analysismodel.form.FormColsAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElForm.value")
@Scope(value="prototype")
public class FormValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        ArrayList<String> formDataItem = new ArrayList<String>();
        formDataItem.add("data");
        String formRenderValue = ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._FORM_DATA.getType(), formDataItem);
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() == 2) {
            JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (!colObj.getString("id").equals(dataItems.get(1))) continue;
                data.setRenderValue(formRenderValue + "." + colObj.getString("field"));
                data.setDataType(((JSONObject)col).getString("dataType"));
            }
        } else {
            data.setRenderValue(formRenderValue);
            data.setDataType(ComponentData.DataTypeEnum.OBJECT);
        }
        return data;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._FORM_DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        JSONArray cols = (JSONArray)this.lcdpComponent.getProps().get("component_cols");
        List formColsList = cols.toJavaList(FormColsAnalysis.class);
        HashMap<String, String> map = new HashMap<String, String>(16);
        formColsList.forEach(col -> map.put(col.getId(), col.getField()));
        return map;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "''";
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return null;
    }
}

