/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.provide;

import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.speedcode.common.analysismodel.dataitem.reference.QuoteBO;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentDataUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElFileEcho.value")
@Scope(value="prototype")
public class FileEchoValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public String getDefaultValue() {
        return null;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> multiChoiceMapping = new HashMap<String, String>();
        multiChoiceMapping.put("label", "label");
        multiChoiceMapping.put("value", "value");
        multiChoiceMapping.put("delSuccess", "delSuccess");
        return multiChoiceMapping;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        QuoteBO quoteBO;
        ComponentData quoteData;
        ComponentDataUtil.ComponentValueStatusEnum dataItemValueStatus = ComponentDataUtil.getComponentValueStatus((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, Collections.singletonList("data"));
        if (ComponentDataUtil.ComponentValueStatusEnum.QUOTE.equals((Object)dataItemValueStatus) && ToolUtil.isNotEmpty((Object)(quoteData = DataConfigUtil.getDataConfigValue((Ctx)this.ctx, (ComponentReference)(quoteBO = ComponentDataUtil.getComponentDataItemQuote((LcdpComponent)this.lcdpComponent, Collections.singletonList("data"))).getComponentQuote())))) {
            return Collections.singletonList(new ComponentData(quoteData.getDataType(), ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("data"))));
        }
        ArrayList<String> valueItem = new ArrayList<String>();
        valueItem.add("value");
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.ARRAY_PRIMARY, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._FILEUPLOAD_COPY.getType(), valueItem)));
    }

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            if ("data".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getMultiData();
                }
                String data = dataItems.get(1);
                if ("value".equals(data)) {
                    return this.getValueData();
                }
                if ("label".equals(data)) {
                    return this.getLabelData();
                }
                if ("securityLabel".equals(data)) {
                    return this.getSecurityLabelData();
                }
                if ("securityValue".equals(data)) {
                    return this.getSecurityValueData();
                }
            } else if ("delSuccess".equals(dataItem)) {
                return new ComponentData(ComponentData.DataTypeEnum.BOOLEAN, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._FILE_DELSUCCESS.getType(), Collections.singletonList("delSuccess")));
            }
        }
        ArrayList<String> valueItem = new ArrayList<String>();
        valueItem.add("data");
        return new ComponentData(ComponentData.DataTypeEnum.ARRAY_PRIMARY, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._VALUE_DATA.getType(), valueItem));
    }

    private ComponentData getMultiData() throws LcdpException {
        ComponentData multiData = new ComponentData();
        ArrayList<String> multiDataItem = new ArrayList<String>();
        multiDataItem.add("data");
        multiData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        multiData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._MULTI_DATA.getType(), multiDataItem));
        return multiData;
    }

    private ComponentData getMultiValueData() throws LcdpException {
        ComponentData multiValueData = new ComponentData();
        multiValueData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        multiValueData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._VALUE_DATA.getType(), Collections.singletonList("data")));
        return multiValueData;
    }

    private ComponentData getMultiLabelData() throws LcdpException {
        ComponentData multiLabelData = new ComponentData();
        multiLabelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        multiLabelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        String valueData = this.getMultiValueData().getRenderValue();
        multiLabelData.setRenderValue("function(){\nlet result = [];\n" + valueData + ".forEach((item) => {if(" + valueData + ".length > 0){\nresult.push(item.securityLevelLabel);\n}\n});\nreturn result;}()");
        return multiLabelData;
    }

    private ComponentData getSecurityValueData() throws LcdpException {
        ComponentData multiLabelData = new ComponentData();
        multiLabelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        multiLabelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        String valueData = this.getMultiValueData().getRenderValue();
        multiLabelData.setRenderValue("function(){\nlet result = [];\n" + valueData + ".forEach((item) => {if(" + valueData + ".length > 0){\nresult.push(item.securityLevel);\n}\n});\nreturn result;}()");
        return multiLabelData;
    }

    private ComponentData getSecurityLabelData() throws LcdpException {
        ComponentData multiLabelData = new ComponentData();
        multiLabelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        multiLabelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        String valueData = this.getMultiValueData().getRenderValue();
        multiLabelData.setRenderValue("function(){\nlet result = [];\n" + valueData + ".forEach((value) => {if(" + valueData + ".length > 0){\nlet securityLevelLabel = '';" + CodePrefix._SELF.getType() + "degreeList.forEach((item) => {\n                  if (item.value == value.securityLevel) {\n                    securityLevelLabel = item.label;\n                  }\n                })\nresult.push(securityLevelLabel);\n}\n});\nreturn result;}()");
        return multiLabelData;
    }

    private ComponentData getValueData() throws LcdpException {
        ComponentData multiLabelData = new ComponentData();
        multiLabelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        multiLabelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        String valueData = this.getMultiValueData().getRenderValue();
        multiLabelData.setRenderValue("function(){\nlet result = [];\n" + valueData + ".forEach((item) => {if(" + valueData + ".length > 0){\nresult.push(item.id);\n}\n});\nreturn result;}()");
        return multiLabelData;
    }

    private ComponentData getLabelData() throws LcdpException {
        ComponentData multiLabelData = new ComponentData();
        multiLabelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        multiLabelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        String valueData = this.getMultiValueData().getRenderValue();
        multiLabelData.setRenderValue("function(){\nlet result = [];\n" + valueData + ".forEach((item) => {if(" + valueData + ".length > 0){\nresult.push(item.attachmentName);\n}\n});\nreturn result;}()");
        return multiLabelData;
    }
}

