/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.EventConfig;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.tree.TreeNodeIcon;
import com.jxdinfo.speedcode.common.analysismodel.tree.TreeRelativeDataAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TreeVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        List triggers = lcdpComponent.getTriggers();
        lcdpComponent.registerTemplatePath("/template/elementui/element/tree/el_tree.ftl");
        lcdpComponent.addRenderParam("triggers", (Object)triggers);
        lcdpComponent.addRenderParam("id", (Object)lcdpComponent.getInstanceKey());
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderDataLoad(lcdpComponent, ctx);
        this.renderContextMenu(lcdpComponent, ctx);
        this.renderEvent(lcdpComponent, ctx);
        this.renderRefresh(lcdpComponent, ctx);
        this.renderCascadeDelete(lcdpComponent, ctx);
        this.renderTreeNodeMove(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("data"), (String)"[]");
        lcdpComponent.addRenderParam("data", (Object)valueData);
        String root = String.valueOf(lcdpComponent.getProps().get("root"));
        lcdpComponent.addRenderParam("root", (Object)root);
        ctx.addData(lcdpComponent.getInstanceKey() + "CheckedData:[]");
        JSONArray iconJSONArray = (JSONArray)lcdpComponent.getProps().get("iconList");
        if (ToolUtil.isNotEmpty((Object)iconJSONArray)) {
            List nodeIconList = JSON.parseArray((String)iconJSONArray.toJSONString(), TreeNodeIcon.class);
            String data = " [";
            for (int i = 0; i < nodeIconList.size(); ++i) {
                TreeNodeIcon treeNodeIcon = (TreeNodeIcon)nodeIconList.get(i);
                data = data + "{\n            nodeType: '" + treeNodeIcon.getNodeType() + "',\n            icon: '" + treeNodeIcon.getIconClassName() + "',\n          },";
            }
            data = data + "]";
            ctx.addData(lcdpComponent.getInstanceKey() + "IconList:" + data);
        } else {
            ctx.addData(lcdpComponent.getInstanceKey() + "IconList:[]");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.forEach((k, v) -> ctx.addData(k + ":" + v + ","));
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderDataLoad(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        ArrayList<String> rootDataArray = new ArrayList<String>();
        rootDataArray.add("datas");
        rootDataArray.add("rootDataArray");
        ArrayList<String> checkedDataArray = new ArrayList<String>();
        checkedDataArray.add("data");
        checkedDataArray.add("checked");
        boolean isBindData = false;
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
            Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
            String idField = "";
            String labelField = "";
            String pidField = "";
            String levelNameField = "";
            String sortField = "";
            String relativeDataField = "";
            HashMap<String, String> relativeDataModel = new HashMap<String, String>();
            if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                        List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                        JSONArray relativeData = (JSONArray)lcdpComponent.getProps().get("relativeData");
                        if (ToolUtil.isNotEmpty((Object)relativeData)) {
                            List relativeDataAnalysis = JSON.parseArray((String)relativeData.toJSONString(), TreeRelativeDataAnalysis.class);
                            for (int i = 0; i < relativeDataAnalysis.size(); ++i) {
                                TreeRelativeDataAnalysis treeRelativeDataAnalysis = (TreeRelativeDataAnalysis)relativeDataAnalysis.get(i);
                                String id = treeRelativeDataAnalysis.getId();
                                String field = treeRelativeDataAnalysis.getField();
                                if (!ToolUtil.isNotEmpty((Object)field) || !ToolUtil.isNotEmpty((Object)id) || !ToolUtil.isNotEmpty((Object)dataItemPath) || dataItemPath.size() < 2 || !id.equals(dataItemPath.get(1))) continue;
                                relativeDataModel.put(field, dataSFieldAnalysis.getFieldName());
                            }
                        }
                        if (ToolUtil.isNotEmpty((Object)dataItemPath) && "label".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                            labelField = dataSFieldAnalysis.getFieldName();
                        }
                        if (ToolUtil.isNotEmpty((Object)dataItemPath) && "id".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                            idField = dataSFieldAnalysis.getFieldName();
                        }
                        if (ToolUtil.isNotEmpty((Object)dataItemPath) && "pid".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                            pidField = dataSFieldAnalysis.getFieldName();
                        }
                        if (ToolUtil.isNotEmpty((Object)dataItemPath) && "levelName".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                            levelNameField = dataSFieldAnalysis.getFieldName();
                        }
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"sort".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                        sortField = dataSFieldAnalysis.getFieldName();
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)labelField) && ToolUtil.isNotEmpty((Object)idField)) {
                String sortConditionName;
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                isBindData = true;
                lcdpComponent.addRenderParam("HandleCheckChange", (Object)true);
                HashMap<String, Object> treeMap = new HashMap<String, Object>();
                String operationName = "hussarQuery";
                String dataTreeId = lcdpComponent.getInstanceKey();
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                    treeMap.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    treeMap.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                    operationName = operationName + sortConditionName;
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                treeMap.put("importName", apiFileName);
                treeMap.put("importMethod", operationName);
                treeMap.put("insData", dataTreeId + CodeSuffix._DATA.getType());
                treeMap.put("label", labelField);
                treeMap.put("tid", idField);
                treeMap.put("pid", pidField);
                treeMap.put("sort", sortField);
                treeMap.put("rootData", lcdpComponent.getInstanceKey() + "RootDataLoad");
                treeMap.put("childrenData", lcdpComponent.getInstanceKey() + "ChildrenDataLoad");
                treeMap.put("checkedData", lcdpComponent.getInstanceKey() + "CheckedData");
                treeMap.put("hasCheckNode", this.hasCheckNode(lcdpComponent));
                treeMap.put("levelName", levelNameField);
                treeMap.put("relativeData", relativeDataField);
                treeMap.put("relativeDataModel", relativeDataModel);
                treeMap.putAll(lcdpComponent.getRenderParamsToBind());
                treeMap.put("strategy", ctx.getStrategy());
                String pidQueryObjName = String.valueOf(lcdpComponent.getProps().get("pidQueryObjName"));
                if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("lazy")) && ((Boolean)lcdpComponent.getProps().get("lazy")).booleanValue() && ToolUtil.isNotEmpty((Object)pidQueryObjName) && !"".equals(pidQueryObjName)) {
                    String[] queryAttrToList;
                    lcdpComponent.addRenderParam("isQueryqueryCondition", (Object)true);
                    StringBuilder queryAttr = (StringBuilder)treeMap.get("queryAttr");
                    StringBuilder queryAttrClone = new StringBuilder();
                    for (String s : queryAttrToList = String.valueOf(queryAttr).split(",")) {
                        if (s.contains(pidQueryObjName)) {
                            queryAttrClone.append(pidQueryObjName).append(": node.data.id,");
                            continue;
                        }
                        queryAttrClone.append(s);
                    }
                    treeMap.put("lazyQueryAttr", queryAttrClone.toString());
                }
                ArrayList<String> loadNodeArray = new ArrayList<String>();
                loadNodeArray.add("node");
                loadNodeArray.add("resolve");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "LoadNode", loadNodeArray, RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_LoadNodeMethod.ftl", treeMap));
                ArrayList<String> callbacks = new ArrayList<String>();
                callbacks.add("callback");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "TreeDataLoad", callbacks, RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_dataLoadMethod.ftl", treeMap));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "RootDataLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_rootDataLoadMethod.ftl", treeMap));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "ChildrenDataLoad", rootDataArray, RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_childrenDataLoadMethod.ftl", treeMap));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleCheckChange", checkedDataArray, RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_handleNodeClickMethod.ftl", treeMap));
            }
        }
        if (!isBindData) {
            ArrayList<String> args = new ArrayList<String>(1);
            args.add("callback");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "TreeDataLoad", args, "// \u6811\u672a\u7ed1\u5b9a\u6570\u636e\u6a21\u578b\uff0c\u8be5\u52a8\u4f5c\u672a\u6210\u529f\u751f\u6210\nif(callback && typeof callback === 'function') {callback();}");
        }
    }

    private boolean hasCheckNode(LcdpComponent lcdpComponent) {
        boolean hasCheckNode = false;
        List eventConfigs = lcdpComponent.getEvents();
        if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
            for (EventConfig eventConfig : eventConfigs) {
                if (!"nodeCheck".equals(eventConfig.getTrigger())) continue;
                hasCheckNode = true;
                break;
            }
        }
        return hasCheckNode;
    }

    private void renderEvent(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        List triggers;
        List eventConfigs = lcdpComponent.getEvents();
        if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
            boolean hasNodeClickMethod = false;
            boolean hasRootNodeClickMethod = false;
            for (EventConfig eventConfig : eventConfigs) {
                if ("nodeClick".equals(eventConfig.getTrigger())) {
                    hasNodeClickMethod = true;
                    continue;
                }
                if ("nodeCheck".equals(eventConfig.getTrigger())) {
                    lcdpComponent.addRenderParam("nodeCheck", (Object)true);
                    continue;
                }
                if (!"rootNodeClick".equals(eventConfig.getTrigger())) continue;
                hasRootNodeClickMethod = true;
            }
            if (hasNodeClickMethod || hasRootNodeClickMethod) {
                if (hasNodeClickMethod) {
                    ctx.addData(lcdpComponent.getInstanceKey() + "ClickNode:''");
                    lcdpComponent.getTriggers().remove("nodeClick");
                }
                lcdpComponent.addRenderParam("node_click", (Object)true);
                ArrayList<String> dataArray = new ArrayList<String>();
                dataArray.add("data");
                dataArray.add("node");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", lcdpComponent.getInstanceKey());
                params.put("nodeClick", hasNodeClickMethod);
                params.put("rootNodeClick", hasRootNodeClickMethod);
                ctx.addMethod(lcdpComponent.getInstanceKey() + "ClickNodeDataInit", dataArray, RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_nodeClick.ftl", params));
            }
        }
        if (ToolUtil.isNotEmpty((Object)(triggers = lcdpComponent.getTrigger()))) {
            triggers.clear();
        }
    }

    private void renderContextMenu(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        boolean showContextMenu = false;
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("showContextMenu"))) {
            showContextMenu = (Boolean)lcdpComponent.getProps().get("showContextMenu");
        }
        if (showContextMenu) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            String id = lcdpComponent.getInstanceKey();
            idMap.put("id", id);
            ctx.getRootLcdpComponent().addSlotCodes("treeContextMenu", RenderUtil.renderTemplate((String)"/template/elementui/element/tree/el_tree-menu.ftl", idMap));
            ctx.addComputed(id + "HasShowMenu", RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_hasShowMenu.ftl", idMap));
            ctx.addData(id + "StyleObj:{}");
            ctx.addData(id + "MenuVisible:false");
            ctx.addData(id + "ContextMenuNode:null");
            HashMap<String, String> menuMap = new HashMap<String, String>();
            menuMap.put("id", id);
            JSONArray menuJSONArray = (JSONArray)lcdpComponent.getProps().get("menus");
            if (ToolUtil.isNotEmpty((Object)menuJSONArray)) {
                for (Object menu : menuJSONArray) {
                    JSONObject menuObj = (JSONObject)menu;
                    if (null != menuObj.get((Object)"isShow") && !"".equals(menuObj.get((Object)"isShow"))) continue;
                    menuObj.put("isShow", (Object)"true");
                }
                menuMap.put("menus", (String)menuJSONArray);
            }
            ctx.addData(RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_contextMenuData.ftl", menuMap));
            ArrayList<String> dataArray = new ArrayList<String>();
            dataArray.add("event");
            dataArray.add("data");
            dataArray.add("node");
            ctx.addMethod(id + "NodeContextMenu", dataArray, RenderUtil.renderTemplate((String)"/template/elementui/element/tree/tree_nodeContextMenuMethod.ftl", idMap));
            ctx.addMethod(id + "HideMenu", CodePrefix._SELF.getType() + id + "MenuVisible = false;");
        }
    }

    private void renderRefresh(LcdpComponent lcdpComponent, Ctx ctx) throws IOException, LcdpException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("instanceKey", lcdpComponent.getInstanceKey());
        ctx.addMethod(lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)"treeRefresh"), new ArrayList<String>(Arrays.asList("label", "currentNode", "currentData", "callback")), RenderUtil.renderTemplate((String)"/template/elementui/event/tree/treeRefresh.ftl", paramMap));
        ctx.addMethod(lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)"treeLazyLoad"), new ArrayList<String>(Collections.singletonList("node")), RenderUtil.renderTemplate((String)"/template/elementui/event/tree/treeLazyLoad.ftl", paramMap));
    }

    private void renderCascadeDelete(LcdpComponent lcdpComponent, Ctx ctx) throws IOException, LcdpException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("strategy", ctx.getStrategy());
        DataSAnalysis dataAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        String dataModelId = Optional.ofNullable(dataAnalysis.getDatamodel()).orElseGet(DataSModelAnalysis::new).getDataModelId();
        if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
            paramMap.put("importName", this.fileMappingService.getFileName(dataModelId));
            paramMap.put("importMethod", "del");
        }
        paramMap.put("instanceKey", lcdpComponent.getInstanceKey());
        ctx.addMethod(lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)"treeCascadeDelete"), new ArrayList<String>(Arrays.asList("label", "currentNode", "currentData", "callback")), RenderUtil.renderTemplate((String)"/template/elementui/event/tree/treeCascadeDelete.ftl", paramMap));
        ctx.addMethod(lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)"cascadeDeleteIds"), new ArrayList<String>(Arrays.asList("currentData", "nodeDeleteIds")), RenderUtil.renderTemplate((String)"/template/elementui/event/tree/cascadeDeleteIds.ftl", paramMap));
    }

    private void renderTreeNodeMove(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("strategy", ctx.getStrategy());
        if (ToolUtil.isEmpty((Object)lcdpComponent.getDatas())) {
            return;
        }
        DataSAnalysis dataAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataModelAnalysis = Optional.ofNullable(dataAnalysis.getDatamodel()).orElseGet(DataSModelAnalysis::new);
        String dataModelId = dataModelAnalysis.getDataModelId();
        if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
            paramMap.put("importName", this.fileMappingService.getFileName(dataModelId));
            paramMap.put("importMethod", "insertOrUpdate");
        }
        HashMap changeSortMap = new HashMap(2);
        Map fieldAnalysisMap = Optional.ofNullable(dataModelAnalysis.getFields()).orElseGet(HashMap::new);
        fieldAnalysisMap.forEach((fieldName, fieldAnalysisList) -> {
            if (Optional.ofNullable(fieldAnalysisList).isPresent() && fieldAnalysisList.size() > 0) {
                DataSFieldAnalysis fieldAnalysis = (DataSFieldAnalysis)Optional.of(fieldAnalysisList).orElseGet(ArrayList::new).get(0);
                List dataItemPath = Optional.ofNullable(fieldAnalysis.getDataItemPath()).orElseGet(ArrayList::new);
                if (dataItemPath.size() > 1 && "id".equals(dataItemPath.get(1))) {
                    changeSortMap.put("id", fieldAnalysis.getFieldName());
                }
                if (dataItemPath.size() > 1 && "sort".equals(dataItemPath.get(1))) {
                    changeSortMap.put("sort", fieldAnalysis.getFieldName());
                }
            }
        });
        paramMap.put("changeSortMap", changeSortMap);
        paramMap.put("instanceKey", lcdpComponent.getInstanceKey());
        ctx.addMethod(lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)"treeMoveOn"), new ArrayList<String>(Arrays.asList("label", "currentNode", "currentData", "callback")), RenderUtil.renderTemplate((String)"/template/elementui/event/tree/treeMoveOn.ftl", paramMap));
        ctx.addMethod(lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)"treeMoveDown"), new ArrayList<String>(Arrays.asList("label", "currentNode", "currentData", "callback")), RenderUtil.renderTemplate((String)"/template/elementui/event/tree/treeMoveDown.ftl", paramMap));
        ctx.addMethod(lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)"currentNodes"), new ArrayList<String>(Arrays.asList("nodes", "currentData", "currentNodes")), RenderUtil.renderTemplate((String)"/template/elementui/event/tree/treeCurrentNodes.ftl", paramMap));
    }
}

