/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.speedcode.codegenerator.core.action.EventConfig;
import com.jxdinfo.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.speedcode.codegenerator.core.constant.TriggerType;
import com.jxdinfo.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.speedcode.common.constant.CodePrefix;
import com.jxdinfo.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.speedcode.common.exception.LcdpException;
import com.jxdinfo.speedcode.common.file.FileMappingService;
import com.jxdinfo.speedcode.common.util.FileUtil;
import com.jxdinfo.speedcode.common.util.LoggerUtil;
import com.jxdinfo.speedcode.common.util.RenderUtil;
import com.jxdinfo.speedcode.common.util.SpringUtil;
import com.jxdinfo.speedcode.common.util.ToolUtil;
import com.jxdinfo.speedcode.common.utils.ComponentDataUtil;
import com.jxdinfo.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.speedcode.common.utils.EventUtil;
import com.jxdinfo.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.speedcode.common.utils.ReplaceDataUtil;
import com.jxdinfo.speedcode.util.datamodel.DataModelUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTableVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);
    private static final Logger logger = LoggerFactory.getLogger(TreeTableVoidVisitor.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        boolean existBorderY = lcdpComponent.getProps().containsKey("borderY");
        if (!existBorderY) {
            lcdpComponent.getProps().put("borderY", true);
        }
        Integer size = (Integer)lcdpComponent.getProps().get("pageSize");
        lcdpComponent.addRenderParam("size", (Object)size);
        lcdpComponent.registerTemplatePath("/template/elementui/element/treeTable/el_table.ftl");
        this.renderTableCol(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.componentHaveEvent(lcdpComponent, ctx);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderRowSpan(lcdpComponent, ctx);
    }

    public void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)"[]");
        lcdpComponent.addAttr(CodePrefix._DATA.getType(), valueData);
        String dataArrayStr = RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_data.ftl", (Map)lcdpComponent.getRenderParamsToBind());
        ctx.addData(dataArrayStr);
    }

    public void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        Boolean isRadio;
        JSONArray optColsJSONObject;
        JSONArray allColumns;
        Map columnCalculateMap;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        StringBuilder rowCalculateColumnContact = new StringBuilder();
        Map rowCalculateMap = (Map)lcdpComponent.getProps().get("rowCalculate");
        if (ToolUtil.isNotEmpty((Object)rowCalculateMap) && ToolUtil.isNotEmpty(rowCalculateMap.get("columnData"))) {
            ctx.addData(lcdpComponent.getInstanceKey() + "RowCalculateColumn:" + rowCalculateMap.get("columnData"));
            List rowCalculateColumn = (List)rowCalculateMap.get("columnData");
            if (rowCalculateColumn.size() > 0) {
                for (int i = 0; i < rowCalculateColumn.size(); ++i) {
                    rowCalculateColumnContact.append("const ").append('p').append(i + 1).append(" = ").append("Number(this.$numeral(row[this.").append(lcdpComponent.getInstanceKey()).append("RowCalculateColumn[").append(i).append("]]).format('").append((Object)("".equals(rowCalculateMap.get("format")) ? "0.00" : rowCalculateMap.get("format"))).append("'))").append(";\n");
                }
            }
        }
        params.put("rowCalculateColumnContact", rowCalculateColumnContact);
        if (ToolUtil.isNotEmpty((Object)rowCalculateMap)) {
            params.put("rowCalculateFormula", rowCalculateMap.get("formula"));
            params.put("unit", rowCalculateMap.get("unit"));
            params.put("format", rowCalculateMap.get("format"));
        }
        if (ToolUtil.isNotEmpty((Object)(columnCalculateMap = (Map)lcdpComponent.getProps().get("columnCalculate")))) {
            params.put("columnCalculateMap", columnCalculateMap);
            List fileds = (List)columnCalculateMap.get("columnFields");
            if (ToolUtil.isNotEmpty((Object)fileds) && fileds.size() > 0) {
                String dataArrayStr = RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_assignmentData.ftl", params);
                ctx.addData(dataArrayStr);
            }
        }
        ArrayList<String> selectRow = new ArrayList<String>();
        selectRow.add("data");
        ArrayList<String> handleSizeChange = new ArrayList<String>();
        handleSizeChange.add("pageSize");
        ArrayList<String> handleCurrentChange = new ArrayList<String>();
        handleCurrentChange.add("currentPage");
        List eventConfigs = lcdpComponent.getEvents();
        if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
            for (EventConfig eventConfig : eventConfigs) {
                if ("rowSelection".equals(eventConfig.getTrigger())) {
                    params.put("rowSelection", true);
                }
                if (!"rowSelectionChange".equals(eventConfig.getTrigger())) continue;
                params.put("rowSelectionChange", true);
            }
        }
        params.put("isRadio", lcdpComponent.getProps().get("isRadio"));
        ctx.addImports("import * as _ from 'lodash'");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "SelectRow", selectRow, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_selectRowMethod.ftl", params));
        Object isPagination = lcdpComponent.getProps().get("isPagination");
        if (ToolUtil.isNotEmpty(isPagination) && Boolean.valueOf(isPagination.toString()).booleanValue()) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleSizeChange", handleSizeChange, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_handleSizeChangeMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleCurrentChange", handleCurrentChange, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_handleCurrentChangeMethod.ftl", params));
        }
        if (ToolUtil.isNotEmpty((Object)(allColumns = this.getAllColumns(optColsJSONObject = (JSONArray)lcdpComponent.getProps().get("opt_cols"))))) {
            List tableOptColsAnalyses = JSON.parseArray((String)allColumns.toJSONString(), TableOptColsAnalysis.class);
            for (int i = 0; i < tableOptColsAnalyses.size(); ++i) {
                Map hyperlinks = ((TableOptColsAnalysis)tableOptColsAnalyses.get(i)).getHyperlinks();
                if (!ToolUtil.isNotEmpty((Object)hyperlinks) || !ToolUtil.isNotEmpty(hyperlinks.get("fileId"))) continue;
                if (ToolUtil.isNotEmpty(hyperlinks.get("jumpType"))) {
                    params.put("jumpType", hyperlinks.get("jumpType"));
                }
                String id = String.valueOf(hyperlinks.get("fileId"));
                String routerPath = null;
                if (ToolUtil.isNotEmpty((Object)id)) {
                    routerPath = FileUtil.posixPath((String[])new String[]{"/", "${tenantCommon.appRoutePrefix}", this.fileMappingService.getFormatPath(id)});
                }
                params.put("url", routerPath);
                HashMap<String, String> paramConfig = new HashMap<String, String>();
                Map pageParamConfig = (Map)hyperlinks.get("pageParamConfig");
                Set pageParamSet = pageParamConfig.keySet();
                HashMap optColsFieldMap = new HashMap();
                ArrayList<String> pageKeyList = new ArrayList<String>();
                block3: for (String key : pageParamSet) {
                    pageKeyList.add("row");
                    Map pageParam = (Map)pageParamConfig.get(key);
                    JSONArray instanceData = (JSONArray)pageParam.get("instanceData");
                    String instanceKey = String.valueOf(pageParam.get("instanceKey"));
                    LcdpComponent hyperlinksLcdp = (LcdpComponent)ctx.getComponentMap().get(instanceKey);
                    if (ToolUtil.isNotEmpty((Object)hyperlinksLcdp) && hyperlinksLcdp.getName().indexOf("JXDElTreeTable") >= 0) {
                        JSONArray hyperlinksLcdpOptCols = (JSONArray)hyperlinksLcdp.getProps().get("opt_cols");
                        List hyperlinksLcdpOptColsAnalyses = JSON.parseArray((String)hyperlinksLcdpOptCols.toJSONString(), TableOptColsAnalysis.class);
                        JSONArray hyperlinksLcdpHiddenCols = (JSONArray)hyperlinksLcdp.getProps().get("hidden_cols");
                        List hyperlinksLcdpHiddenColsAnalyses = JSON.parseArray((String)hyperlinksLcdpHiddenCols.toJSONString(), TableOptColsAnalysis.class);
                        for (TableOptColsAnalysis t : hyperlinksLcdpOptColsAnalyses) {
                            if (!t.getId().equals(instanceData.getString(1))) continue;
                            optColsFieldMap.put(key, "row." + t.getField());
                            break;
                        }
                        for (TableOptColsAnalysis t : hyperlinksLcdpHiddenColsAnalyses) {
                            if (!t.getId().equals(instanceData.getString(1))) continue;
                            optColsFieldMap.put(key, "row." + t.getField());
                            continue block3;
                        }
                        continue;
                    }
                    ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)pageParamConfig.get(key).toString(), ComponentReference.class);
                    ComponentData paramData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                    if (null != paramData) {
                        paramConfig.put(key, paramData.getRenderValue());
                        continue;
                    }
                    paramConfig.put(key, "''");
                }
                params.put("params", optColsFieldMap);
                if (ToolUtil.isNotEmpty(paramConfig)) {
                    String paramStr = "";
                    Object[] keySet = paramConfig.keySet().toArray();
                    for (int j = 0; j < keySet.length; ++j) {
                        JSONObject ppcElement = (JSONObject)pageParamConfig.get(keySet[j]);
                        if (j == keySet.length - 1) {
                            if (ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant")) {
                                paramStr = paramStr + keySet[j] + "=" + paramConfig.get(keySet[j]).toString().replaceAll("'", "");
                                continue;
                            }
                            paramStr = paramStr + keySet[j] + "=${" + paramConfig.get(keySet[j]) + "}";
                            continue;
                        }
                        paramStr = ppcElement.get((Object)"type").equals("input") || ppcElement.get((Object)"type").equals("constant") ? paramStr + keySet[j] + "=" + paramConfig.get(keySet[j]).toString().replaceAll("'", "") + "&" : paramStr + keySet[j] + "=${" + paramConfig.get(keySet[j]) + "}&";
                    }
                    params.put("paramStr", paramStr);
                }
                params.put("paramConfig", paramConfig);
                params.put("strategy", ctx.getStrategy());
                ctx.addMethod(lcdpComponent.getInstanceKey() + ((TableOptColsAnalysis)tableOptColsAnalyses.get(i)).getField() + "CLICK", pageKeyList, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_hyperlinksMethod.ftl", params));
            }
        }
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"showConfigs");
        this.renderTableLoad(lcdpComponent, ctx, showConfigAnalyses);
        this.renderReplaceData(lcdpComponent, ctx, showConfigAnalyses);
        this.renderTableInit(lcdpComponent, ctx, showConfigAnalyses);
        ArrayList<String> handleColumnSummaryEvent = new ArrayList<String>();
        handleColumnSummaryEvent.add("{ columns, data }");
        if (ToolUtil.isNotEmpty(lcdpComponent.getInnerStyles().get("tBodyLineHeight"))) {
            String tBodyLineHeight = String.valueOf(lcdpComponent.getInnerStyles().get("tBodyLineHeight"));
            int bodyLineHeight = Integer.parseInt(tBodyLineHeight.substring(0, tBodyLineHeight.length() - 2));
            params.put("bodyLineHeight", bodyLineHeight);
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("columnSummary")) && ((Boolean)lcdpComponent.getProps().get("columnSummary")).booleanValue()) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "ColumnSummaryEvent", handleColumnSummaryEvent, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_getColSummaryMethod.ftl", params));
            ctx.addWatch("'" + (String)lcdpComponent.getAttrs().get(":data") + "'", RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/tree_table_column_summary_watch.ftl", params));
        }
        if (ToolUtil.isNotEmpty((Object)(isRadio = (Boolean)lcdpComponent.getProps().get("isRadio"))) && isRadio.booleanValue()) {
            ArrayList<String> selection = new ArrayList<String>();
            selection.add("selection");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "Select", selection, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_selectMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "SelectAll", selection, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_selectAllMethod.ftl", params));
        }
        ArrayList<String> param = new ArrayList<String>();
        param.add("data");
        param.add("id");
        Boolean isSingleSelect = (Boolean)lcdpComponent.getProps().get("isSingleSelect");
        if (ToolUtil.isNotEmpty((Object)isSingleSelect) && isSingleSelect.booleanValue()) {
            ArrayList<String> selection = new ArrayList<String>();
            selection.add("selection");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "SingleSelectRow", selection, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_singleSelectRowMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "Traverse", param, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/TreeTableSelectRowMethod.ftl", params));
        }
        String idField = "";
        String pidField = "";
        JSONArray hiddenCols = (JSONArray)lcdpComponent.getProps().get("hidden_cols");
        for (Object col : hiddenCols) {
            JSONObject colObj = (JSONObject)col;
            if (colObj.getString("id").equals("jxd-tree-table-fix-id")) {
                idField = colObj.getString("field");
            }
            if (!colObj.getString("id").equals("jxd-tree-table-fix-pid")) continue;
            pidField = colObj.getString("field");
        }
        String root = String.valueOf(lcdpComponent.getProps().get("root"));
        lcdpComponent.addRenderParam("pid", (Object)pidField);
        lcdpComponent.addRenderParam("rowKey", (Object)idField);
        params.put("root", root);
        params.put("pid", pidField);
        params.put("rowKey", idField);
        ArrayList<String> parameter = new ArrayList<String>();
        parameter.add("datas");
        parameter.add("rootDataArray");
        if (ToolUtil.isNotEmpty((Object)pidField) && ToolUtil.isNotEmpty((Object)idField)) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "RootDataLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/treeTable_rootDataLoadMethod.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "ChildrenDataLoad", parameter, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/treeTable_childrenDataLoadMethod.ftl", params));
        }
    }

    public void renderTableInit(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        HashMap<String, Object> tableInitMap = new HashMap<String, Object>();
        tableInitMap.put("instanceKey", lcdpComponent.getInstanceKey());
        ArrayList<String> valueItem = new ArrayList<String>();
        valueItem.add("value");
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, valueItem))) {
            tableInitMap.put("referenceData", "exist");
        }
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.get(0).isConfigComplete()) {
            tableInitMap.put("replaceData", true);
            LcdpComponent editTableIns = (LcdpComponent)ctx.getComponentMap().get(lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)editTableIns.getProvideVisitor("value");
            valueVisitor.visit(editTableIns, ctx, null);
            String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
            tableInitMap.put("dataName", dataName);
        }
        ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._TABLE_INTI.getType(), RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/initTable.ftl", tableInitMap));
    }

    public void renderTableLoad(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        List eventConfigs;
        boolean isShowConfig;
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        String operationName = "hussarQuery";
        String dataTableId = lcdpComponent.getInstanceKey();
        String apiFileName = "";
        String apiFilePath = "";
        String idField = "";
        String pidField = "";
        StringBuilder queryAttr = new StringBuilder(128);
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            Object isPagination;
            String sortConditionName;
            DataSortConditionAnalysis dataSortConditionAnalysis;
            Object dataSConditionAnalysis;
            String dataModelId = dataSModelAnalysis.getDataModelId();
            if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                apiFileName = this.fileMappingService.getFileName(dataModelId);
                apiFilePath = this.fileMappingService.getImportPath(dataModelId);
            }
            if (ToolUtil.isNotEmpty((Object)(dataSConditionAnalysis = dataSModelAnalysis.getCondition()))) {
                List conditionList = dataSConditionAnalysis.getQueryConditionModelList();
                queryAttr = QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx);
                String querySelectionName = dataSConditionAnalysis.getSelectCondition();
                if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                    operationName = operationName + querySelectionName;
                }
            }
            if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                operationName = operationName + sortConditionName;
            }
            if (ToolUtil.isNotEmpty(isPagination = lcdpComponent.getProps().get("isPagination")) && Boolean.valueOf(isPagination.toString()).booleanValue()) {
                operationName = operationName + CodeSuffix._TABLE_PAGE_SUFFIX.getType();
            }
        }
        JSONArray hiddenCols = (JSONArray)lcdpComponent.getProps().get("hidden_cols");
        for (Object col : hiddenCols) {
            JSONObject colObj = (JSONObject)col;
            if (colObj.getString("id").equals("jxd-tree-table-fix-id")) {
                idField = colObj.getString("field");
            }
            if (!colObj.getString("id").equals("jxd-tree-table-fix-pid")) continue;
            pidField = colObj.getString("field");
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
        }
        tableMap.put("importName", apiFileName);
        tableMap.put("importMethod", operationName);
        tableMap.put("instanceKey", dataTableId);
        tableMap.put("queryAttr", queryAttr);
        tableMap.put("pid", pidField);
        tableMap.put("rowKey", idField);
        tableMap.putAll(lcdpComponent.getRenderParamsToBind());
        Optional<ShowConfigAnalysis> showConfig = Optional.ofNullable(showConfigAnalyses).map(analyse -> (ShowConfigAnalysis)analyse.get(0));
        boolean isDataModelIdPresent = showConfig.map(DataSModelAnalysis::getDataModelId).isPresent();
        boolean isFieldPresent = showConfig.map(ShowConfigAnalysis::getField).isPresent();
        boolean isRelateFieldPresent = showConfig.map(ShowConfigAnalysis::getRelateField).isPresent();
        boolean bl = isShowConfig = isDataModelIdPresent && isFieldPresent && isRelateFieldPresent;
        if (isShowConfig) {
            tableMap.put("isShowConfig", true);
        }
        if (lcdpComponent.haveTriggerByTriggerName(TriggerType._TABLE_LOADED.getType())) {
            tableMap.put("isLoadedEvent", true);
        }
        if (ToolUtil.isNotEmpty((Object)(eventConfigs = lcdpComponent.getEvents()))) {
            for (EventConfig eventConfig : eventConfigs) {
                if (!"rowSelectionChange".equals(eventConfig.getTrigger())) continue;
                tableMap.put("rowSelectionChange", true);
            }
        }
        ArrayList<String> callbacks = new ArrayList<String>();
        callbacks.add("callback");
        LcdpComponent editTableIns = (LcdpComponent)ctx.getComponentMap().get(lcdpComponent.getInstanceKey());
        ValueVisitor valueVisitor = (ValueVisitor)editTableIns.getProvideVisitor("value");
        valueVisitor.visit(editTableIns, ctx, null);
        String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
        tableMap.put("dataName", dataName);
        tableMap.put("strategy", ctx.getStrategy());
        ctx.addMethod(lcdpComponent.getInstanceKey() + "TableLoad", callbacks, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_tableLoadMethod.ftl", tableMap));
    }

    private void renderTableCol(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        JSONArray optColsJSONArray = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        lcdpComponent.addRenderParam("tableShowFields", (Object)optColsJSONArray);
    }

    public void renderReplaceData(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        LoggerUtil.printLogger((Logger)logger, (String)"-----\u6811\u578b\u8868\u683c\u6570\u636e\u5c55\u793a\u66ff\u6362-----");
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.get(0).isConfigComplete()) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, showConfigAnalyses);
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos);
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            replaceDataMap.put("tableData", valueVisitor.getDataItemValue(null).getRenderValue());
            String dataName = valueVisitor.getDataItemValue(null).getRenderValue();
            replaceDataMap.put("dataName", dataName);
            ArrayList<String> convert = new ArrayList<String>();
            convert.add("convert");
            replaceDataMap.put("strategy", ctx.getStrategy());
            ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._REPLACE_DATA.getType(), convert, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_replaceDataMethod.ftl", replaceDataMap).replace("this", "self"));
        }
    }

    private void componentHaveEvent(LcdpComponent lcdpComponent, Ctx ctx) {
        List triggers;
        List eventConfigs = lcdpComponent.getEvents();
        if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("data");
            boolean click = false;
            boolean dbclick = false;
            for (EventConfig eventConfig : eventConfigs) {
                if ("colClick".equals(eventConfig.getTrigger())) {
                    lcdpComponent.addRenderParam("colClick", (Object)true);
                    click = true;
                }
                if ("dblClick".equals(eventConfig.getTrigger())) {
                    dbclick = true;
                    lcdpComponent.addRenderParam("dblClick", (Object)true);
                }
                if (!"cellClick".equals(eventConfig.getTrigger())) continue;
                lcdpComponent.addRenderParam("cellClick", (Object)true);
                ArrayList<String> cellParams = new ArrayList<String>();
                ArrayList<String> cellClassParams = new ArrayList<String>();
                cellClassParams.add("cell");
                cellParams.add("data");
                cellParams.add("ref");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "CellClickInfo", cellParams, CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "CellClick(data, ref.property);");
                try {
                    ctx.addMethod(lcdpComponent.getInstanceKey() + "CellClassNAme", cellClassParams, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_cell_class_name.ftl", (Map)JSON.parseObject((String)JSON.toJSONString((Object)eventConfig))));
                }
                catch (LcdpException e) {
                    e.printStackTrace();
                }
            }
            if (click && dbclick) {
                ctx.addData(lcdpComponent.getInstanceKey() + "TimeOut: ''");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "ColClickFront", params, "        clearTimeout(" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "TimeOut);\n" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "TimeOut = setTimeout(() => {\n" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "ColClick(data)\n        }, 350);");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "DblClickFront", params, "        clearTimeout(" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "TimeOut);\n" + CodePrefix._SELF.getType() + lcdpComponent.getInstanceKey() + "DblClick(data);");
            }
        }
        if (ToolUtil.isNotEmpty((Object)(triggers = lcdpComponent.getTrigger()))) {
            triggers.clear();
        }
    }

    private JSONArray getAllColumns(JSONArray cols) {
        JSONArray allColumns = new JSONArray();
        for (Object col : cols) {
            JSONObject colObj = (JSONObject)col;
            if (Boolean.TRUE.equals(colObj.getBoolean("isParent"))) {
                JSONArray allChildCols = this.getAllColumns(colObj.getJSONArray("children"));
                for (Object childCol : allChildCols) {
                    JSONObject childColObj = (JSONObject)childCol;
                    allColumns.add((Object)childColObj);
                }
                continue;
            }
            allColumns.add((Object)colObj);
        }
        return allColumns;
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealDisabledAttr(lcdpComponent, ctx);
        dealFormDataVisitor.dealReadonlyAttr(lcdpComponent, ctx);
        Map props = lcdpComponent.getProps();
        Boolean hiddenValue = props.get("hidden") != null ? props.get("hidden") : Boolean.valueOf(false);
        ctx.addData(lcdpComponent.getInstanceKey() + "Hidden: " + hiddenValue);
    }

    private Boolean renderRowSpan(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        JSONArray optColsJSONObject = (JSONArray)lcdpComponent.getProps().get("opt_cols");
        ArrayList<String> rowSpans = new ArrayList<String>();
        HashMap<String, Object> rowSpanParams = new HashMap<String, Object>();
        for (int i = 0; i < optColsJSONObject.size(); ++i) {
            if (!optColsJSONObject.getJSONObject(i).containsKey((Object)"rowSpan") || !((Boolean)optColsJSONObject.getJSONObject(i).get((Object)"rowSpan")).booleanValue()) continue;
            rowSpans.add((String)optColsJSONObject.getJSONObject(i).get((Object)"field"));
        }
        rowSpanParams.put("rowSpanParams", rowSpans);
        rowSpanParams.put("instanceKey", lcdpComponent.getInstanceKey());
        if (rowSpans.size() > 0) {
            lcdpComponent.addRenderParam("isRowSpan", (Object)true);
            ArrayList<String> params = new ArrayList<String>();
            params.add("{ row, column, rowIndex, columnIndex }");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "RowSpan", params, RenderUtil.renderTemplate((String)"/template/elementui/element/treeTable/table_row_span.ftl", rowSpanParams));
        }
        return rowSpans.size() > 0;
    }
}

