<#--定义列递归宏-->
<#macro editTree list>
    <#list list! as item>
        <#if (item.isParent?? && item.isParent!)>
            <vxe-table-colgroup align="${item.bodyAlign!}"
                              header-align="${item.align!}"
                              title="${item.label!}"
                    <#if item.width??>width="${item.width!}"</#if>
            >
                <@editTree list = item.children></@editTree>
            </vxe-table-colgroup>
        <#else>
            <#if item.rowSummary?? && item.rowSummary>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  <#if item.width??>
                                      <#if item.isMinWidth?? && item.isMinWidth!>
                                          :min-width = "${item.width!}"
                                      <#else>
                                          width="${item.width!}"
                                      </#if>
                                  <#else>
                                      <#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if>
                                  </#if>
                                  title="${item.label!}"
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        >
                <#if item.rowCalculate??>
                <template v-slot="{ row }">
                    <span class="vxe-cell--label">{{$numeral(${item.rowCalculate.editFormulaReplace!}).format('${item.rowCalculate.format!}')}}</span>
                </template>
                </#if>
                </vxe-table-column>
            <#elseif item.isShowConfig?? && item.isShowConfig!>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  <#if item.width??>
                                      <#if item.isMinWidth?? && item.isMinWidth!>
                                          :min-width = "${item.width!}"
                                      <#else>
                                          width="${item.width!}"
                                      </#if>
                                  <#else>
                                      <#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if>
                                  </#if>
                                  title="${item.label!}"
                                  <#if item.width??>width="${item.width!}"</#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        >
                <template v-slot="{ row }">
                    <span class="vxe-cell--label">{{row.${item.prop!}}}</span>
                </template>
                </vxe-table-column>
            <#else>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  title="${item.label!}"
                                  <#if item.width??>
                                      <#if item.isMinWidth?? && item.isMinWidth!>
                                          :min-width = "${item.width!}"
                                      <#else>
                                          width="${item.width!}"
                                      </#if>
                                  <#else>
                                      <#if item.label?? && item.label?length gt 0>:min-width="${item.label?length * 14 + 40}"</#if>
                                  </#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#--可编辑列-->
                        <#if item.colEditComponent! != '' && item.colEditComponent! !='empty'>
                            :edit-render="{
                                immediate: true,
                                <#--输入框-->
                                <#if item.colEditComponent! == 'input' || item.colEditComponent! == 'dialog'>
                                name: 'input',
                                attrs: {type: 'text'},
                                <#--数字框-->
                                <#elseif item.colEditComponent! == 'number'>
                                name: '$input',
                                props: {type: 'number'},
                                <#--日期-->
                                <#elseif item.colEditComponent! == 'date'>
                                name: '$input',
                                props:{type:'<#if item.selectFormat??>${item.selectFormat.dateFmtSelect!}</#if>'},
                                <#--下拉框-->
                                <#elseif item.colEditComponent! == 'select'>
                                name: '$select',
                                props: {type: 'select'},
                                options: ${instanceKey!}${item.prop!?cap_first}Options,
                                <#else >
                                </#if>
                                events: {
                                <#--合计行触发事件-->
                                <#if columnSummary?? && columnSummary>
                                input: ${instanceKey!}UpdateFooterEvent,
                                </#if>
                                <#--数据展示替换-->
                                <#if item.showConfig?? && item.showConfig>
                                change: ${instanceKey!}ReplaceData,
                                </#if>
                                <#--列弹框展示-->
                                <#if item.colEditComponent! == 'dialog'>
                                    focus: ${instanceKey!}${item.prop?cap_first}EditEvent,
                                </#if>
                                }
                              }"
                        </#if>>
                        <#if (!isOpenEdit || item.colEditComponent! == 'empty') && item.hyperlinks??>
                        <template slot-scope="scope">
                            <span class="jxd_hyperlinks_span" @click="${instanceKey!}${item.field!}CLICK(scope.row)"> {{scope.row.${item.field!}}}</span>
                        </template>
                        </#if>
                        <#if item.colComponent! == 'date'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $moment(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.dateFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                        <#elseif item.colComponent! == 'number'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $numeral(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                        <#else>
                        </#if>
                </vxe-table-column>
            </#if>
        </#if>
    </#list>
</#macro>
<div ref="${instanceKey!}Ref"<#if isPagination?? && isPagination> class="pagination_vxe_table"</#if>>
    <vxe-table auto-resize
        <#if isAutoWrap?? && isAutoWrap!>
            :scroll-y="{enabled: false}" :scroll-x="{enabled: false}"
        <#else >show-overflow
        </#if>
        <#if isColumnDrag?? && isColumnDrag!>
            resizable
        </#if>
        <#if isRadio?? && isRadio!>
            :radio-config="{ checkMethod: ${instanceKey!}Selectable }"
        <#else>
            :checkbox-config="{ range: true<#if crossPageSelect?? && crossPageSelect!>, reserve: true</#if>, checkMethod: ${instanceKey!}Selectable, strict:  ${instanceKey!}Disabled }"
        </#if>
        keep-source
        <#--列表loading-->
        :loading="${instanceKey!}TableLoading"
        <#--列表边框-->
        <#if borderStyle??>
            :border="${instanceKey!}BorderStyle"
        </#if>
        <#if editRulesFlag?? && editRulesFlag>
            :edit-rules="${instanceKey!}EditRules"
        </#if>
        <#--表格高度（分页）-->
<#--        <#if isPagination?? && isPagination>-->
<#--            <#if tableHeight??>-->
<#--                height="${tableHeight!}"-->
<#--            </#if>-->
<#--        <#else >:height="'100%'"-->
<#--        </#if>-->
        <#if tableHeight??>
            height="${tableHeight!}"
        </#if>
        <#if cellClick?? && cellClick>
            @cell-click="${instanceKey!}CellClickInfo"
        </#if>
        ref="${instanceKey!}TableRef"
        <#--单击触发可编辑-->
        <#if isOpenEdit?? && isOpenEdit>
            <#if isKeepSource?? && isKeepSource>
                :edit-config="{trigger: 'click', mode: 'cell'<#if isDisabled??>, activeMethod: ${instanceKey!}ActiveRowMethod</#if>, showStatus:true, showUpdateStatus:true, showInsertStatus:true}"
            <#else >
                :edit-config="{trigger: 'click', mode: 'cell'<#if isDisabled??>, activeMethod: ${instanceKey!}ActiveRowMethod</#if>}"
            </#if>
        </#if>
        <#--合计行方法-->
        <#if columnSummary?? && columnSummary>
            show-footer
            :footer-method="${instanceKey!}ColumnSummaryEvent"
        </#if>
        <#--选择项变化-->
        <#if showSelection?? && showSelection>
        <#if isRadio?? && isRadio!>
            @radio-change="${instanceKey!}SelectRow"
        <#else>
            @checkbox-change="${instanceKey!}SelectRow"
            @checkbox-all="${instanceKey!}SelectAll"
        </#if>
        </#if>
        <#if columnStyle?? && columnStyle>
            :cell-style="${instanceKey!}CellStyle"
        </#if>
        <#if crossPageSelect?? && crossPageSelect!>
            row-id="${rowId!"id"}"
        </#if>
        <#--单击触发高亮行-->
        <#if isHighlightColumn?? && isHighlightColumn>
            highlight-hover-column highlight-current-column
        </#if>
        <#--单击触发右键菜单-->
        <#if isTableMenu?? && isTableMenu>
            :menu-config="${instanceKey!}TableMenu"
            @menu-click="${instanceKey!}ContextMenuClickEvent"
        </#if>
        <#if isSortChange?? && isSortChange>
                @sort-change="${instanceKey!}SortChange"
                :sort-config="{remote: true}"
        </#if>
        <#if isRowSpan?? && isRowSpan>
            :span-method="${instanceKey!}RowSpan"
        </#if>
        <#--单击触发数据状态-->
        <#if isKeepSource?? && isKeepSource>
            keep-source
        </#if>
    >
        <#--列表选择框-->
        <#if showSelection?? && showSelection>
            <vxe-table-column align="center" type="<#if isRadio?? && isRadio!>radio<#else>checkbox</#if>" :width="50"></vxe-table-column>
        </#if>
        <#--列表序号列-->
        <#if showIndex?? && showIndex>
            <vxe-table-column align="center" title="序号" type="seq" width="<#if indexWidth??><#if indexWidth ?is_number>${indexWidth!}<#else>${indexWidth.localValue!}</#if><#else>60</#if>"></vxe-table-column>
        </#if>
        <#--列表列-->
        <@editTree list= tableShowFields!></@editTree>
        <#--操作列-->
        <#if needOperation?? && needOperation>
            <vxe-table-column
                    align="center"
                    header-align="center"
                    <#if !(needOperationAutoWidth?? && needOperationAutoWidth!)>
                        :width="<#if needOperationWidth?? && needOperationWidth! != 0>${needOperationWidth!}<#else>140</#if>"
                    </#if>
                    label="<#if needOperationName??>${needOperationName!}<#else>操作</#if>"
                     show-overflow="ellipsis">
                <template slot-scope="scope">
                    <#if needOperations??>
                        <div style="text-align: center;width: 100%;">
                            <#list needOperations as item>
                            <el-tooltip placement="top" content="${item.label!}" transition="">
                                <#if item.label="还原">
                                    <el-button size="mini" v-if="!$refs.${instanceKey!}TableRef.isInsertByRow(scope.row)" style="margin: 0;float: unset;<#if item.bg??>background: ${item.bg!};</#if><#if item.borderColor??>border-color: ${item.borderColor!};</#if><#if item.color??>color: ${item.color!}</#if>" @click.native.stop="${instanceKey!}${item.eventName?cap_first}(scope.row)">${item.label}</el-button>
                                <#else >
                                    <el-button size="mini" style="margin: 0;float: unset;<#if item.bg??>background: ${item.bg!};</#if><#if item.borderColor??>border-color: ${item.borderColor!};</#if><#if item.color??>color: ${item.color!}</#if>" @click.native.stop="${instanceKey!}${item.eventName?cap_first}(scope.row)">${item.label!}</el-button>
                                </#if>
                            </el-tooltip>
                            </#list>
                        </div>
                    </#if>
                </template>
            </vxe-table-column>
        </#if>
    </vxe-table>
    <#if isPagination?? && isPagination>
        <div class="page" v-show="!${instanceKey!}PageHidden">
            <el-pagination
                    background
                    @size-change="${instanceKey!}HandleSizeChange"
                    @current-change="${instanceKey!}HandleCurrentChange"
                    :page-size="${ListQuery!}.size"
                    <#if size?? && size! lt 10>
                        :page-sizes="[${size?c!}, 10, 20, 50]"
                    <#elseif size?? && size! gt 10 && size! lt 20>
                        :page-sizes="[10, ${size?c!}, 20, 50]"
                    <#elseif size?? && size! gt 20 && size! lt 50>
                        :page-sizes="[10, 20, ${size?c!}, 50]"
                    <#elseif size?? && size! gt 50>
                        :page-sizes="[10, 20, 50, ${size?c!}]"
                    </#if>
                    <#if (layout??)>
                        :layout="${instanceKey!}Layout"
                    </#if>
                    :total="${TableTotal!}"
                    :current-page.sync="${instanceKey!}CurrentPage">
            </el-pagination>
        </div>
    </#if>
<#--    <#if isPagination?? && isPagination!>-->
<#--        <vxe-pager-->
<#--                   <#if hasDataSAnalysis?? && hasDataSAnalysis!>-->
<#--                        @page-change="${instanceKey!}PageSizeChange"-->
<#--                   </#if>-->
<#--                   :layouts="${instanceKey!}Layout"-->
<#--                   :total="${instanceKey!}TableTotal"-->
<#--                   :current-page="${instanceKey!}ListQuery.current"-->
<#--                   v-show="!${instanceKey!}PageHidden"-->
<#--                    <#if tablePage?? && pageSize?? && pageSize! lt 10>-->
<#--                            :page-sizes="[${pageSize?c!}, 10, 20, 50]"-->
<#--                    <#elseif tablePage?? && pageSize?? && pageSize! gt 10 && pageSize! lt 20>-->
<#--                            :page-sizes="[10, ${pageSize?c!}, 20, 50]"-->
<#--                    <#elseif tablePage?? && pageSize?? && pageSize! gt 20 && pageSize! lt 50>-->
<#--                            :page-sizes="[10, 20, ${pageSize?c!}, 50]"-->
<#--                    <#elseif tablePage?? && pageSize?? && pageSize! gt 50>-->
<#--                            :page-sizes="[10, 20, 50, ${pageSize?c!}]"-->
<#--                    <#else>-->
<#--                            :page-sizes="[10, 20, 50]"-->
<#--                    </#if>-->
<#--                   :page-size="${instanceKey!}ListQuery.size">-->
<#--        </vxe-pager>-->
<#--    </#if>-->
<#if hasSortTableOverall??>
    ${hasSortTableOverall!}
</#if>
</div>