<#--定义宏递归生成表头-->
<#macro colTree colList>
    <#list colList as item>
    <#--是否为多级表头-->
        <#if item.isParent??>
        <el-table-column label="${item.title!}" header-align="${item.align!}">
            <@colTree colList=item.children></@colTree>
        </el-table-column>
        <#elseif item.rowSummary?? && item.rowSummary>
            <el-table-column label="${item.title!}"
                    prop="${item.field!}"
                    <#if (item.sort?? && item.sort!) && (isSortChange?? && isSortChange)>
                            sortable="custom"
                    <#elseif (item.sort?? && item.sort!)>
                            sortable
                    </#if>
                    <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                        <#if (item.fixed.left?? && item.fixed.left)>
                            fixed="left"
                        <#else>
                            fixed="right"
                        </#if>
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                        <#if (item.colWidth.isMinWidth??) && (item.colWidth.isMinWidth!)>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            :min-width="${item.colWidth.number!}"
                            </#if>
                        <#else>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            width="${item.colWidth.number!}"
                            </#if>
                        </#if>
                    </#if>
                     align="${item.bodyAlign!}"
                     header-align="${item.align!}">
                <#if item.rowCalculate??>
                <template slot-scope="scope">
                    {{$numeral(${item.rowCalculate.formulaReplace}).format('${item.rowCalculate.format}')}}
                </template>
                </#if>
            </el-table-column>
        <#else>
            <el-table-column
                    prop="${item.field!}"
                    label="${item.title!}"
                    <#if (item.sort?? && item.sort!) && (isSortChange?? && isSortChange)>
                            sortable="custom"
                    <#elseif (item.sort?? && item.sort!)>
                            sortable
                    </#if>
                    <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                        <#if (item.fixed.left?? && item.fixed.left)>
                            fixed="left"
                        <#else>
                            fixed="right"
                        </#if>
                    </#if>
                    <#if (item.colWidth.selfCustom!)>
                        <#if (item.colWidth.isMinWidth??) && (item.colWidth.isMinWidth!)>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            :min-width="${item.colWidth.number!}"
                            </#if>
                        <#else>
                            <#if item.colWidth.number?? &&item.colWidth.number! != 0>
                            width="${item.colWidth.number!}"
                            </#if>
                        </#if>
                    </#if>
                    align="${item.bodyAlign!}"
                    header-align="${item.align!}" :show-overflow-tooltip=true>
                <#if item.field == "">
                    <template>
                    <#if item.eventList?? && item.eventList.isNeedAction?? && item.eventList.isNeedAction!>
                        <span class="jxd_hyperlinks_span" @click="${instanceKey!}${item.eventList.eventName?cap_first}"></span>
                    <#else>
                        <#if item.hyperlinks?? && item.hyperlinks.fileId?? && item.hyperlinks.fileId! != "">
                            <span @click="${instanceKey!}${item.field!}CLICK"></span>
                        <#else>
                        </#if>
                    </#if>
                    </template>
                <#else>
                    <template slot-scope="scope">
                        <#if  item.eventList?? && item.eventList.isNeedAction?? && item.eventList.isNeedAction!>
                            <span class="jxd_hyperlinks_span" @click="${instanceKey!}${item.eventList.eventName?cap_first}(scope.row)">
                            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                                {{(scope.row.${item.field!}) ? $moment(scope.row.${item.field!}).format('${item.selectType.dateFmtSelect!}') : '--'}}
                            <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                {{(scope.row.${item.field!}) ? $numeral(scope.row.${item.field!}).format('${item.selectType.numberFmtSelect!}') : '--'}}
                            <#else>
                                {{scope.row.${item.field!}}}
                            </#if>
                            </span>
                        <#elseif item.hyperlinks?? && item.hyperlinks.fileId?? && item.hyperlinks.fileId! != "">
                            <span class="jxd_hyperlinks_span" @click="${instanceKey!}${item.field!}CLICK(scope.row)">
                            <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                                {{(scope.row.${item.field!}) ? $moment(scope.row.${item.field!}).format('${item.selectType.dateFmtSelect!}') : '--'}}
                            <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                                {{(scope.row.${item.field!}) ? $numeral(scope.row.${item.field!}).format('${item.selectType.numberFmtSelect!}') : '--'}}
                            <#else>
                                {{scope.row.${item.field!}}}
                            </#if>
                            </span>
                        <#elseif item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
                            {{(scope.row.${item.field!}) ? $moment(scope.row.${item.field!}).format('${item.selectType.dateFmtSelect!}') : '--'}}
                        <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
                            {{(scope.row.${item.field!}) ? $numeral(scope.row.${item.field!}).format('${item.selectType.numberFmtSelect!}') : '--'}}
                        <#else>
                            {{scope.row.${item.field!}}}
                        </#if>
                    </template>
                </#if>

            </el-table-column>
        </#if>
    </#list>
</#macro>
<div v-show="!${instanceKey}Hidden">
    <el-table
            <#--列表loading-->
            v-loading="${instanceKey!}TableLoading"
            <#--列表边框-->
            <#if borderY?? && borderY>
                :border="${instanceKey!}BorderY"
            </#if>
            <#--表格高度（分页）-->
            <#if isPagination?? && isPagination>
                :height="'calc(100% - 53px)'"
            <#else >
                :height="'100%'"
            </#if>
            <#--列表合计-->
            <#if columnSummary?? && columnSummary>
                :summary-method="${instanceKey!}ColumnSummaryEvent"
                show-summary
            </#if>
            <#--选择项变化-->
            <#if crossPageSelect?? && crossPageSelect>
                @select="${instanceKey!}SelectRow" @select-all="${instanceKey!}SelectAll"
            <#else>
                @selection-change="${instanceKey!}SelectRow"
            </#if>
            <#--是否复选框只能选择一个-->
            ref="${instanceKey!}TableRef"
            <#if isRadio?? && isRadio!>
                 @select="${instanceKey!}Select" @select-all="${instanceKey!}SelectAll"
            </#if>
            <#--行单选，选中后该行高亮-->
            <#if isSingleSelect?? && isSingleSelect!>
                highlight-current-row @current-change="${instanceKey!}SingleSelectRow"
            </#if>
            <#--单双击耦合 增加额外计算时间方法-->
            <#if (colClick?? && colClick!) && dblClick?? && dblClick!>
                @row-click="${instanceKey!}ColClickFront"
                @row-dblclick="${instanceKey!}DblClickFront"
            <#else>
                <#--单击事件-->
                <#if colClick?? && colClick>
                    @row-click="${instanceKey!}ColClick"
                </#if>
                <#--双击事件-->
                <#if dblClick?? && dblClick>
                    @row-dblclick="${instanceKey!}DblClick"
                </#if>
            </#if>
            <#if cellClick?? && cellClick>
                @cell-click="${instanceKey!}CellClickInfo"
                :cell-class-name="${instanceKey!}CellClassNAme"
            </#if>
            <#if columnStyle?? && columnStyle>
                :cell-style="${instanceKey!}CellStyle"
            </#if>
            <#if isSortChange?? && isSortChange>
                @sort-change="${instanceKey!}SortChange"
            </#if>
            <#if isRowSpan?? && isRowSpan>
                :span-method="${instanceKey!}RowSpan"
            </#if>
    >
        <#--列表选择框-->
        <#if showSelection?? && showSelection>
            <el-table-column type="selection" :width="50" align="center">
            </el-table-column>
        </#if>
        <#--列表序号列-->
        <#if showIndex?? && showIndex>
            <el-table-column type="index" <#if fixOperaColumn?? && fixOperaColumn>fixed="left"</#if> label="序号" :width="<#if indexWidth??><#if indexWidth ?is_number>${indexWidth!}<#else>${indexWidth.localValue!}</#if><#else>60</#if>" align="center">
            </el-table-column>
        </#if>
        <#--列表列-->
        <@colTree colList=tableShowFields!></@colTree>
        <#if tableShowFields?? && tableShowFields?size == 0>
            <el-table-column></el-table-column>
        </#if>
        <#--操作列-->
        <#if needOperation?? && needOperation>
            <el-table-column
                 align="center"
                 header-align="center"
                 <#if (needOperationFixed?? && needOperationFixed)>
                     fixed="right"
                 </#if>
                 <#if !(needOperationAutoWidth?? && needOperationAutoWidth!)>
                     :width="<#if needOperationWidth?? && needOperationWidth! != 0>${needOperationWidth!}<#else>140</#if>"
                 </#if>
                 label="<#if needOperationName??>${needOperationName!}<#else>操作</#if>">
                <template slot-scope="scope">
                    <#if needOperations??>
                    <div style="text-align: center;width: 100%;">
                    <#list needOperations as item>
                       <el-button size="mini" style="margin: 0;float: unset;<#if item.bg??>background: ${item.bg!};</#if><#if item.borderColor??>border-color: ${item.borderColor!};</#if><#if item.color??>color: ${item.color!}</#if>" @click.native.stop="${instanceKey!}${item.eventName?cap_first}(scope.row)">${item.label!}</el-button>
                    </#list>
                    </div>
                    </#if>
                </template>
            </el-table-column>
        </#if>
        <#--合计行-->
        <#if rowSummary?? && rowSummary>
            <el-table-column align="${rowCalculate.align!}" label="合计">
                <template slot-scope="scope">
                    <span>{{ ${instanceKey!}RowSummaryEvent(scope.row) }} ${rowCalculate.unit!}</span>
                </template>
            </el-table-column>
        </#if>
    </el-table>
    <#--分页组件-->
    <#if isPagination?? && isPagination>
        <div class="page" v-show="!${instanceKey!}PageHidden">
            <el-pagination
                background
                @size-change="${instanceKey!}HandleSizeChange"
                @current-change="${instanceKey!}HandleCurrentChange"
                :page-size="${ListQuery!}.size"
                <#if size?? && size! lt 10>
                :page-sizes="[${size?c!}, 10, 20, 50]"
                <#elseif size?? && size! gt 10 && size! lt 20>
                :page-sizes="[10, ${size?c!}, 20, 50]"
                <#elseif size?? && size! gt 20 && size! lt 50>
                :page-sizes="[10, 20, ${size?c!}, 50]"
                <#elseif size?? && size! gt 50>
                :page-sizes="[10, 20, 50, ${size?c!}]"
                </#if>
                <#if (layout??)>
                    :layout="${instanceKey!}Layout"
                </#if>
                :total="${TableTotal!}"
                :current-page.sync="${instanceKey!}CurrentPage">
            </el-pagination>
        </div>
    </#if>
<#if hasSortTableOverall??>
    ${hasSortTableOverall!}
</#if>
</div>