<div
    <#list attributes!?keys as key>
        ${key}="${attributes[key]}"
    </#list>
    <#if (disabled??)>
        :class="{'disabled':${instanceKey!}Disabled}"
    </#if>
>
    <div class="el-upload-list el-upload-list--picture-card" v-if="${instanceKey!}Url<#if isReferData?? && isReferData!>|| ${referData!}</#if>">
        <div class="el-upload-list__item is-success">
            <img class="flex-img__image" :src="${instanceKey!}Url<#if isReferData?? && isReferData!>|| `<#noparse>$</#noparse>{httpApi}/attachment/showPicture?image=<#noparse>$</#noparse>{${referData!}}&dbName=<#noparse>$</#noparse>{${instanceKey!}dbName}`</#if>">
            <#if (disabled??)>
            <span v-if="!${instanceKey!}Disabled">
            </#if>
            <label class="el-upload-list__item-status-label">
                <i class="el-icon-upload-success el-icon-check"></i>
            </label>
            <#if (disabled??)>
            </span>
            </#if>
            <span class="el-upload-list__item-actions">
                <#if (disabled??)>
                <span v-if="!${instanceKey!}Disabled">
                </#if>
                <span class="el-upload-list__item-delete">
                    <i class="el-icon-delete" @click.stop="${instanceKey!}HandleRemove()"></i>
                </span>
                <span class="el-upload-list__item-preview">
                    <i class="el-icon-zoom-in" @click.stop="${instanceKey!}HandlePreview()"></i>
                </span>
                <#if (disabled??)>
                </span>
                </#if>
            </span>
        </div>
    </div>
    <el-upload
            v-else
            class="jxd-upload-item"
            :action="${instanceKey!}UploadApi"
            ref="${instanceKey!}ImgUploadRef"
            :show-file-list="false"
            accept="image/jpeg,image/jpg,image/png"
            <#if setUpSecurityLevel?? && setUpSecurityLevel>
                :on-change="${instanceKey!}_UploadChange"
                :auto-upload="false"
            <#else>
                :auto-upload="true"
                :http-request="${instanceKey!}_UploadAuto"
            </#if>
            :before-upload = "${instanceKey!}BeforeUpload"
            <#if (disabled??)>
                :disabled="${instanceKey!}Disabled"
            </#if>
    >
        <i class="jxd-uploader-icon ${iconClassName!}"></i>
    </el-upload>
    <input type="hidden" v-model="${referData!}" />
<#--    <el-dialog class="jxd_ins_elDialog upload-img-dialog" :visible.sync="${instanceKey!}DialogVisible" :append-to-body=true>-->
<#--        <img :src="${instanceKey!}DialogUrl">-->
<#--    </el-dialog>-->
    <#if setUpSecurityLevel?? && setUpSecurityLevel>
        <el-dialog ref="${instanceKey!}DialogRef" :visible.sync="${instanceKey!}Show" :before-close="${instanceKey!}_Close" :show-close="${instanceKey!}ShowClose" :modal-append-to-body=true :append-to-body=true :close-on-click-modal="${instanceKey!}IsClickClose" top="0" class="${instanceKey!}_Dialog fileUploadDialog">
        <div slot="title" class="dialog-header fileUploadDialogHeader">
            单图片上传
        </div>
        <div class="dialog-body fileUploadDialogBody">
            <div ref="${instanceKey!}BodyRef" class="${instanceKey!}_Table">
                <vxe-table class="fileUploadTable" show-overflow row-key keep-source :height="'100%'" ref="${instanceKey!}TableRef" :edit-config="{trigger: 'click', mode: 'cell', activeMethod: ${instanceKey!}_ActiveCellMethod}" :data="${instanceKey!}Data">
                    <vxe-table-column align="center" header-align="center" field="fileName" title="图片名" :min-width="180" :edit-render="{
                                    immediate: true,
                                    name: 'input',
                                    attrs: {type: 'text'},
                                  }">
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="" field="fileType" title="图片类型" :min-width="70" :edit-render="{
                                    immediate: true,
                                    name: 'input',
                                    attrs: {type: 'text'},
                                  }">
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="fileSize" title="图片大小" :min-width="70" :edit-render="{
                                    immediate: true,
                                    name: 'input',
                                    attrs: {type: 'text'},
                                  }">
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="fileTime" title="上传时间" :min-width="180" :edit-render="{
                                    immediate: true,
                                    name: 'input',
                                    attrs: {type: 'text'},
                                  }">
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.fileTime) ? $moment(row.fileTime).format('YYYY-MM-DD HH:mm:ss') : '--'}}</span>
                        </template>
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="filePerson" title="上传人" :min-width="90" :edit-render="{
                                    immediate: true,
                                    name: 'input',
                                    attrs: {type: 'text'},
                                  }">
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="securityLevel" title="密级" :min-width="130" :edit-render="{
                                    immediate: true,
                                    name: 'select',
                                    options: ${instanceKey!}degreeList,
                                  }">
                    </vxe-table-column>
                </vxe-table>
            </div>
            <el-button tabindex="" ref="${instanceKey!}UploadRef" class="${instanceKey!}Upload confirmUploadBtn" v-loading.fullscreen.lock="${instanceKey!}showLoading" @click="${instanceKey!}_ConfirmUpload">
                <span>确认上传</span>
            </el-button>
            <el-button tabindex="" ref="${instanceKey!}CancelRef" class="${instanceKey!}Cancel cancelUploadBtn" @click="${instanceKey!}_CancelUpload">
                <span>取消上传</span>
            </el-button>
        </div>
    </el-dialog>
    </#if>
</div>
