/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.service.impl;

import com.jxdinfo.filepreview.start.enums.AcceptFileType;
import com.jxdinfo.filepreview.start.service.WkPreviewService;
import com.jxdinfo.filepreview.start.util.LibreOfficePDFConvert;
import com.jxdinfo.filepreview.start.util.ResponseFileUtil;
import java.util.Base64;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

@Service
public class WkPreviewServiceImpl
implements WkPreviewService {
    @Resource
    private RestTemplate downloadProxyTemplate;
    @Resource
    private LibreOfficePDFConvert libreOfficePDFConvert;
    @Resource
    private ResponseFileUtil responseFileUtil;
    @Value(value="${hussar-formdesign.workspace:}")
    private String outputPath;
    private static final Logger LOGGER = LoggerFactory.getLogger(WkPreviewServiceImpl.class);

    @Override
    public void getPostList(String url, HttpServletResponse response, String mark) {
        long start = System.currentTimeMillis();
        LOGGER.info("==========\u4ee3\u7406\u8bf7\u6c42\u6587\u4ef6===========");
        byte[] decodedBytes = Base64.getDecoder().decode(url);
        url = new String(decodedBytes);
        ResponseExtractor responseExtractor = clientHttpResponse -> {
            HttpHeaders headers = clientHttpResponse.getHeaders();
            headers.forEach((key, value) -> response.setHeader(key, (String)value.get(0)));
            ContentDisposition contentDisposition = headers.getContentDisposition();
            MediaType contentType = headers.getContentType();
            if (contentType == null) {
                return false;
            }
            AcceptFileType acceptFileType = AcceptFileType.getAcceptFileType(contentType.toString(), contentDisposition);
            if (acceptFileType == null) {
                return false;
            }
            LOGGER.info("\u6587\u4ef6\u7c7b\u578b\uff1a" + acceptFileType.getContentType());
            LOGGER.info("\u6587\u4ef6\u5927\u5c0f\uff1a" + headers.getContentLength());
            this.responseFileUtil.transferOrConvertResponse(clientHttpResponse, response, acceptFileType, mark, this.outputPath);
            return true;
        };
        Boolean execute = (Boolean)this.downloadProxyTemplate.execute(url, HttpMethod.GET, null, responseExtractor, new Object[0]);
        if (!Boolean.TRUE.equals(execute)) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25, \u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u652f\u6301\u9884\u89c8");
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
        LOGGER.info(response.getContentType());
        long end = System.currentTimeMillis();
        LOGGER.info("\u8017\u65f6\uff1a" + (end - start) + "ms");
    }
}

