/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.util;

import com.jxdinfo.filepreview.start.enums.AcceptFileType;
import com.jxdinfo.filepreview.start.util.LibreOfficePDFConvert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class ResponseFileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseFileUtil.class);
    public static final String TEMP_FILE_DIR = "/temp";
    public static final String TEMP_FILE_PREFIX = "/temp.";
    public static final String FILE_LENGTH_HEADER = "Content-Length";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String REGEX_FILETYPE = "\\.[a-zA-Z]*$";
    public static final String PDF_FILETYPE = ".pdf";
    private static final long cacheTime = 604800000L;
    private static MessageDigest mMessageDigest = null;

    public static void transferResponse(ClientHttpResponse clientHttpResponse, HttpServletResponse response) {
        try {
            StreamUtils.copy((InputStream)Objects.requireNonNull(clientHttpResponse.getBody()), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                clientHttpResponse.getBody().close();
                response.getOutputStream().close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static void transferOrConvertResponse(ClientHttpResponse clientHttpResponse, HttpServletResponse response, AcceptFileType acceptFileType, String mark, String outputPath) {
        if (!acceptFileType.getConvertFlag().booleanValue()) {
            ResponseFileUtil.transferResponse(clientHttpResponse, response);
            return;
        }
        FileOutputStream outtemp = null;
        String dirFilePaths = System.getProperty("user.dir") + TEMP_FILE_DIR + File.separator + UUID.randomUUID();
        File dirFiletemp = new File(dirFilePaths);
        if (!dirFiletemp.exists() && dirFiletemp.mkdirs()) {
            LOGGER.info("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u6210\u529f");
        }
        File filetemp = new File(dirFiletemp + TEMP_FILE_PREFIX + acceptFileType.getType());
        try {
            outtemp = new FileOutputStream(filetemp);
            StreamUtils.copy((InputStream)clientHttpResponse.getBody(), (OutputStream)outtemp);
        }
        catch (IOException e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (outtemp != null) {
                    outtemp.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
        String md5 = ResponseFileUtil.getFileMD5String(filetemp);
        String dirFilePath = System.getProperty("user.dir") + TEMP_FILE_DIR + File.separator + md5;
        File dirFile = new File(dirFilePath);
        if (dirFile.exists()) {
            File result = new File(dirFilePath + TEMP_FILE_PREFIX + AcceptFileType.PDF.getType());
            FileInputStream inresult = null;
            try {
                String path = result.getPath();
                long orgLength = result.length();
                LOGGER.info("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)result.getPath());
                path = ResponseFileUtil.addMark(path, mark, outputPath, response, orgLength);
                response.setContentType("application/pdf");
                if (response.getHeader(CONTENT_DISPOSITION) != null) {
                    response.setHeader(CONTENT_DISPOSITION, response.getHeader(CONTENT_DISPOSITION).replaceAll(REGEX_FILETYPE, PDF_FILETYPE));
                }
                inresult = new FileInputStream(path);
                StreamUtils.copy((InputStream)inresult, (OutputStream)response.getOutputStream());
                return;
            }
            catch (IOException e) {
                LOGGER.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (inresult != null) {
                        inresult.close();
                    }
                    clientHttpResponse.getBody().close();
                    if (response.getOutputStream() != null) {
                        response.getOutputStream().close();
                    }
                    LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939");
                    FileUtils.deleteDirectory((File)dirFiletemp);
                }
                catch (IOException e) {
                    LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (!dirFile.exists() && dirFile.mkdirs()) {
            LOGGER.info("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u6210\u529f");
        }
        File pdfFile = new File(dirFilePath + TEMP_FILE_PREFIX + AcceptFileType.PDF.getType());
        FileInputStream in = null;
        try {
            String path = LibreOfficePDFConvert.doDocToFdpLibre(filetemp, pdfFile);
            long orgLength = pdfFile.length();
            LOGGER.info("\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)path);
            path = ResponseFileUtil.addMark(path, mark, outputPath, response, orgLength);
            response.setContentType("application/pdf");
            if (response.getHeader(CONTENT_DISPOSITION) != null) {
                response.setHeader(CONTENT_DISPOSITION, response.getHeader(CONTENT_DISPOSITION).replaceAll(REGEX_FILETYPE, PDF_FILETYPE));
            }
            in = new FileInputStream(path);
            StreamUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        catch (IOException | OfficeException e) {
            LOGGER.error("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25", e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                clientHttpResponse.getBody().close();
                if (response.getOutputStream() != null) {
                    response.getOutputStream().close();
                }
                LOGGER.info("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939");
                FileUtils.deleteDirectory((File)dirFiletemp);
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static String addMark(String path, String mark, String outputPath, HttpServletResponse response, Long orgLength) {
        if (StringUtils.isNotEmpty((CharSequence)mark)) {
            try {
                File file4 = new File(path);
                float fontSize = 13.0f;
                int rowSpace = 150;
                int colSpace = 150;
                PDDocument document = PDDocument.load((File)file4);
                document.setAllSecurityToBeRemoved(true);
                for (PDPage page : document.getPages()) {
                    PDPageContentStream stream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                    PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)ResponseFileUtil.class.getResourceAsStream("/fonts/AlibabaPuHuiTi-2-55-Regular.ttf"), (boolean)true);
                    PDExtendedGraphicsState r = new PDExtendedGraphicsState();
                    r.setAlphaSourceFlag(true);
                    stream.setGraphicsStateParameters(r);
                    stream.setNonStrokingColor(200, 200, 200);
                    stream.beginText();
                    stream.setFont((PDFont)font, fontSize);
                    stream.newLineAtOffset(0.0f, -15.0f);
                    float pageHeight = page.getMediaBox().getHeight();
                    float pageWidth = page.getMediaBox().getWidth();
                    int h = 10;
                    while ((float)h < pageHeight) {
                        int w = -10;
                        while ((float)w < pageWidth) {
                            stream.setTextMatrix(Matrix.getRotateInstance((double)0.45, (float)w, (float)h));
                            stream.showText(mark);
                            w += colSpace;
                        }
                        h += rowSpace;
                    }
                    stream.endText();
                    stream.restoreGraphicsState();
                    stream.close();
                    LOGGER.info("\u7b2c\uff1a{}\u9875\u6c34\u5370\u6dfb\u52a0\u5b8c\u6210", (Object)document.getPages().indexOf(page));
                }
                LOGGER.info("\u6c34\u5370\u6dfb\u52a0\u5b8c\u6210");
                long current = System.currentTimeMillis();
                String fileOutPath = outputPath + File.separator + "markPdf";
                File file = new File(fileOutPath);
                if (!file.exists()) {
                    file.mkdir();
                }
                String outPath = fileOutPath + File.separator + current + PDF_FILETYPE;
                File file1 = new File(outPath);
                document.save(file1);
                LOGGER.info("pdf\u8f93\u51fa\u5b8c\u6210");
                document.close();
                orgLength = file1.length();
                path = outPath;
                LOGGER.info("\u6dfb\u52a0\u6c34\u5370\u6210\u529f,\u6c34\u5370pdf\uff1b\u8def\u5f84\uff1a{}", (Object)path);
            }
            catch (Exception ex) {
                LOGGER.error("\u6dfb\u52a0\u6c34\u5370\u5931\u8d25", (Throwable)ex);
            }
        }
        response.setHeader(FILE_LENGTH_HEADER, String.valueOf(orgLength));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5String(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = ((InputStream)fis).read(buffer, 0, 1024)) > 0) {
                mMessageDigest.update(buffer, 0, length);
            }
            String string = new BigInteger(1, mMessageDigest.digest()).toString(16);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    LOGGER.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public static void deleteCache() {
        String path = System.getProperty("user.dir") + TEMP_FILE_DIR;
        File file = new File(path);
        long tiemmillis = System.currentTimeMillis() - 604800000L;
        for (File f : file.listFiles()) {
            if (!file.isDirectory()) continue;
            try {
                Path filePath = file.toPath();
                BasicFileAttributes attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.creationTime().toMillis() >= tiemmillis) continue;
                Files.delete(filePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            mMessageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

