/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.controller;

import com.jxdinfo.filepreview.start.service.WkPreviewService;
import com.jxdinfo.filepreview.start.util.LibreOfficePDFConvert;
import com.jxdinfo.filepreview.start.util.ResponseFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.jodconverter.office.OfficeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/wkpreview"})
@ConditionalOnWebApplication
public class WkPreviewController {
    @Resource
    private RestTemplate downloadProxyTemplate;
    @Resource
    private WkPreviewService wkPreviewService;
    @Value(value="${hussar-formdesign.workspace:}")
    private String outputPath;
    private static final Logger LOGGER = LoggerFactory.getLogger(WkPreviewController.class);

    @GetMapping(value={"/test"})
    public String getPostList() throws OfficeException {
        File file3 = new File("D:\\test\\222.docx");
        File file4 = new File("D:\\test\\222.pdf");
        System.out.println(LibreOfficePDFConvert.doDocToFdpLibre(file3, file4));
        return "index";
    }

    @GetMapping(value={"/test1"})
    public String getPostList1() throws Exception {
        File file4 = new File("C:\\Users\\\u8c46\u5305\\Desktop\\\u7ec4\u5408 4.pdf");
        String waterMark = "\u8d85\u7ea7\u7ba1\u7406\u5458 9527";
        float fontSize = 13.0f;
        int rowSpace = 150;
        int colSpace = 150;
        PDDocument document = PDDocument.load((File)file4);
        document.setAllSecurityToBeRemoved(true);
        for (PDPage page : document.getPages()) {
            PDPageContentStream stream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true, true);
            PDType0Font font = PDType0Font.load((PDDocument)document, (InputStream)new FileInputStream("C:\\Users\\\u8c46\u5305\\Desktop\\\u963f\u91cc\u5df4\u5df4\u666e\u60e0\u4f53R.ttf"), (boolean)true);
            PDExtendedGraphicsState r = new PDExtendedGraphicsState();
            r.setAlphaSourceFlag(true);
            stream.setGraphicsStateParameters(r);
            stream.setNonStrokingColor(200, 200, 200);
            stream.beginText();
            stream.setFont((PDFont)font, fontSize);
            stream.newLineAtOffset(0.0f, -15.0f);
            float pageHeight = page.getMediaBox().getHeight();
            float pageWidth = page.getMediaBox().getWidth();
            int h = 10;
            while ((float)h < pageHeight) {
                int w = -10;
                while ((float)w < pageWidth) {
                    stream.setTextMatrix(Matrix.getRotateInstance((double)0.45, (float)w, (float)h));
                    stream.showText(waterMark);
                    w += colSpace;
                }
                h += rowSpace;
            }
            stream.endText();
            stream.restoreGraphicsState();
            stream.close();
            LOGGER.info("\u7b2c\uff1a{}\u9875\u6c34\u5370\u6dfb\u52a0\u5b8c\u6210", (Object)document.getPages().indexOf(page));
        }
        LOGGER.info("\u6c34\u5370\u6dfb\u52a0\u5b8c\u6210");
        document.save(new File("C:\\Users\\\u8c46\u5305\\Desktop\\ce1.pdf"));
        LOGGER.info("pdf\u8f93\u51fa\u5b8c\u6210");
        document.close();
        return "index";
    }

    @GetMapping(value={"/proxy"})
    public void getPostList(@RequestParam String url, HttpServletResponse response, @RequestParam(required=false) String mark) {
        this.wkPreviewService.getPostList(url, response, mark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/list2"})
    public synchronized void getPostList(@RequestBody Map<String, String> params, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.info("==========\u8fdb\u5165\u9884\u89c8===========");
        FileInputStream input = null;
        RandomAccessFile randomAccessFile = null;
        InputStream inputStream = null;
        ServletOutputStream os = null;
        try {
            File file = null;
            LOGGER.info("==========\u8fdb\u5165\u5206\u7247\u9884\u89c8===========");
            String path = params.get("path");
            String convertFlag = params.get("convertFlag");
            if ("true".equals(convertFlag)) {
                String pdfPath = path.substring(0, path.lastIndexOf(".")) + ".pdf";
                path = LibreOfficePDFConvert.doDocToFdpLibre(new File(path), new File(pdfPath));
            }
            file = new File(path);
            LOGGER.info("==========file\u521b\u5efa\u5b8c\u6210\uff0c\u8fdb\u884c\u5224\u65ad===========");
            if (!file.exists() || file.length() == 0L) {
                LOGGER.info("==========\u6587\u4ef6\u4e0d\u5b58\u5728===========");
                return;
            }
            LOGGER.info("==========\u83b7\u5f97\u6587\u4ef6===========");
            inputStream = new FileInputStream(file);
            if (file.length() < 512000L) {
                response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
            }
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Type", "application/pdf");
            String range = request.getHeader("Range");
            LOGGER.info("==========\u83b7\u5f97\u6587\u4ef6RANGE===========" + range);
            if (!StringUtils.isEmpty((Object)range)) {
                long t1 = new Date().getTime();
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247===========");
                range = range.replace("bytes=", "");
                String[] ranges = range.split("-");
                int startIndex = Integer.parseInt(ranges[0]);
                int endIndex = Integer.parseInt(ranges[1]);
                byte[] buffer = new byte[endIndex - startIndex + 1];
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.seek(startIndex);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u8bfb\u53d6\u6587\u4ef6===========");
                randomAccessFile.read(buffer);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u8bfb\u53d6\u6587\u4ef6\u7ed3\u675f===========");
                response.setHeader("Content-Range", "bytes " + startIndex + "-" + (endIndex - 1) + "/" + file.length() + "");
                response.setStatus(206);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u5199\u5165\u6587\u4ef6===========");
                response.getOutputStream().write(buffer);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u5199\u5165\u6587\u4ef6\u7ed3\u675f===========");
                long t2 = new Date().getTime();
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247\u7ed3\u675f===========" + (t1 - t2));
            } else {
                LOGGER.info("==========\u9996\u6b21\u52a0\u8f7d===========");
                inputStream = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                os = response.getOutputStream();
                int i = 0;
                while ((i = inputStream.read(bytes)) != -1) {
                    os.write(bytes, 0, i);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u6587\u4ef6\uff1a" + e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + e);
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    response.getOutputStream().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @GetMapping(value={"/deleteCache"})
    public void deleteCache() {
        ResponseFileUtil.deleteCache();
    }
}

