/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.filepreview.start.controller;

import com.jxdinfo.filepreview.start.enums.AcceptFileType;
import com.jxdinfo.filepreview.start.util.LibreOfficePDFConvert;
import com.jxdinfo.filepreview.start.util.ResponseFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.jodconverter.office.OfficeException;
import org.ofdrw.converter.ConvertHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/htszPreview"})
@ConditionalOnWebApplication
public class WkPreviewController {
    @Resource
    private RestTemplate downloadProxyTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(WkPreviewController.class);

    @GetMapping(value={"/test"})
    public String getPostList() throws OfficeException {
        File file3 = new File("F:\\360MoveData\\Users\\HP\\Desktop\\\u9644\u4ef6\u9884\u89c8\u65b9\u6848 .doc");
        File file4 = new File("F:\\360MoveData\\Users\\HP\\Desktop\\\u7528\u6237\u7ba1\u7406.pdf");
        System.out.println(LibreOfficePDFConvert.doDocToFdpLibre(file3, file4));
        return "index";
    }

    @GetMapping(value={"/proxy"})
    public void getPostList(@RequestParam String url, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        LOGGER.info("==========\u4ee3\u7406\u8bf7\u6c42\u6587\u4ef6===========");
        byte[] decodedBytes = Base64.getDecoder().decode(url);
        url = new String(decodedBytes);
        ResponseExtractor responseExtractor = clientHttpResponse -> {
            HttpHeaders headers = clientHttpResponse.getHeaders();
            headers.forEach((key, value) -> response.setHeader(key, (String)value.get(0)));
            ContentDisposition contentDisposition = headers.getContentDisposition();
            if (contentDisposition == null) {
                return false;
            }
            MediaType contentType = headers.getContentType();
            if (contentType == null) {
                return false;
            }
            AcceptFileType acceptFileType = AcceptFileType.getAcceptFileType(contentType.toString(), contentDisposition);
            if (acceptFileType == null) {
                return false;
            }
            LOGGER.info("\u6587\u4ef6\u7c7b\u578b\uff1a" + acceptFileType.getContentType());
            LOGGER.info("\u6587\u4ef6\u5927\u5c0f\uff1a" + headers.getContentLength());
            ResponseFileUtil.transferOrConvertResponse(clientHttpResponse, response, acceptFileType);
            return true;
        };
        Boolean execute = (Boolean)this.downloadProxyTemplate.execute(url, HttpMethod.GET, null, responseExtractor, new Object[0]);
        if (!Boolean.TRUE.equals(execute)) {
            throw new RuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25, \u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b\u662f\u5426\u652f\u6301\u9884\u89c8");
        }
        LOGGER.info("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f");
        LOGGER.info(response.getContentType());
        long end = System.currentTimeMillis();
        System.out.println("\u8017\u65f6\uff1a" + (end - start) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/list2"})
    public synchronized void getPostList(@RequestBody Map<String, String> params, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.info("==========\u8fdb\u5165\u9884\u89c8===========");
        FileInputStream input = null;
        RandomAccessFile randomAccessFile = null;
        InputStream inputStream = null;
        try {
            File file = null;
            LOGGER.info("==========\u8fdb\u5165\u5206\u7247\u9884\u89c8===========");
            String path = params.get("path");
            String convertFlag = params.get("convertFlag");
            if ("true".equals(convertFlag)) {
                String pdfPath = path.substring(0, path.lastIndexOf(".")) + ".pdf";
                path = LibreOfficePDFConvert.doDocToFdpLibre(new File(path), new File(pdfPath));
            }
            file = new File(path);
            LOGGER.info("==========file\u521b\u5efa\u5b8c\u6210\uff0c\u8fdb\u884c\u5224\u65ad===========");
            if (!file.exists() || file.length() == 0L) {
                LOGGER.info("==========\u6587\u4ef6\u4e0d\u5b58\u5728===========");
                return;
            }
            LOGGER.info("==========\u83b7\u5f97\u6587\u4ef6===========");
            inputStream = new FileInputStream(file);
            if (file.length() < 512000L) {
                response.setDateHeader("expires", System.currentTimeMillis() + 604800000L);
            }
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Type", "application/pdf");
            String range = request.getHeader("Range");
            LOGGER.info("==========\u83b7\u5f97\u6587\u4ef6RANGE===========" + range);
            if (!StringUtils.isEmpty((Object)range)) {
                long t1 = new Date().getTime();
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247===========");
                range = range.replace("bytes=", "");
                String[] ranges = range.split("-");
                int startIndex = Integer.parseInt(ranges[0]);
                int endIndex = Integer.parseInt(ranges[1]);
                byte[] buffer = new byte[endIndex - startIndex + 1];
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.seek(startIndex);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u8bfb\u53d6\u6587\u4ef6===========");
                randomAccessFile.read(buffer);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u8bfb\u53d6\u6587\u4ef6\u7ed3\u675f===========");
                response.setHeader("Content-Range", "bytes " + startIndex + "-" + (endIndex - 1) + "/" + file.length() + "");
                response.setStatus(206);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u5199\u5165\u6587\u4ef6===========");
                response.getOutputStream().write(buffer);
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247 \u5199\u5165\u6587\u4ef6\u7ed3\u675f===========");
                long t2 = new Date().getTime();
                LOGGER.info("==========\u8fdb\u5165206\u5206\u7247\u7ed3\u675f===========" + (t1 - t2));
            } else {
                LOGGER.info("==========\u9996\u6b21\u52a0\u8f7d===========");
                inputStream = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                ServletOutputStream os = response.getOutputStream();
                int i = 0;
                while ((i = inputStream.read(bytes)) != -1) {
                    os.write(bytes, 0, i);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u6587\u4ef6\uff1a" + e);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + e);
        }
        catch (Exception e) {
            LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (response.getOutputStream() != null) {
                    response.getOutputStream().close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error("\u6587\u4ef6\u9884\u89c8\u5931\u8d25\uff1a" + e);
            }
        }
    }

    @GetMapping(value={"/deleteCache"})
    public void deleteCache() {
        ResponseFileUtil.deleteCache();
    }

    @PostMapping(value={"/ofd"})
    public void pdfConvert(MultipartHttpServletRequest multipartRequest, HttpServletResponse response) {
        MultipartFile multipartFile = null;
        Iterator iterator = multipartRequest.getFileMap().values().iterator();
        while (iterator.hasNext()) {
            MultipartFile file;
            multipartFile = file = (MultipartFile)iterator.next();
        }
        try {
            InputStream inputStream = multipartFile.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ConvertHelper.toPdf((InputStream)inputStream, (OutputStream)outputStream);
            byte[] pdfContent = outputStream.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_PDF);
            headers.setContentLength((long)pdfContent.length);
            response.setHeader("Content-Disposition", "attachment;fileName=" + this.getPdfFilename(multipartFile.getOriginalFilename()));
            response.setHeader("Content-Type", "application/pdf");
            StreamUtils.copy((byte[])outputStream.toByteArray(), (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert OFD to PDF", e);
        }
    }

    private String getPdfFilename(String originalFilename) {
        String baseName = FilenameUtils.getBaseName((String)originalFilename);
        String extension = ".pdf";
        return baseName + extension;
    }
}

