/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.df.common.exception.DfException;
import com.jxdinfo.hussar.df.data.set.api.app.dto.SysDataSetGroupDto;
import com.jxdinfo.hussar.df.data.set.api.app.model.SysDataSetGroup;
import com.jxdinfo.hussar.df.data.set.api.app.model.SysDataSetInfo;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetGroupService;
import com.jxdinfo.hussar.df.data.set.api.app.service.ISysDataSetInfoService;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysDataSetGroupVo;
import com.jxdinfo.hussar.df.data.set.api.app.vo.SysSiftDataSetGroupList;
import com.jxdinfo.hussar.df.data.set.server.app.dao.SysDataSetGroupMapper;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.df.app.service.impl.sysDataSetGroupServiceImpl")
public class SysDataSetGroupServiceImpl
extends HussarServiceImpl<SysDataSetGroupMapper, SysDataSetGroup>
implements ISysDataSetGroupService {
    @Resource
    private ISysDataSetInfoService sysDataSetInfoService;

    public ApiResponse<Boolean> addDataSetGroup(SysDataSetGroupDto sysDataSetGroupDto) {
        boolean flag = this.save((BaseEntity)sysDataSetGroupDto);
        if (!flag) {
            throw new DfException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> editDataSetGroup(SysDataSetGroupDto sysDataSetGroupDto) {
        boolean flag = this.updateById((BaseEntity)sysDataSetGroupDto);
        if (!flag) {
            throw new DfException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> deleteDataSetGroup(Long groupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysDataSetInfo::getGroupId, (Object)groupId);
        wrapper.eq(HussarDelflagEntity::getDelFlag, (Object)0);
        if (HussarUtils.isNotEmpty((Object)this.sysDataSetInfoService.getOne((Wrapper)wrapper))) {
            throw new DfException("\u5206\u7ec4\u4e0b\u5b58\u5728\u6570\u636e\u96c6\u65e0\u6cd5\u5220\u9664");
        }
        boolean flag = this.removeById(groupId);
        if (!flag) {
            throw new DfException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<List<SysDataSetGroup>> getDataSetGroupList(Long appId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysDataSetGroup::getAppId, (Object)appId);
        wrapper.orderBy(true, true, SysDataSetGroup::getSeq);
        return ApiResponse.success((Object)this.list((Wrapper)wrapper));
    }

    @HussarTransactional
    public ApiResponse<Boolean> editGroupAndDataSet(SysSiftDataSetGroupList sysSiftDataSetGroupList) {
        List haveGroupList = sysSiftDataSetGroupList.getHaveGroupList();
        for (int i = 0; i < haveGroupList.size(); ++i) {
            SysDataSetGroupVo sysDataSetGroupVo = (SysDataSetGroupVo)haveGroupList.get(i);
            sysDataSetGroupVo.setSeq(i);
            for (int j = 0; j < sysDataSetGroupVo.getSysDataSetList().size(); ++j) {
                List sysDataSetInfos = sysDataSetGroupVo.getSysDataSetList();
                ((SysDataSetInfo)sysDataSetInfos.get(j)).setSeq(j);
                ((SysDataSetInfo)sysDataSetInfos.get(j)).setGroupId(sysDataSetGroupVo.getGroupId());
            }
        }
        List formGroups = haveGroupList.stream().map(entity -> {
            SysDataSetGroup sysDataSetGroup = new SysDataSetGroup();
            BeanUtils.copyProperties((Object)entity, (Object)sysDataSetGroup);
            return sysDataSetGroup;
        }).collect(Collectors.toList());
        this.updateBatchById(formGroups);
        List noGroupList = sysSiftDataSetGroupList.getNoGroupList();
        for (int i = 0; i < noGroupList.size(); ++i) {
            ((SysDataSetInfo)noGroupList.get(i)).setSeq(i);
        }
        ArrayList needUpdateSysDataSetInfos = new ArrayList(noGroupList);
        for (SysDataSetGroupVo sysDataSetGroupVo : haveGroupList) {
            needUpdateSysDataSetInfos.addAll(sysDataSetGroupVo.getSysDataSetList());
        }
        if (!this.sysDataSetInfoService.updateBatchById(needUpdateSysDataSetInfos)) {
            throw new DfException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)true, (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Boolean> sortGroup(List<Long> groupIdList) {
        ArrayList<SysDataSetGroup> sysDataSetGroups = new ArrayList<SysDataSetGroup>();
        for (int i = 0; i < groupIdList.size(); ++i) {
            SysDataSetGroup sysDataSetGroup = new SysDataSetGroup();
            sysDataSetGroup.setGroupId(groupIdList.get(i));
            sysDataSetGroup.setSeq(i);
            sysDataSetGroups.add(sysDataSetGroup);
        }
        return ApiResponse.success((Object)this.updateBatchById(sysDataSetGroups));
    }
}

