/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.server.customdataset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.df.common.constant.DfEngineColumnType;
import com.jxdinfo.hussar.df.data.set.api.customsql.dto.CustomSqlDto;
import com.jxdinfo.hussar.df.data.set.api.customsql.model.DfColumnValue;
import com.jxdinfo.hussar.df.data.set.api.customsql.service.CustomSqlQueryService;
import com.jxdinfo.hussar.df.data.set.api.customsql.vo.TestDfCustomSqlVo;
import com.jxdinfo.hussar.df.data.set.api.model.ProjectionField;
import com.jxdinfo.hussar.df.data.set.api.processor.DataSetProcessor;
import com.jxdinfo.hussar.df.data.set.server.util.DataSetUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfDataSourceUtil;
import com.jxdinfo.hussar.df.data.set.server.util.DfEngineColumnTypeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.xmltags.XMLScriptBuilder;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xml.sax.EntityResolver;

@Service
public class CustomSqlQueryServiceImpl
implements CustomSqlQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CustomSqlQueryServiceImpl.class);
    @Autowired
    private SysDataSourceService sysDataSourceService;

    @HussarDs
    public TestDfCustomSqlVo testSql(CustomSqlDto customSqlDto) {
        TestDfCustomSqlVo dfCustomSqlVo = new TestDfCustomSqlVo();
        customSqlDto.setCustomSql(this.parseSql(customSqlDto.getCustomSql()));
        SysDataSource dataSource = (SysDataSource)this.sysDataSourceService.getDatasourceById(customSqlDto.getDataSourceId()).getData();
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(dataSource.getDriverClass())) {
            String sql = StringUtil.trimWhitespace((String)customSqlDto.getCustomSql());
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            String dealedSql = "select * from ( " + sql + ") t";
            customSqlDto.setCustomSql(dealedSql);
        }
        DbType dbType = DfDataSourceUtil.getDbType(dataSource.getConnName());
        Connection conn = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            conn = this.getConn(dataSource.getJdbcUrl(), dataSource.getUserName(), dataSource.getPassword(), dataSource.getDriverClass());
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (HussarUtils.isNotEmpty((Object)customSqlDto.getParameterValues())) {
                for (DfColumnValue columnValue : customSqlDto.getParameterValues()) {
                    map.put(columnValue.getCode(), columnValue.getValue());
                }
            }
            pstm = this.dealSql(customSqlDto, map, conn, dbType);
            ArrayList mapList = new ArrayList();
            rs = pstm.executeQuery();
            ResultSetMetaData md = rs.getMetaData();
            ArrayList<ProjectionField> columnInfos = new ArrayList<ProjectionField>();
            for (int i = 0; i < md.getColumnCount(); ++i) {
                ProjectionField columnInfo = new ProjectionField();
                columnInfo.setFieldAlias(md.getColumnLabel(i + 1));
                columnInfo.setField(md.getColumnName(i + 1));
                columnInfo.setSourceDataType(md.getColumnTypeName(i + 1));
                Optional<DfEngineColumnType> engineColumnType = DfEngineColumnTypeUtil.getEngineColumnTypeByJdbcType(md.getColumnType(i + 1));
                engineColumnType.ifPresent(columnType -> columnInfo.setDataType(columnType.getDataType()));
                columnInfo.setDataLength(Integer.valueOf(md.getPrecision(i + 1)));
                columnInfo.setDataDot(Integer.valueOf(md.getScale(i + 1)));
                columnInfo.setType("default");
                columnInfos.add(columnInfo);
            }
            String duplicateMsg = this.checkDuplicate(columnInfos);
            if (HussarUtils.isNotEmpty((Object)duplicateMsg)) {
                throw new HussarException(duplicateMsg);
            }
            while (rs.next()) {
                HashMap<String, Object> objectMap = new HashMap<String, Object>();
                for (int i = 0; i < md.getColumnCount(); ++i) {
                    Object value = rs.getObject(i + 1);
                    if (value instanceof Double || value instanceof Float) {
                        value = String.valueOf(value);
                    }
                    if (((ProjectionField)columnInfos.get(i)).getDataLength() == 1 && ((ProjectionField)columnInfos.get(i)).getDataDot() == 0 && BigDecimal.valueOf(0.0).equals(rs.getObject(i + 1))) {
                        value = "0";
                    }
                    objectMap.put(md.getColumnLabel(i + 1), value);
                }
                mapList.add(objectMap);
            }
            dfCustomSqlVo.setQueryResult(mapList);
            dfCustomSqlVo.setProjectionFields(columnInfos);
            if (customSqlDto.getTotal() != null) {
                dfCustomSqlVo.setTotal(customSqlDto.getTotal());
            } else {
                dfCustomSqlVo.setTotal(Long.valueOf(mapList.size()));
            }
            TestDfCustomSqlVo testDfCustomSqlVo = dfCustomSqlVo;
            this.close(conn, pstm, rs);
            return testDfCustomSqlVo;
        }
        catch (Exception e) {
            try {
                throw new HussarException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(conn, pstm, rs);
                throw throwable;
            }
        }
    }

    public TestDfCustomSqlVo preivewDataBySql(CustomSqlDto sqlDataSetModel) {
        DataSetProcessor processor = DataSetUtil.processor("SQL_DATASET");
        this.checkSql(sqlDataSetModel);
        TestDfCustomSqlVo dfCustomSqlVo = processor.priviewDataBySql(sqlDataSetModel);
        return dfCustomSqlVo;
    }

    private void checkSql(CustomSqlDto sqlDataSetModel) {
        if (sqlDataSetModel.isPagination() && sqlDataSetModel.getCustomSql().toUpperCase().contains(" LIMIT ")) {
            throw new HussarException("\u5c55\u793a\u5206\u9875\u65f6\uff0c\u4e0d\u5141\u8bb8sql\u4e2d\u5b58\u5728LIMIT");
        }
    }

    private String checkDuplicate(List<ProjectionField> columnInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < columnInfos.size(); ++i) {
            for (int j = i + 1; j < columnInfos.size(); ++j) {
                if (!columnInfos.get(i).getFieldAlias().equals(columnInfos.get(j).getFieldAlias())) continue;
                stringBuilder.append("\u5b57\u6bb5\u540d").append(columnInfos.get(i).getFieldAlias()).append("\u91cd\u590d\n");
            }
        }
        return stringBuilder.toString();
    }

    private Connection getConn(String url, String user, String pwd, String driverClass) throws SQLException {
        try {
            Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return DriverManager.getConnection(url, user, pwd);
    }

    private void close(Connection conn, Statement stat, ResultSet rs) {
        if (rs != null) {
            try {
                if (!rs.isClosed()) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
        if (stat != null) {
            try {
                if (!stat.isClosed()) {
                    stat.close();
                }
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
        if (conn != null) {
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private PreparedStatement dealSql(CustomSqlDto customSqlDto, Map<String, Object> paramValues, Connection conn, DbType dbType) throws Exception {
        String sql = customSqlDto.getCustomSql();
        JSONObject paramsJson = new JSONObject(paramValues);
        sql = "<select>" + sql + "</select>";
        XPathParser parser = new XPathParser(sql, false, null, (EntityResolver)new XMLMapperEntityResolver());
        XNode context = parser.evalNode("/select");
        Configuration configuration = new Configuration();
        configuration.setDatabaseId("");
        XMLScriptBuilder xmlScriptBuilder = new XMLScriptBuilder(configuration, context);
        SqlSource sqlSource = xmlScriptBuilder.parseScriptNode();
        BoundSql bs = sqlSource.getBoundSql((Object)paramsJson);
        String finalSql = bs.getSql();
        if (customSqlDto.isPagination()) {
            String countSql = SqlParserUtils.getOriginalCountSql((String)bs.getSql());
            PreparedStatement preparedStatement = conn.prepareStatement(countSql);
            this.setParam(bs, configuration, paramsJson, preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long total = resultSet.getLong(1);
                customSqlDto.setTotal(Long.valueOf(total));
            }
            IDialect dialect = DialectFactory.getDialect((DbType)dbType);
            DialectModel dialectModel = dialect.buildPaginationSql(bs.getSql(), (long)customSqlDto.getOffSet(), (long)customSqlDto.getSize().intValue());
            PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)bs);
            List mappings = mpBoundSql.parameterMappings();
            Map additionalParameters = mpBoundSql.additionalParameters();
            dialectModel.consumers(mappings, configuration, additionalParameters);
            mpBoundSql.sql(dialectModel.getDialectSql());
            mpBoundSql.parameterMappings(mappings);
            finalSql = mpBoundSql.sql();
        }
        PreparedStatement pstm = conn.prepareStatement(finalSql);
        this.setParam(bs, configuration, paramsJson, pstm);
        return pstm;
    }

    private void setParam(BoundSql bs, Configuration configuration, JSONObject paramsJson, PreparedStatement pstm) throws SQLException {
        for (int i = 0; i < bs.getParameterMappings().size(); ++i) {
            Object value;
            ParameterMapping parameterMapping = (ParameterMapping)bs.getParameterMappings().get(i);
            if (parameterMapping.getMode() == ParameterMode.OUT) continue;
            String propertyName = parameterMapping.getProperty();
            if (bs.hasAdditionalParameter(propertyName)) {
                value = bs.getAdditionalParameter(propertyName);
            } else {
                MetaObject metaObject = configuration.newMetaObject((Object)paramsJson);
                value = metaObject.getValue(propertyName);
            }
            TypeHandler typeHandler = parameterMapping.getTypeHandler();
            JdbcType jdbcType = null;
            if (value == null) {
                jdbcType = JdbcType.NULL;
            }
            typeHandler.setParameter(pstm, i + 1, value, jdbcType);
        }
    }

    private String parseSql(String sql) {
        int endIndex;
        int startIndex;
        if (sql.contains("-- ")) {
            startIndex = sql.indexOf("-- ");
            endIndex = sql.indexOf("\n", startIndex);
            endIndex = endIndex > 0 ? ++endIndex : sql.length();
        } else {
            return sql;
        }
        sql = sql.replace(sql.substring(startIndex, endIndex), "");
        sql = this.parseSql(sql);
        return sql;
    }
}

