/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.df.data.set.engine.sql.util;

import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarMetadataService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.df.data.set.api.enums.DFSqlConnectEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumns;
import com.jxdinfo.hussar.support.engine.api.enums.OperatorType;
import com.jxdinfo.hussar.support.engine.api.model.ModelRelationshipDto;
import com.jxdinfo.hussar.support.engine.api.service.ModelRelateService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SqlExternalApiUtil {
    private static Map<String, OperatorType> operatorTypeMap = new HashMap<String, OperatorType>();
    private static ModelRelateService modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class);

    private SqlExternalApiUtil() {
    }

    public static OperatorType getOperatorType(String symbol) {
        return operatorTypeMap.get(symbol);
    }

    public static TableInfoDto getTableByName(String tableName, boolean check) {
        HussarException.throwByNull((Object)tableName, (String)"\u8868\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        HussarMetadataService metadataService = SqlExternalApiUtil.getHussarMetadataService();
        TableInfoDto tableInfo = metadataService.getTableInfoByName(tableName);
        if (check) {
            HussarException.throwByNull((Object)tableInfo, (String)String.format("\u83b7\u53d6\u5143\u6570\u636e\u4e3a\u7a7a:%s", tableName));
        }
        return tableInfo;
    }

    public static boolean insertTableInfo(MetadataParam paramData) {
        HussarException.throwByNull((Object)paramData, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarMetadataService metadataService = SqlExternalApiUtil.getHussarMetadataService();
        return metadataService.insertTableInfo(paramData);
    }

    private static HussarMetadataService getHussarMetadataService() {
        return (HussarMetadataService)SpringContextUtil.getBean(HussarMetadataService.class);
    }

    public static boolean updateTableInfo(MetadataParam paramData) {
        ModelRelateService modelRelateService;
        ModelRelationshipDto model;
        HussarException.throwByNull((Object)paramData, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (paramData.getTfModelId() != null && (model = (modelRelateService = (ModelRelateService)SpringContextUtil.getBean(ModelRelateService.class)).getModelByTfModelId(paramData.getTfModelId())) != null) {
            List modelColumns = model.getModelColumns();
            Map tfColumnId2Model = modelColumns.stream().filter(x -> x.getTfmodelColumnId() != null).collect(Collectors.toMap(ModelColumns::getTfmodelColumnId, Function.identity()));
            List columnInfo = paramData.getColumnInfo();
            columnInfo.forEach(column -> {
                if (tfColumnId2Model.containsKey(column.getTfModelColumnId())) {
                    column.setColumnId(((ModelColumns)tfColumnId2Model.get(column.getTfModelColumnId())).getColumnId());
                } else {
                    column.setColumnId(EngineUtil.getId());
                }
            });
        }
        HussarMetadataService metadataService = SqlExternalApiUtil.getHussarMetadataService();
        return metadataService.updateTableInfo(paramData);
    }

    public static SysDataSource getDataSourceName(String dataSourceName) {
        HussarException.throwByNull((Object)dataSourceName, (String)"\u6570\u636e\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringUtil.getBean(SysDataSourceService.class);
        SysDataSource dataSource = sysDataSourceService.getByConnName(dataSourceName);
        HussarException.throwByNull((Object)dataSource, (String)String.format("\u83b7\u53d6\u6570\u636e\u6e90\u4e3a\u7a7a:%s", dataSourceName));
        return dataSource;
    }

    public static ModelTableMappingDTO getTableById(String id) {
        return modelRelateService.getModelTableMapping(id);
    }

    public static ModelTableMappingDTO getRelationById(String id) {
        return modelRelateService.getModelTableMapping(id);
    }

    static {
        operatorTypeMap.put(DFSqlConnectEnum._GREAT_THAN.getKey(), OperatorType.GT);
        operatorTypeMap.put(DFSqlConnectEnum._GREAT_AND_THAN.getKey(), OperatorType.GE);
        operatorTypeMap.put(DFSqlConnectEnum._LESS_THAN.getKey(), OperatorType.LT);
        operatorTypeMap.put(DFSqlConnectEnum._LESS_AND_THAN.getKey(), OperatorType.LE);
        operatorTypeMap.put(DFSqlConnectEnum._EQUAL.getKey(), OperatorType.EQ);
        operatorTypeMap.put(DFSqlConnectEnum._NOT_EQUAL.getKey(), OperatorType.NE);
        operatorTypeMap.put(DFSqlConnectEnum._IN.getKey(), OperatorType.IN);
        operatorTypeMap.put(DFSqlConnectEnum._NOT_IN.getKey(), OperatorType.NOT_IN);
        operatorTypeMap.put(DFSqlConnectEnum._FULL_LIKE.getKey(), OperatorType.LIKE);
        operatorTypeMap.put(DFSqlConnectEnum._LEFT_LIKE.getKey(), OperatorType.LEFT_LIKE);
        operatorTypeMap.put(DFSqlConnectEnum._RIGHT_LIKE.getKey(), OperatorType.RIGHT_LIKE);
    }
}

